package com.supwisdom.dlpay.framework.dao;

import com.supwisdom.dlpay.framework.domain.TBusinesspara;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.stereotype.Repository;

import javax.persistence.LockModeType;
import javax.persistence.QueryHint;

@Repository
public interface BusinessparaDao extends JpaRepository<TBusinesspara, String> {
  TBusinesspara findByParakey(String parakey);

  @Lock(LockModeType.PESSIMISTIC_WRITE)
  @Query(value = " from TBusinesspara where parakey=?1 ")
  TBusinesspara findByParakeyForUpdate(String parakey);

  @Lock(LockModeType.PESSIMISTIC_WRITE)
  @QueryHints({@QueryHint(name = "javax.persistence.lock.timeout", value ="0")})
  @Query(value = " from TBusinesspara where parakey=?1 ")
  TBusinesspara findByParakeyForUpdateNowait(String parakey);
}
