package com.supwisdom.dlpay.framework.dao;

import com.supwisdom.dlpay.framework.data.NodeData;
import com.supwisdom.dlpay.framework.domain.TRoleFunction;
import com.supwisdom.dlpay.system.bean.ZTreeNode;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface RoleFunctionDao extends JpaRepository<TRoleFunction, String> {

    TRoleFunction findByRoleIdAndFunctionId(String roleId, Integer functionId);

    void deleteByFunctionId(Integer functionId);

    List<TRoleFunction> findByRoleId(String roleId);

    @Query(value = " select f.id||'' as id ,f.parentid||'' as pid,f.name,case when rf.id is null then 0 else 1 end as checked from tb_function f " +
            " left join tb_role_function rf on rf.functionid = f.id and rf.roleid=?1 " +
            " union all " +
            " select r.id||'_res' as id,r.function_id||'' as pid,r.name,case when p.id is null then 0 else 1 end as checked from tb_resource  r " +
            " left join tb_permission p on p.resid = r.id and p.roleid=?1 " , nativeQuery = true)
    List<NodeData> findByRoleIdNative(String roleId);

    void deleteByRoleId(String roleId);
}
