package com.supwisdom.dlpay.framework.dao;

import com.supwisdom.dlpay.framework.domain.TShop;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Query;

import javax.persistence.LockModeType;

/**
 * Created by shuwei on 2019/4/15.
 */
public interface ShopDao extends JpaRepository<TShop, Integer> {
    TShop getByThirdUniqueIdenty(String thirdUniqueIdenty);

    @Lock(LockModeType.PESSIMISTIC_WRITE)
    @Query("select a from TShop a where a.thirdUniqueIdenty=?1")
    TShop getByThirdUniqueIdentyForUpdate(String thirdUniqueIdenty);

    TShop getTShopByShopid(Integer shopid);

    TShop getTShopByShopaccno(String shopaccno);
}
