package com.supwisdom.dlpay.framework.dao;

import com.supwisdom.dlpay.framework.domain.TSyspara;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.stereotype.Repository;

import javax.persistence.LockModeType;
import javax.persistence.QueryHint;

@Repository
public interface SysparaDao extends JpaRepository<TSyspara, Integer> {
  TSyspara findByParaid(int paraid);

  @Lock(LockModeType.PESSIMISTIC_WRITE)
  @Query(value = "from TSyspara where paraid=?1 ")
  TSyspara findByParaidWithLock(int paraid);

  @Lock(LockModeType.PESSIMISTIC_WRITE)
  @QueryHints({@QueryHint(name = "javax.persistence.lock.timeout", value ="0")})
  @Query(value = "from TSyspara where paraid=?1 ")
  TSyspara findByParaidWithLockNowait(int paraid);
}
