package com.supwisdom.dlpay.system.service.impl;

import com.supwisdom.dlpay.api.bean.JsonResult;
import com.supwisdom.dlpay.framework.dao.*;
import com.supwisdom.dlpay.framework.data.NodeData;
import com.supwisdom.dlpay.framework.domain.TPermission;
import com.supwisdom.dlpay.framework.domain.TResource;
import com.supwisdom.dlpay.framework.domain.TRole;
import com.supwisdom.dlpay.framework.domain.TRoleFunction;
import com.supwisdom.dlpay.framework.util.DateUtil;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.system.bean.FunctionSearchBean;
import com.supwisdom.dlpay.system.bean.ZTreeNode;
import com.supwisdom.dlpay.system.service.RoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@Service
public class RoleServiceImpl implements RoleService {
    @Autowired
    private RoleDao roleDao;

    @Autowired
    private ResourceDao resourceDao;

    @Autowired
    private RoleFunctionDao roleFunctionDao;

    @Autowired
    private PermissionDao permissionDao;
    @Autowired
    private OperRoleDao operRoleDao;


    @Override
    public List<TRole> findAllRoles() {
        List<TRole> list = roleDao.getAllRoles();
        if (!StringUtil.isEmpty(list)) return list;
        return new ArrayList<>(0);
    }

    @Override
    public TRole findRoleByRoleid(String roleid) {
        Optional<TRole> role = roleDao.findById(roleid);
        if(role.isPresent()){
            return role.get();
        }
        return null;
    }

    @Override
    public TResource findResourceByURI(String uri) {
        return resourceDao.findByUri(uri);
    }

    @Override
    public TRoleFunction findRoleFunctionByRoleIdAndFunctionId(String roleid, Integer functionid) {
        return roleFunctionDao.findByRoleIdAndFunctionId(roleid, functionid);
    }

    @Override
    public PageResult<TRole> getRolesByKey(FunctionSearchBean param) {
        Pageable pageable = PageRequest.of(param.getPageNo() - 1, param.getPageSize()
                , Sort.by("createtime"));
        if (!StringUtil.isEmpty(param.getFunctioname())) {
            return new PageResult<>(roleDao.findAllByRoleNameContaining(param.getFunctioname(), pageable));
        }
        return new PageResult<>(roleDao.findAll(pageable));
    }

    @Override
    public JsonResult saveRole(TRole role) {
        if (!StringUtil.isEmpty(role.getRoleId())) {
            TRole temp = roleDao.findByRoleNameAndRoleIdNot(role.getRoleName(), role.getRoleId());
            if (temp != null) {
                return JsonResult.error("角色名称已存在");
            }
            Optional<TRole> opt = roleDao.findById(role.getRoleId());
            if (opt == null || !opt.isPresent()) {
                return JsonResult.error("角色已被删除");
            }
            temp = opt.get();
            temp.setRoleName(role.getRoleName());
            temp.setRoleDesc(role.getRoleDesc());
            temp.setRoleCode(role.getRoleCode());
            temp.setLastsaved(DateUtil.getNow());
            roleDao.save(temp);
        } else {
            TRole temp = roleDao.findByRoleName(role.getRoleName());
            if (temp != null) {
                return JsonResult.error("角色名称已存在");
            }

            role.setCreatetime(DateUtil.getNow());
            role.setEditflag(1);
            role.setRoleCode("ROLE_ADMIN");
            roleDao.save(role);
        }
        return JsonResult.ok("成功");
    }

    @Override
    public List<TRoleFunction> getRoleFuncByRoleid(String roleId) {
        return roleFunctionDao.findByRoleId(roleId);
    }


    @Override
    public TPermission findByRoleIdAndResid(String roleFuncId, Integer resid) {
        return permissionDao.findByRoleIdAndResid(roleFuncId, resid);
    }

    @Override
    public JsonResult saveRoleFuncId(String roleId, String funcs) {
        Optional<TRole> ret = roleDao.findById(roleId);
        if (ret == null || !ret.isPresent()) {
            return JsonResult.error("角色不存在");
        }
        roleFunctionDao.deleteByRoleId(roleId);
        permissionDao.deleteByRoleId(roleId);
        String[] datas = funcs.split(",");
        for (String func : datas) {
            if (func.contains("_res")) {
                String id = func.replace("_res", "");
                TPermission permission = new TPermission();
                permission.setResid(Integer.valueOf(id));
                permission.setRoleId(roleId);
                permissionDao.save(permission);
            } else {
                TRoleFunction roleFunction = new TRoleFunction();
                roleFunction.setFunctionId(Integer.valueOf(func));
                roleFunction.setRoleId(roleId);
                roleFunctionDao.save(roleFunction);
            }
        }
        return JsonResult.ok("成功");
    }

    @Override
    public List<ZTreeNode> findByRoleIdNative(String roleId) {
        List<NodeData> nodeData = roleFunctionDao.findByRoleIdNative(roleId);
        List<ZTreeNode> ret = new ArrayList<>();
        for (NodeData data : nodeData) {
            ZTreeNode zTreeNode = new ZTreeNode();
            zTreeNode.setpId(data.getPid());
            zTreeNode.setId(data.getId());
            zTreeNode.setName(data.getName());
            zTreeNode.setChecked(data.getChecked() == 0 ? false : true);
            zTreeNode.setOpen(true);
            ret.add(zTreeNode);
        }
        return ret;
    }

    @Override
    public JsonResult deleteRole(String roleid) {
        Optional<TRole> ret = roleDao.findById(roleid);
        if (ret == null || !ret.isPresent()) {
            return JsonResult.error("角色不存在");
        }
        if(ret.get().getEditflag()!=1){
            return JsonResult.error("该角色不能删除");
        }
        permissionDao.deleteByRoleId(roleid);
        roleFunctionDao.deleteByRoleId(roleid);
        operRoleDao.deleteByRoleId(roleid);
        roleDao.deleteById(roleid);
        return JsonResult.ok("成功");
    }
}
