package com.supwisdom.dlpay.api.dao;

import com.supwisdom.dlpay.api.domain.TPaytype;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * Created by shuwei on 2019/4/9.
 */
@Repository
public interface PaytypeDao extends JpaRepository<TPaytype, String> {
  TPaytype getByPaytype(String paytype);

  Page<TPaytype> findByPaytypeContaining(String paytype, Pageable pageable);

  @Query("select t from TPaytype t")
  List<TPaytype> getConsumePaytypes();
}
