package com.supwisdom.dlpay.framework.dao;

import com.supwisdom.dlpay.framework.data.MerchBean;
import com.supwisdom.dlpay.framework.data.SubjectInfoBean;
import com.supwisdom.dlpay.framework.domain.TSubjectbal;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import javax.persistence.LockModeType;
import java.util.List;

@Repository
public interface SubjectbalDao extends JpaRepository<TSubjectbal, String> {

  @Query(value = "select t.* from TB_SUBJECTBAL t left join ( select subjno from TB_SUBJECTDAY where accdate =:lastsettday) a on t.subjno=a.subjno where a.subjno is null ", nativeQuery = true)
  List<TSubjectbal> getUnsettleSubjectbal(@Param("lastsettday") String lastsettday);

  @Query(value = "select sum(BEGINDRBAL) as dramt,sum(BEGINCRBAL) as cramt from TB_SUBJECTBAL where SUBJNO in (select SUBJNO from TB_SUBJECT where fsubjno=:fsubjno) ", nativeQuery = true)
  MerchBean getSubjectInfo(@Param("fsubjno") String fsubjno);

  @Query(value = "select sa.subjno,sa.drbal,crbal,sb.subjtype,sb.balflag from TB_SUBJECTBAL sa,TB_SUBJECT sb where sa.subjno=sb.subjno and sb.endflag=1  order by sa.subjno ", nativeQuery = true)
  List<SubjectInfoBean> getSubjectbalAndFlag();

  @Query(value = "select case when :balflag=1 then sum(drbal) else sum(crbal) end as amount from tb_subjectbal where subjno in (select subjno from tb_subject where endflag=1 and balflag=:balflag )",nativeQuery = true)
  Double getSumEndsubjectBalByEndflag(@Param("balflag")Integer balflag);

  @Lock(LockModeType.PESSIMISTIC_WRITE)
  @Query("from TSubjectbal where subjno=:subjno ")
  TSubjectbal getTSubjectbalBySubjnoWithLock(@Param("subjno")String subjno);
}
