package com.supwisdom.dlpay.system.controller;

import com.supwisdom.dlpay.api.domain.TPersondtl;
import com.supwisdom.dlpay.api.domain.TShopdtl;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.framework.util.WebConstant;
import com.supwisdom.dlpay.system.bean.ShopdtlSearchBean;
import com.supwisdom.dlpay.system.bean.UserdtlSearchBean;
import com.supwisdom.dlpay.system.service.DtlDataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DtlController {
  @Autowired
  private DtlDataService dtlDataService;

  /**
   * ====================================================
   * 个人流水查询
   * ====================================================
   */
  @GetMapping("/dtl/userdtl")
  public String userdtlView() {
    return "system/dtl/userdtl";
  }

  @GetMapping("/dtl/userdtllist")
  @PreAuthorize("hasPermission('/dtl/userdtl','')")
  @ResponseBody
  public PageResult<TPersondtl> searchUserdtlPage(@RequestParam("page") Integer pageNo,
                                                  @RequestParam("limit") Integer pageSize,
                                                  @RequestParam(value = "paraid", required = false) Integer paraid,
                                                  @RequestParam(value = "paraname", required = false) String paraname) {
    try {
      if (null == pageNo || pageNo < 1) pageNo = WebConstant.PAGENO_DEFAULT;
      if (null == pageSize || pageSize < 1) pageSize = WebConstant.PAGESIZE_DEFAULT;
      UserdtlSearchBean searchBean = new UserdtlSearchBean();
      return dtlDataService.getPersondtlPage(searchBean, pageNo, pageSize);
    } catch (Exception e) {
      e.printStackTrace();
      return new PageResult<>(99, "系统查询错误");
    }
  }

  /**
   * ====================================================
   * 商户流水查询
   * ====================================================
   */
  @GetMapping("/dtl/shopdtl")
  public String shopdtlView() {
    return "system/dtl/shopdtl";
  }

  @GetMapping("/dtl/shopdtllist")
  @PreAuthorize("hasPermission('/dtl/shopdtl','')")
  @ResponseBody
  public PageResult<TShopdtl> searchUserdtlPage(@RequestParam("page") Integer pageNo,
                                                @RequestParam("limit") Integer pageSize,
                                                @RequestParam(value = "paraid", required = false) Integer paraid) {
    try {
      if (null == pageNo || pageNo < 1) pageNo = WebConstant.PAGENO_DEFAULT;
      if (null == pageSize || pageSize < 1) pageSize = WebConstant.PAGESIZE_DEFAULT;
      ShopdtlSearchBean searchBean = new ShopdtlSearchBean();
      return dtlDataService.getShopdtlPage(searchBean, pageNo, pageSize);
    } catch (Exception e) {
      e.printStackTrace();
      return new PageResult<>(99, "系统查询错误");
    }
  }

}
