package com.supwisdom.dlpay.system.service;

import com.supwisdom.dlpay.api.domain.TPaytype;
import com.supwisdom.dlpay.api.domain.TShopPaytype;
import com.supwisdom.dlpay.api.domain.TShopPaytypeConfig;
import com.supwisdom.dlpay.framework.domain.TShop;
import com.supwisdom.dlpay.framework.domain.TShopacc;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.system.bean.ShopConfigBean;
import com.supwisdom.dlpay.system.bean.ZTreeNode;
import com.supwisdom.dlpay.util.WebCheckException;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

public interface ShopDataService {
  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class,readOnly = true)
  List<ZTreeNode> getAllShopNodes();

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class,readOnly = true)
  TShop getShopByShopid(Integer shopid);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
  boolean deleteShop(TShop shop) throws WebCheckException;

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
  boolean saveOrUpdateShop(TShop shop) throws WebCheckException;

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class,readOnly = true)
  List<TPaytype> getConsumePaytypes();

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class,readOnly = true)
  PageResult<ShopConfigBean> getShopPaytypeInfos(String shopaccno, String paytype, int pageNo, int pageSize);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class,readOnly = true)
  TShopPaytype getShopPaytype(String shopaccno, String paytype);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class,readOnly = true)
  TShopacc getShopaccByAccno(String shopaccno);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
  boolean saveOrUpdateShopPaytype(TShopPaytype shopPaytype);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class,readOnly = true)
  List<TShopPaytypeConfig> getShopPaytypeConfigs(String shopaccno, String paytype);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
  boolean saveOrUpdateShopPaytypeConfig(String shopaccno, String paytype, Map<String, String> param) throws WebCheckException;


}
