package com.supwisdom.dlpay.doorlist.controller;

import cn.afterturn.easypoi.entity.vo.MapExcelConstants;
import cn.afterturn.easypoi.entity.vo.NormalExcelConstants;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.afterturn.easypoi.view.PoiBaseView;
import com.supwisdom.dlpay.api.bean.QueryUserParam;
import com.supwisdom.dlpay.api.bean.UserInforResponse;
import com.supwisdom.dlpay.doorlist.bean.*;
import com.supwisdom.dlpay.doorlist.service.DoorlistMgrService;
import com.supwisdom.dlpay.framework.domain.TOperator;
import com.supwisdom.dlpay.framework.util.DateUtil;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.mainservice.bean.TDoorcardlstInfo;
import com.supwisdom.dlpay.mainservice.domain.TCard;
import com.supwisdom.dlpay.mainservice.domain.TCustomer;
import com.supwisdom.dlpay.mainservice.service.WebInterfaceService;
import com.supwisdom.dlpay.ncmgr.domain.TBuilding;
import com.supwisdom.dlpay.ncmgr.domain.TNcAllottime;
import com.supwisdom.dlpay.ncmgr.domain.TNcAllottimeId;
import com.supwisdom.dlpay.ncmgr.domain.TNcCardlist;
import com.supwisdom.dlpay.ncmgr.service.NcService;
import com.supwisdom.dlpay.paysdk.ApiLoginHelper;
import com.supwisdom.dlpay.paysdk.proxy.ApiLoginProxy;
import com.supwisdom.dlpay.paysdk.proxy.UserProxy;
import com.supwisdom.dlpay.system.domain.TDictionaryId;
import com.supwisdom.dlpay.system.domain.TRegion;
import com.supwisdom.dlpay.system.domain.TSystemParam;
import com.supwisdom.dlpay.system.page.Pagination;
import com.supwisdom.dlpay.system.service.SystemService;
import com.supwisdom.dlpay.util.RedisUtil;
import com.supwisdom.dlpay.util.UploadExcelCardno;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.*;

@Controller
@RequestMapping("/doorlistMgr")
@EnableFeignClients(basePackages = "com.supwisdom.dlpay.paysdk")
@ComponentScan(basePackages = {"com.supwisdom.dlpay.paysdk"})
public class DoorlistMgrController {

    private static final String impcustomeFirstFlag = "IMPCUSTOME_FIRST_FLAG";

    private static final String impcustomeFirstTime = "IMPCUSTOME_FIRST_TIME";

    private static final String payapiAppid = "PAYAPI_APPID";

    private static final String payapiSecret = "PAYAPI_SECRET";

    protected static Logger logger = LoggerFactory.getLogger(DoorlistMgrController.class);

    @Autowired
    SystemService systemService;
    @Autowired
    WebInterfaceService webInterfaceService;
    @Autowired
    NcService ncService;
    @Autowired
    DoorlistMgrService doorlistMgrService;

    @RequestMapping("/downDoorList")
    public String downDoorList(ModelMap model) {
      return "doorlist/addDoorlist";
    }

    @RequestMapping("/deleteDoorList")
    public String deleteDoorList(ModelMap model) {
      return "doorlist/deleteDoorlist";
    }

    @RequestMapping("/searchDoorlist")
    public String searchDoorlist(ModelMap model) {
      return "doorlist/searchDoorlist";
    }

    @RequestMapping("/impCustomerlistindex")
    public String impCustomerlistindex(){
      return "doorlist/impCustomerlist";
    }

    /**
     * 填充查询门禁列表下拉菜单
     *
     * @return
     * @throws Exception
     */
    @ResponseBody
    @RequestMapping(value = "/getFillFormList")
    public Map getFillFormList(@AuthenticationPrincipal TOperator operUser) throws Exception {
      Map map = new HashMap();
      try {
        String opertype = operUser.getOpertype();
        //名单状态
        List<TDictionaryId> syncDicts = systemService.findTDictionaryByType(3);
        map.put("syncDicts", syncDicts);
        //操作标记
        List<TDictionaryId> operDicts = new ArrayList<TDictionaryId>();
        operDicts.addAll(systemService.findByType(2, "A"));
        operDicts.addAll(systemService.findByType(2, "D"));
        operDicts.addAll(systemService.findByType(2, "C"));
        map.put("operDicts", operDicts);

        List<TRegion> regions = null;
        List<TBuilding> buildings = null;
        if (!StringUtil.isEmpty(opertype) && (opertype.equals("S") || opertype.equals("P"))) {
          regions = systemService.getAllRegions();
          buildings = ncService.getAllBuilding();
          map.put("regions", regions);
          map.put("buildings", buildings);
        } else if (!StringUtil.isEmpty(operUser.getRegionid()) && opertype.equals("H")) {
          regions = systemService.getRegionListById(operUser.getRegionid());
          map.put("regions", regions);
          buildings = systemService.getBuildingByRegionId(operUser.getRegionid());
          map.put("buildings", buildings);
        }else if (opertype.equals("L")){
            map.put("regions", regions);
            buildings = systemService.getBuildingOperBuildings(operUser.getOperid());
            map.put("buildings", buildings);
        }

      } catch (Exception e) {
        e.printStackTrace();
      }
      return map;
    }

    /**
     * 查询设备名单
     *
     * @param request
     * @param buildingid
     * @param regionid
     * @param allocatStartDate
     * @param allocatEndDate
     * @param pageNo
     * @param pageSize
     * @param operUser
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/getAllCardList")
    public Map getAllCardList(HttpServletRequest request,
                              @RequestParam(value = "devname", required = false, defaultValue = "") String devname,
                              @RequestParam(value = "custname", required = false, defaultValue = "") String custname,
                              @RequestParam(value = "cardno", required = false, defaultValue = "") String cardno,
                              @RequestParam(value = "syncflag", required = false, defaultValue = "all") String syncflag,
                              @RequestParam(value = "operflag", required = false, defaultValue = "all") String operflag,
                              @RequestParam(value = "buildingid", required = false, defaultValue = "") String buildingid,
                              @RequestParam(value = "regionid", required = false, defaultValue = "") String regionid,
                              @RequestParam(value = "allocatStartDate", required = false, defaultValue = "") String allocatStartDate,
                              @RequestParam(value = "allocatEndDate", required = false, defaultValue = "") String allocatEndDate,
                              @RequestParam(value = "pageNo", required = false, defaultValue = "1") int pageNo,
                              @RequestParam(value = "pageSize", required = false, defaultValue = "15") int pageSize,
                              @AuthenticationPrincipal TOperator operUser) {

      Map map = new HashMap();
      try {
        String opertype = operUser.getOpertype();
        boolean flag = true;
        Pagination pResult = new Pagination();
        if (!StringUtil.isEmpty(opertype) && (opertype.equals("S") || opertype.equals("P"))) {
          pResult = webInterfaceService.getSystemCardListFrSearch(allocatStartDate, allocatEndDate, devname, custname,cardno, syncflag, operflag, buildingid, regionid, pageNo, pageSize);
        } else if (!StringUtil.isEmpty(operUser.getRegionid()) && opertype.equals("H")) {
          pResult = webInterfaceService.getOperatorCardListFrSearch(allocatStartDate, allocatEndDate, devname, custname, cardno, syncflag, operflag, buildingid, regionid, pageNo, pageSize, operUser.getRegionid());
        }else if (opertype.equals("L")){
            pResult = webInterfaceService.getBuildingOperCardListFrSearch(allocatStartDate, allocatEndDate, devname, custname, cardno, syncflag, operflag, buildingid, operUser.getOperid(), pageNo, pageSize);
        }
        map.put("PageResult", pResult);
        map.put("index", flag);
        map.put("result", "查询设备名单成功！");
      } catch (Exception e) {
        e.printStackTrace();
        map.put("result", "查询设备名单失败！");
        logger.error("查询设备名单失败：" + e.getMessage());
      }
      return map;
    }

    /**
     * 注解方式导出设备名单Excel
     *
     * @param modelMap
     * @param request
     * @param response
     * @param buildingid
     * @param regionid
     * @param allocatStartDate
     * @param allocatEndDate
     * @param operUser
     */
    @RequestMapping(value = "/exportExcel", method = RequestMethod.GET)
    public void download(ModelMap modelMap, HttpServletRequest request, HttpServletResponse response,
                         @RequestParam(value = "devname", required = false, defaultValue = "") String devname,
                         @RequestParam(value = "custname", required = false, defaultValue = "") String custname,
                         @RequestParam(value = "cardno", required = false, defaultValue = "") String cardno,
                         @RequestParam(value = "syncflag", required = false, defaultValue = "all") String syncflag,
                         @RequestParam(value = "operflag", required = false, defaultValue = "all") String operflag,
                         @RequestParam(value = "buildingid", required = false, defaultValue = "") String buildingid,
                         @RequestParam(value = "regionid", required = false, defaultValue = "") String regionid,
                         @RequestParam(value = "allocatStartDate", required = false, defaultValue = "") String allocatStartDate,
                         @RequestParam(value = "allocatEndDate", required = false, defaultValue = "") String allocatEndDate,
                         @AuthenticationPrincipal TOperator operUser) {
      String opertype = operUser.getOpertype();
      /**
       * 1.查询值
       */
      List<TDoorcardlstInfo> cardList = null;
      if (!StringUtil.isEmpty(opertype) && (opertype.equals("S") || opertype.equals("P"))) {
        cardList = webInterfaceService.getSystemCardListMap(allocatStartDate, allocatEndDate,
            devname, custname, cardno, syncflag, operflag, buildingid, regionid);
      } else if (!StringUtil.isEmpty(operUser.getRegionid()) && opertype.equals("H")) {
        cardList = webInterfaceService.getOperatorCardListMap( allocatStartDate, allocatEndDate,
            devname, custname, cardno, syncflag, operflag, buildingid, regionid, operUser.getRegionid());
      }else if (opertype.equals("L")){
        cardList = webInterfaceService.getBuildingOperCardListMap(allocatStartDate, allocatEndDate, devname, custname, cardno, syncflag, operflag, buildingid, operUser.getOperid());
      }

      /**
       * 2.设置表格属性: title:标题  sheetName:工作簿名 type:表格类型
       */
      ExportParams params = new ExportParams("设备名单列表", "设备名单", ExcelType.XSSF);

      modelMap.put(NormalExcelConstants.DATA_LIST, cardList);//设置值
      modelMap.put(NormalExcelConstants.PARAMS, params);//设置属性
      modelMap.put(NormalExcelConstants.CLASS, TDoorcardlstInfo.class);
      modelMap.put(NormalExcelConstants.FILE_NAME, "下发设备名单");
      PoiBaseView.render(modelMap, request, response, NormalExcelConstants.EASYPOI_EXCEL_VIEW);

    }

    /**
     * 重新下发名单
     *
     * @param request
     * @param tDoorcardlstInfos
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/reSaveDoorCardList", method = {RequestMethod.POST})
    public Map reSaveDoorCardList(HttpServletRequest request,
                                  @RequestBody TDoorcardlstInfo[] tDoorcardlstInfos) {
      Map map = new HashMap();
      String msg = "";
      try {
        List<Long> listIds = new ArrayList<>();
        for (TDoorcardlstInfo tDoorcardlstInfo : tDoorcardlstInfos) {
          listIds.add(Long.valueOf(tDoorcardlstInfo.getListid()));
        }
        webInterfaceService.updateDoorcardlstToNoWithIds(listIds);
        RedisUtil.incr("zcard_max_version");
        map.put("result", "重新下发设备名单成功！");
      } catch (Exception e) {
        e.printStackTrace();
        map.put("result", "重新下发设备名单失败！");
        msg = "重新下发设备名单异常";
        logger.error("重定向出错：" + e.getMessage());
      }
      map.put("msg", msg);
      return map;
    }

    /**
     * 人员名单导入模板
     * @param request
     * @param response
     * @param map
     */
    @RequestMapping(value = "/downImpTemplate")
    public void downImpTemplate(HttpServletRequest request, HttpServletResponse response, ModelMap map) {
      try {
        List<ExcelExportEntity> entity = new ArrayList<ExcelExportEntity>();
        /**
         * 1. 设置列信息：name：列标题   key：	列属性
         */
          entity.add(new ExcelExportEntity("市民卡号(必填)", "cardno"));
        entity.add(new ExcelExportEntity("姓名", "custname"));
        entity.add(new ExcelExportEntity("银行卡号", "bankcarno"));
//        entity.add(new ExcelExportEntity("物理卡号()","cardphyid"));
//        entity.add(new ExcelExportEntity("性别", "sex"));
//        entity.add(new ExcelExportEntity("电子邮箱", "email"));
//        entity.add(new ExcelExportEntity("手机", "mobile"));
//        entity.add(new ExcelExportEntity("地址", "addr"));
//        entity.add(new ExcelExportEntity("注销日期", "closedate"));
        entity.add(new ExcelExportEntity("备注", "remarks"));
        List<Map> personList = new ArrayList<Map>();

        /**
         * 3.设置表格属性: title:标题  sheetName:工作簿名 type:表格类型
         */
        ExportParams params = new ExportParams(null, "sheet1", ExcelType.HSSF);
        map.put(MapExcelConstants.MAP_LIST, personList);
        map.put(MapExcelConstants.ENTITY_LIST, entity);
        map.put(MapExcelConstants.PARAMS, params);
        map.put(MapExcelConstants.FILE_NAME, "人员名单导入模板");//文件名
        map.put("result", "导出excel文件完成");
        PoiBaseView.render(map, request, response, MapExcelConstants.EASYPOI_MAP_EXCEL_VIEW);

      } catch (Exception e) {
        e.printStackTrace();
        map.put("result", "导出excel文件失败");
      }
    }

  /**
   * 人员名单导入
   * @param file
   * @param request
   * @return
   */
  @ResponseBody
    @RequestMapping(value = "/impDoorCardList", method = {RequestMethod.POST})
    public Map impDoorCardList(@RequestParam(value = "impCustomerlist_file", required = false) MultipartFile file,
                                  HttpServletRequest request,@AuthenticationPrincipal TOperator operUser) {
      Map map = new HashMap();
      try {
        //String sheetName = request.getParameter("sheetname");

        String path = request.getSession().getServletContext().getRealPath("upload");
        String fileName = file.getOriginalFilename();
        File targetFile = new File(path, fileName);
        if (!targetFile.exists()) {
          targetFile.mkdirs();
        }
        file.transferTo(targetFile);
        map = impCardList(path+"/"+fileName,operUser.getOperid(),map);


      } catch (Exception e) {
        e.printStackTrace();

      }
      return map;
    }


    @Autowired
    private ApiLoginProxy apiLoginProxy;

    @Autowired
    private UserProxy userProxy;


  private Map impCardList(String fpath,String operid,Map map) {

    String firstTime = "";
    ImportParams params = new ImportParams();
    params.setTitleRows(0);
    List<CustomerListBean> doorList = ExcelImportUtil.importExcel(new File(fpath), CustomerListBean.class, params);
    int totCnt = doorList.size();
    int flag =0;
    if (doorList.size() <= 0) {
      flag = -1;
      map.put("flag", flag);
      return map;
    }
    try {
        TSystemParam appidSystemParam = systemService.getSystemParamByKey(payapiAppid);
        String appid = appidSystemParam.getParamValue();
        TSystemParam secretSystemParam = systemService.getSystemParamByKey(payapiSecret);
        String secret = secretSystemParam.getParamValue();
      ApiLoginHelper helper = new ApiLoginHelper(apiLoginProxy);
      helper.login(appid, secret);

      String now = DateUtil.getNow();
      List<TNcCardlist> tmpNcCardList = new ArrayList<TNcCardlist>();
      List<TCard> tmpCardList = new ArrayList<TCard>();
      List<CustomerListBean> tCustomerNoExistInfos = new ArrayList<CustomerListBean>();
      int tmpi = 0;
      int succCnt = 0;
      int errCnt = 0;
      long startTime = System.currentTimeMillis();
        if (logger.isInfoEnabled()){
            logger.info("开始进行名单导入");
        }
      for (CustomerListBean list : doorList) {

        String cardno = list.getCardno();
        //String bankcardno = list.getBankcardno();

        if (StringUtil.isEmpty(cardno)){
          errCnt++;
          tCustomerNoExistInfos.add(list);
          continue;
        }
        //从核心平台验证此卡号用户是否存在
        QueryUserParam queryUserParam = new QueryUserParam();
          queryUserParam.setCitizencardno(cardno);
          UserInforResponse response = userProxy.querybycardno(queryUserParam);
        if (response.getRetcode() != 0){
            errCnt++;
            tCustomerNoExistInfos.add(list);
            continue;
        }
          if (logger.isInfoEnabled()){
              logger.info(cardno+"--核心平台验证通过，开始进行导入！");
          }
        succCnt++;
        tmpi++;
        TCustomer customer = webInterfaceService.findCustomerById(response.getUserid());
        if (customer != null) {//此用户已存在
            TCard card = webInterfaceService.findCardByCustid(customer.getCustid());

            customer.setStatus(customer.getStatus());
            customer.setCustname(response.getUsername());
//            customer.setSex(list.getSex());
//            customer.setEmail(list.getEmail());
//            customer.setMobile(list.getMobile());
//            customer.setAddr(list.getAddr());
            customer.setClosedate(response.getExpiredate());
            customer.setLastsavedtime(now);
            customer.setAddoperid(operid);
            customer.setRemark(list.getRemarks());
            webInterfaceService.saveCustomer(customer);

            //一个用户可能会有多个卡，补办新卡新增一条信息
            if (card!=null) {
                card.setCardphyid(response.getCardphyid());
                card.setExpiredate(response.getExpiredate());
                card.setStatus(response.getCardstatus());
                card.setTranstatus(response.getTransstatus());
                card.setCardverno(Integer.parseInt(card.getCardverno()) + 1 + "");
                card.setLastsavedtime(now);
                webInterfaceService.saveCard(card);
            }else {
                TCard cardTmp = new TCard();
                cardTmp.setCardno(list.getCardno());
                cardTmp.setBankcardno(response.getBankcardno());
                cardTmp.setCustid(response.getUserid());
                cardTmp.setCardphyid(response.getCardphyid());
                cardTmp.setExpiredate(response.getExpiredate());
                cardTmp.setStatus(response.getCardstatus());
                cardTmp.setTranstatus(response.getTransstatus());
                cardTmp.setCardverno("1");
                cardTmp.setLastsavedtime(now);
                webInterfaceService.saveCard(cardTmp);
            }

        }else {
            TCustomer customerTmp = new TCustomer();
            customerTmp.setCustid(response.getUserid());
            customerTmp.setStatus("1");
            customerTmp.setCustname(response.getUsername());
//            customerTmp.setSex(list.getSex());
//            customerTmp.setEmail(list.getEmail());
//            customerTmp.setMobile(list.getMobile());
//            customerTmp.setAddr(list.getAddr());
            customerTmp.setOpendate(now.substring(0, 8));
            customerTmp.setClosedate(response.getExpiredate());
            customerTmp.setLastsavedtime(now);
            customerTmp.setAddoperid(operid);
            customerTmp.setRemark(list.getRemarks());
            webInterfaceService.saveCustomer(customerTmp);

            TCard cardTmp = new TCard();
            cardTmp.setCardno(list.getCardno());
            cardTmp.setBankcardno(response.getBankcardno());
            cardTmp.setCustid(customerTmp.getCustid());
            cardTmp.setCardphyid(response.getCardphyid());
            cardTmp.setExpiredate(response.getExpiredate());
            cardTmp.setStatus(response.getCardstatus());
            cardTmp.setTranstatus(response.getTransstatus());
            cardTmp.setCardverno("1");
            cardTmp.setLastsavedtime(now);
            //cardTmp.setBankcardno(response.getBankcardno());
            webInterfaceService.saveCard(cardTmp);
        }
      }
      //获取结束时间
      long endTime = System.currentTimeMillis();
      logger.info("名单导入消耗时间： " + (endTime - startTime) + "ms");
      flag=1;

      //判断是否为第一次名单导入
        TSystemParam param = systemService.getSystemParamByKey(impcustomeFirstFlag);
        if ("0".equals(param.getParamValue())){
            systemService.updateSystemParamValueByKey(impcustomeFirstFlag, "1");
            systemService.updateSystemParamValueByKey(impcustomeFirstTime, now);//保存第一次名单导入时间
        }

      map.put("imp_totCnt",totCnt);
      map.put("imp_succCnt",succCnt);
      map.put("imp_errCnt",errCnt);
      map.put("tCustomerNoExistInfos", tCustomerNoExistInfos);
    }catch (Exception ex){
      logger.error("名单导入失败--"+ex.getMessage());
      flag=-2;
      map.put("flag", flag);
      return map;
    }
    map.put("flag", flag);
   return map;
  }

    /**
     * 获取要下发的人员名单
     * @param perName
     * @param cardno
     * @param bankcardno
     * @return
     */
  @ResponseBody
  @RequestMapping(value = "/getAllTCustomerList",method = RequestMethod.POST)
  public Map getAllTCustomerList(@RequestParam(value = "perName", required = false, defaultValue = "") String perName,
                                 @RequestParam(value = "cardno", required = false, defaultValue = "") String cardno,
                                 @RequestParam(value = "bankcardno", required = false, defaultValue = "") String bankcardno) {
        Map map = new HashMap();
        try {
            List<TCustomerInfo> pNotInResult = webInterfaceService.getAllTCustomerList(perName, cardno, bankcardno);
            Boolean countIndex = false;
            if (pNotInResult.size() > 4000) {
                countIndex = true;
            }
            map.put("pNotInResult", pNotInResult);
            map.put("countIndex", countIndex);
        }catch (Exception e){
            e.printStackTrace();
            logger.error("名单查询失败--"+e.getMessage());
        }
        return map;
    }

    /**
     * 下发名单导入查询模板下载
     * @param request
     * @param response
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/exportExcelTemplet")
    public Map exportExcelTemplet(HttpServletRequest request, HttpServletResponse response) {
      Map map = new HashMap();
        try {
            List<ExcelExportEntity> entity = new ArrayList<ExcelExportEntity>();
            /**
             * 1. 设置列信息：name：列标题   key：	列属性
             */
            entity.add(new ExcelExportEntity("卡号(必须项)", "cardno"));
            entity.add(new ExcelExportEntity("银行卡号(可选项)","bankcardno"));
            entity.add(new ExcelExportEntity("姓名", "custname"));
            List<Map> personList = new ArrayList<Map>();

            /**
             * 3.设置表格属性: title:标题  sheetName:工作簿名 type:表格类型
             */
            ExportParams params = new ExportParams(null, "sheet1", ExcelType.HSSF);
//		params.setFreezeCol(2);
            map.put(MapExcelConstants.MAP_LIST, personList);
            map.put(MapExcelConstants.ENTITY_LIST, entity);
            map.put(MapExcelConstants.PARAMS, params);
            map.put(MapExcelConstants.FILE_NAME, "查询模板");//文件名
            map.put("result", "导出excel文件完成");
            PoiBaseView.render(map, request, response, MapExcelConstants.EASYPOI_MAP_EXCEL_VIEW);
        } catch (Exception e) {
            e.printStackTrace();
            map.put("result", "导出excel文件失败");
        }
        return map;
    }

    /**
     * 导入查询人员名单
     * @param file
     * @param request
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/addexcel", method = {RequestMethod.POST})
    public Map addExcel(@RequestParam(value = "file", required = false, defaultValue = "") MultipartFile file,
                           HttpServletRequest request) {
        // 保存
        Map map = new HashMap();
        try {

            String sheetName = request.getParameter("sheetname");
            String path = request.getSession().getServletContext()
                    .getRealPath("upload");

            String fileName = file.getOriginalFilename();
            //impTest(path+"\\"+fileName);
            File targetFile = new File(path, fileName);
            if (!targetFile.exists()) {
                targetFile.mkdirs();
            }
            file.transferTo(targetFile);
            map = importExcel(map, sheetName, targetFile);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }


    private Map importExcel(Map map, String sheetName, File targetFile) {
        try {
            @SuppressWarnings("unchecked")
            List<List<String>> excelList = UploadExcelCardno.readExcel(targetFile, sheetName);//数据列
            boolean sheetindex = true;
            if (excelList == null) {
                sheetindex = false;
                map.put("sheetindex", sheetindex);
                return map;
            }
            int sumNum = excelList.size();
            int cardno = -1;
            int bankcardno =-1;
            int custnameNo = -1;
            List columlst = excelList.get(0);
            int i = 0;
            boolean contentidex = true;
            while (contentidex) {
                columlst = excelList.get(i++);
                int len = columlst.size();
                for (int j = 0; j < len; j++) {
                    if (columlst.get(j).toString().equals("卡号(必须项)")) {
                        cardno = j;
                        contentidex = false;
                    }
                    if (columlst.get(j).toString().equals("银行卡号(可选项)")){
                        bankcardno = j;
                        contentidex = false;
                    }
                    if (columlst.get(j).toString().equals("姓名")) {
                        custnameNo = j;
                        contentidex = false;
                    }
                }

            }

            boolean cardIndex = false;
            int queryNum = 0;
            int queryNoNum = 0;
            List<TCustomerInfo> tCustomerInfos = new ArrayList<TCustomerInfo>();
            List<TCustomerNoExistInfo> tCustomerNoExistInfos = new ArrayList<TCustomerNoExistInfo>();

            for (; i < sumNum; i++) {
                columlst = excelList.get(i);

                String cardStr = columlst.get(cardno).toString();
                String bankcardStr = columlst.get(bankcardno).toString();
                cardIndex = false;
                if (cardStr.length() > 0) {
                    TCustomerInfo tCustomerInfo = webInterfaceService.getTCustomerByExcel(cardStr);
                    if (tCustomerInfo == null) {
                        cardIndex = true;
                    } else {
                        tCustomerInfos.add(tCustomerInfo);
                        queryNum++;
                    }
                } else {
                    cardIndex = true;
                }
                if (cardIndex) {
                    queryNoNum++;
                    TCustomerNoExistInfo tCustomerNoExistInfo = new TCustomerNoExistInfo();
                    tCustomerNoExistInfo.setCardno(cardStr);
                    if (bankcardno > 0){
                        tCustomerNoExistInfo.setBankcardno(columlst.get(bankcardno).toString());
                    }
                    if (custnameNo > 0) {
                        tCustomerNoExistInfo.setCustname(columlst.get(custnameNo).toString());
                    }

                    tCustomerNoExistInfos.add(tCustomerNoExistInfo);
                }
            }

            map.put("queryNum", String.valueOf(queryNum));
            map.put("queryNoNum", queryNoNum);
            map.put("tCustomerInfos", tCustomerInfos);
            map.put("tCustomerNoExistInfos", tCustomerNoExistInfos);
            map.put("sheetindex", sheetindex);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return map;

    }


    /**
     * 获取设备查询区域和楼栋填充列表
     * @param operUser
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/getRegionAndBuildingList")
    public Map getRegionAndBuildingList(@AuthenticationPrincipal TOperator operUser){
        Map map = new HashMap();
        try{
            String opertype = operUser.getOpertype();
            List<TRegion> regions = null;
            List<TBuilding> buildings = null;
            if (!StringUtil.isEmpty(opertype) &&(opertype.equals("S")||opertype.equals("P"))){
                regions = systemService.getAllRegions();
                buildings = systemService.getAllBuildings();

            }else if (opertype.equals("H") && !StringUtil.isEmpty(operUser.getRegionid())){
                regions = systemService.getRegionListById(operUser.getRegionid());
                buildings = systemService.getOperatorBuildings(operUser.getRegionid());
            }else if (opertype.equals("L")){
                buildings = systemService.getBuildingOperBuildings(operUser.getOperid());
            }
            map.put("regions", regions);
            map.put("buildings", buildings);
        }catch (Exception e){
            e.printStackTrace();
            logger.error("获取区域和楼栋列表失败!", e.getMessage());
        }
        return map;
    }

    /**
     * 获取要分配的设备列表 --读头设备
     * @param request
     * @param deviceName
     * @param regionid
     * @param buildingid
     * @param usetype
     * @param operUser
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/getAllTDevgroupdtlList")
    public Map getAllTDevgroupdtlList(HttpServletRequest request,
                                         @RequestParam(value = "deviceName", required = false, defaultValue = "") String deviceName,
                                         @RequestParam(value = "regionid", required = false, defaultValue = "") String regionid,
                                         @RequestParam(value = "buildingid", required = false, defaultValue = "") String buildingid,
                                         @RequestParam(value = "usetype", required = false, defaultValue = "MJ") String usetype,
                                         @AuthenticationPrincipal TOperator operUser) {
        Map map = new HashMap();
        try {
            String opertype = operUser.getOpertype();
            List<TDoordevInfo> pResult = null;
            if (!StringUtil.isEmpty(opertype) &&(opertype.equals("S")||opertype.equals("P"))){
                pResult = ncService.getSystemDevList(deviceName,regionid,buildingid);
            }else if (opertype.equals("H") && !StringUtil.isEmpty(operUser.getRegionid())){
                pResult = ncService.getOperatorDevList(deviceName,regionid,buildingid,operUser.getRegionid());
            }else if (opertype.equals("L")){
                pResult = ncService.getBuildingOperDevList(deviceName,regionid,buildingid,operUser.getOperid());
            }
            map.put("pResult", pResult);
        }catch (Exception e){
            e.printStackTrace();
            logger.error("获取要分配设备列表失败!", e.getMessage());
        }
        return map;
    }

    /**
     * 分页获取要分配的时间段信息
     * @param timeName
     * @param pageNo
     * @param pageSize
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/getAllTDoortimeList")
    public Map getAllTDoortimeList(
                                      @RequestParam(value = "timeName", required = false, defaultValue = "") String timeName,
                                      @RequestParam(value = "pageNo", required = false, defaultValue = "1") int pageNo,
                                      @RequestParam(value = "pageSize", required = false, defaultValue = "10") int pageSize) {
        Map map = new HashMap();
        Pagination pResult = ncService.getNcWeekTimeWithPage(timeName, pageNo, pageSize, map);
        map.put("pResult", pResult);
        return map;
    }


    /**
     * 门禁名单下发
     * @param cardlistInfoModel
     * @param timeId
     * @param holidayId
     * @param devGroupId
     * @param usetype
     * @param request
     * @param operUser
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/saveDoorCardlist", method = {RequestMethod.POST})
    public Map saveDoorCardlist(
                                   @RequestBody CardlistInfoModel cardlistInfoModel,
                                   @RequestParam(value = "timeId", required = false, defaultValue = "") String timeId,
                                   @RequestParam(value = "holidayId", required = false, defaultValue = "") String holidayId,
                                   @RequestParam(value = "devGroupId", required = false, defaultValue = "") String devGroupId,
                                   @RequestParam(value = "usetype", required = false, defaultValue = "MJ") String usetype,
                                   HttpServletRequest request,@AuthenticationPrincipal TOperator operUser) {
        Map map = new HashMap();
        String msg = "";
        boolean okFlag = false;
        try {
            String[] timeIdArray = timeId.split(",");
            String[] holidayIdArray = null;
            if (!("").equals(holidayId)) {
                holidayIdArray = holidayId.split(",");
            }
            String[] devGroupIdArray = null;
            if (!("").equals(devGroupId)) {
                devGroupIdArray = devGroupId.split(",");
            }

            String reason = cardlistInfoModel.getReason();
            List<TDoordevInfo> tDevgroupdtlInfos = cardlistInfoModel.gettDevgroupdtlInfo();
            if (devGroupIdArray != null) {
                /*List<TDoordevInfo> tDevgroupdtlInfo = webInterfaceService.getTDevgroupdtlByGroupId(factoryId, devGroupIdArray);
                if (tDevgroupdtlInfo != null && tDevgroupdtlInfo.size() > 0) {
                    if (tDevgroupdtlInfos == null || tDevgroupdtlInfos.size() == 0) {
                        tDevgroupdtlInfos = tDevgroupdtlInfo;
                    } else {
                        tDevgroupdtlInfos.addAll(tDevgroupdtlInfo);
                    }
                }*/
            }

            List<TCustomerInfo> tCustomerInfos = cardlistInfoModel.gettCustomerInfo();
            List<TCustomerInfo> tCustomerInfo_import = cardlistInfoModel.gettCustomerInfo_import();
            if (tCustomerInfo_import != null && tCustomerInfo_import.size() > 0) {
                if (tCustomerInfos == null || tCustomerInfos.size() == 0) {
                    tCustomerInfos = cardlistInfoModel.gettCustomerInfo_import();
                } else {
                    tCustomerInfos.addAll(cardlistInfoModel.gettCustomerInfo_import());
                }
            }

            String now = DateUtil.getNow();
            List<TNcCardlist> tNcCardlists = new ArrayList<TNcCardlist>();
            List<TNcAllottime> tNcAllottimes = new ArrayList<TNcAllottime>();
            int tmpi=0;
            //long listid =0;
            long startTime=System.currentTimeMillis();   //获取开始时间
            for (TCustomerInfo card : tCustomerInfos) {
                for (TDoordevInfo dev : tDevgroupdtlInfos) {
                    //存在则直接更新状态，否则添加新记录
                    for (int i = 0; i < timeIdArray.length; i++) {
                        String timeid = timeIdArray[i];
                        tmpi++;
                        //listid++;
                        TNcCardlist cardlist = doorlistMgrService.getNcCardlist(dev.getDeviceid(), card.getCardphyid(), timeid);
                        if (cardlist != null) {
                            cardlist.setOperflag("A");
                            cardlist.setOperid(operUser.getOperid());
                            cardlist.setSyncflag("N");
                            cardlist.setSynctime("");
                            cardlist.setRectime(now);
                            cardlist.setReason(reason);
                            cardlist.setVersion(cardlist.getVersion()+1);
                            tNcCardlists.add(cardlist);
                            //webInterfaceService.saveTDoorcardlst(doorlst);
                        } else {
                            //long listid = webInterfaceService.getNextSeqTDoorcardlst();
                            //从缓存读取列表值并加1
                            long listid = RedisUtil.incr("seq_cardlist");
                            TNcCardlist tmpCardlist = new TNcCardlist();
                            tmpCardlist.setListid(listid+"");
                            tmpCardlist.setCustid(card.getCustid());
                            tmpCardlist.setCustname(card.getCustname());
                            tmpCardlist.setCardno(card.getCardno());
                            tmpCardlist.setBankcardno(card.getBankcardno());
                            tmpCardlist.setCardphyid(card.getCardphyid());
                            tmpCardlist.setClosedate(card.getExpiredate());
                            tmpCardlist.setDeviceid(dev.getDeviceid());
                            tmpCardlist.setOperflag("A");
                            tmpCardlist.setRectime(now);
                            tmpCardlist.setSynctime("");
                            tmpCardlist.setSyncflag("N");
                            tmpCardlist.setRtnflag("Y");
                            tmpCardlist.setRtntime(now);
                            tmpCardlist.setVersion(1);
                            tmpCardlist.setOperid(operUser.getOperid());
                            tmpCardlist.setReason(reason);

                            tNcCardlists.add(tmpCardlist);

                            //webInterfaceService.saveTDoorcardlst(tDoorcardlst);

                            TNcAllottimeId tNcAllottimeId = new TNcAllottimeId();
                            tNcAllottimeId.setListid(listid+"");
                            tNcAllottimeId.setTimeid(timeIdArray[i]);
                            TNcAllottime tNcAllottime = new TNcAllottime();
                            tNcAllottime.setDeviceid(dev.getDeviceid());
                            tNcAllottime.setId(tNcAllottimeId);

                            tNcAllottimes.add(tNcAllottime);
                            //long end1=System.currentTimeMillis(); //获取结束时间
                            //System.out.println("程序运行时间： "+(end1-start1)+"ms");
                            if (tmpi>=500){
                                doorlistMgrService.batchSaveCardList(tNcCardlists);
                                doorlistMgrService.batchSaveAllotTime(tNcAllottimes);
                                RedisUtil.incr("zcard_max_version");
                                tNcCardlists.clear();
                                tNcAllottimes.clear();
                                tmpi=0;
                            }

                            //webInterfaceService.saveTAllottime(tAllottime);

                            if (holidayIdArray != null) {
                               /* for (int j = 0; j < holidayIdArray.length; j++) {
                                    TAllotholidayId tAllotholidayId = new TAllotholidayId();
                                    tAllotholidayId.setListid(listid);
                                    tAllotholidayId.setHolidayid(holidayIdArray[j]);
                                    TAllotholiday tAllotholiday = new TAllotholiday();
                                    tAllotholiday.setId(tAllotholidayId);
                                    tAllotholiday.setFactoryid(factoryId);
                                    webInterfaceService.saveTAllotholiday(tAllotholiday);
                                }*/
                            }

                        }
                    }


                }
            }
            long endTime=System.currentTimeMillis(); //获取结束时间
            System.out.println("下发名单消耗时间： "+(endTime-startTime)+"ms");
            if (tNcCardlists.size()>0) {
                doorlistMgrService.batchSaveCardList(tNcCardlists);
                RedisUtil.incr("zcard_max_version");
            }
            if (tNcAllottimes.size()>0) {
                doorlistMgrService.batchSaveAllotTime(tNcAllottimes);
            }



            map.put("result", "下发设备名单成功！");
            okFlag = true;
            msg = "下发设备名单成功！";
        } catch (Exception e) {
            e.printStackTrace();
            map.put("result", "下发设备名单失败！");
            msg = "下发设备名单异常";
            logger.error("下发设备名单异常：" + e.getMessage());
        }
        map.put("okFlag", okFlag);
        map.put("msg", msg);
        return map;
    }


    /**
     * 分页获取要删除的名单列表
     * @param request
     * @param devname
     * @param custname
     * @param cardno
     * @param syncflag
     * @param regionid
     * @param allocatStartDate
     * @param allocatEndDate
     * @param operflag
     * @param pageNo
     * @param pageSize
     * @param usetype
     * @param operUser
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/getAllCardListFrDelete", method = RequestMethod.POST)
    public Map getAllCardListFrDelete( HttpServletRequest request,
                                         @RequestParam(value = "devname", required = false, defaultValue = "") String devname,
                                         @RequestParam(value = "custname", required = false, defaultValue = "") String custname,
                                         @RequestParam(value = "cardno", required = false, defaultValue = "") String cardno,
                                         @RequestParam(value = "syncflag", required = false, defaultValue = "") String syncflag,
                                         @RequestParam(value = "regionid",required = false,defaultValue = "") String regionid,
                                         @RequestParam(value = "allocatStartDate", required = false, defaultValue = "") String allocatStartDate,
                                         @RequestParam(value = "allocatEndDate", required = false, defaultValue = "") String allocatEndDate,
                                         @RequestParam(value = "operflag", required = false, defaultValue = "") String operflag,
                                         @RequestParam(value = "pageNo", required = false, defaultValue = "1") int pageNo,
                                         @RequestParam(value = "pageSize", required = false, defaultValue = "15") int pageSize,
                                         @RequestParam(value = "usetype", required = false, defaultValue = "MJ") String usetype,
                                         @AuthenticationPrincipal TOperator operUser) {
        Map map = new HashMap();
        Pagination pResult = null;
        boolean index = true;
        try {
            /*SimpleDateFormat ymdhms = new SimpleDateFormat("yyyyMMdd");
            if (("").equals(allocatStartDate)) {
                Calendar now = Calendar.getInstance();
                allocatEndDate = ymdhms.format(now.getTime());
                allocatStartDate = lastWeek();
                map.put("endDate", allocatEndDate);
                map.put("startDate", allocatStartDate);
                index = false;
            }*/

            String opertype = operUser.getOpertype();
            if (!StringUtil.isEmpty(opertype) &&(opertype.equals("S")||opertype.equals("P"))){
                pResult = doorlistMgrService.getSystemCardList(devname, custname, cardno, syncflag, regionid, allocatStartDate, allocatEndDate, operflag, pageNo, pageSize);
            }else if (opertype.equals("H") && !StringUtil.isEmpty(operUser.getRegionid())){
                pResult = doorlistMgrService.getOperatorCardList(devname, custname, cardno, syncflag, regionid, allocatStartDate, allocatEndDate, operflag, pageNo, pageSize, operUser.getRegionid());
            }else if (opertype.equals("L")){
                pResult = doorlistMgrService.getBuildingOperCardList(devname, custname, cardno, syncflag, allocatStartDate, allocatEndDate, operflag, pageNo, pageSize, operUser.getOperid());
            }
        }catch (Exception e){
            e.printStackTrace();
            logger.error("查询删除名单失败!", e.getMessage());
        }
        map.put("pResult", pResult);
        map.put("index", index);
        return map;
    }

    private String lastWeek() {
        Calendar now = Calendar.getInstance();
        now.add(Calendar.DAY_OF_YEAR, -7);
        SimpleDateFormat ymd = new SimpleDateFormat("yyyyMMdd");
        return ymd.format(now.getTime());
    }

    /**
     * 获取删除名单填充数据
     * @param operUser
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/getDelFillFormList")
    public Map getDelFillFormList(@AuthenticationPrincipal TOperator operUser) {
        Map map = new HashMap();
        //名单状态
        List<TDictionaryId> syncDicts = systemService.findTDictionaryByType(3);
        map.put("syncDicts", syncDicts);
        //操作标记
        List<TDictionaryId> operDicts = new ArrayList<TDictionaryId>();
        operDicts.addAll(systemService.findByType(2, "A"));
        operDicts.addAll(systemService.findByType(2, "D"));
        operDicts.addAll(systemService.findByType(2, "C"));
        map.put("operDicts", operDicts);
        //区域
        String opertype = operUser.getOpertype();
        List<TRegion> regions = null;
        if (!StringUtil.isEmpty(opertype) &&(opertype.equals("S")||opertype.equals("P"))) {
            regions = systemService.getAllRegions();
            map.put("regions", regions);
        }else if (opertype.equals("H") && !StringUtil.isEmpty(operUser.getRegionid())){
            regions = systemService.getRegionListById(operUser.getRegionid());
            map.put("regions", regions);
        }else if (opertype.equals("L")){
            map.put("regions", regions);
        }
        return map;
    }

    /**
     * 删除设备名单
     * @param tNcCardlistDeleteInfos
     * @param operUser
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/saveDoorDeleteCardlist", method = {RequestMethod.POST})
    public Map saveDoorDeleteCardlist(
                                         @RequestBody TNcCardlistDeleteInfo[] tNcCardlistDeleteInfos,
                                         @AuthenticationPrincipal TOperator operUser) {
        Map map = new HashMap();
        try {
            String now = DateUtil.getNow();
            for (TNcCardlistDeleteInfo card:tNcCardlistDeleteInfos) {
                String listid = card.getListid();
                TNcCardlist ncCardlist = doorlistMgrService.getNcCardlistById(listid);
                if (ncCardlist != null) {
                    ncCardlist.setRectime(now);
                    ncCardlist.setOperflag("D");
                    ncCardlist.setSyncflag("N");
                    ncCardlist.setSynctime("");
                    ncCardlist.setOperid(operUser.getOperid());
                    ncCardlist.setVersion(ncCardlist.getVersion()+1);
                    doorlistMgrService.updateNcCardlist(ncCardlist);
                    RedisUtil.incr("zcard_max_version");
                }
            }
            map.put("result", "删除名单成功！");
        } catch (Exception e) {
            e.printStackTrace();
            map.put("result", "删除设备名单失败！");
            logger.error("删除设备名单失败：" + e.getMessage());
        }
        return map;
    }
}
