package com.supwisdom.dlpay.framework.dao;

import com.supwisdom.dlpay.framework.domain.TRole;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface RoleDao extends JpaRepository<TRole, String> {
    @Query("from TRole order by createtime asc ")
    List<TRole> getAllRoles();

    List<TRole> getAllByOperid(String operid);

    TRole findByRoleCode(String roleCode);

    Page<TRole> findAllByRoleNameContaining(String roleName, Pageable pageable);

    TRole findByRoleNameAndRoleIdNot(String roleName, String roleId);

    TRole findByRoleCodeAndRoleIdNot(String roleCode, String roleId);

    TRole findByRoleName(String roleName);

    Page<TRole> findAllByOperidAndRoleNameContaining(String operid,String roleName, Pageable pageable);

    Page<TRole> findAllByOperid(String operid, Pageable pageable);
}
