package com.supwisdom.dlpay.mainservice.dao.impl;

import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.mainservice.bean.TDoorcardlstInfo;
import com.supwisdom.dlpay.mainservice.dao.CardListDao;
import com.supwisdom.dlpay.system.dao.DictionaryDao;
import com.supwisdom.dlpay.system.page.Pagination;
import com.supwisdom.dlpay.util.RedisUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

@Repository
public class CardListDaoImpl implements CardListDao {

    @PersistenceContext
    EntityManager entityManager;

    @Autowired
    DictionaryDao dictionaryDao;

    @Transactional(readOnly = true)
    @Override
    public Pagination getSystemCardListFrSearch(String allocatStartDate, String allocatEndDate, String devname, String custname, String cardno, String syncflag, String operflag, String buildingid,String regionid, int pageNo, int pageSize) {
        try {

            String queryString = "select a.listid,b.devname,a.custname,a.cardno,a.bankcardno,d.opername," +
                    "a.syncflag,a.operflag,a.rectime,a.synctime,a.closedate," +
                    "a.reason ,b.buildingname,c.regionname" +
                    " from t_nc_cardlist a " +
                    " left join tb_operator d on a.operid=d.operid," +
                    " t_nc_device b " +
                    " left join tb_region c on b.regionid=c.regionid " +
                    " where 1>0 and a.deviceid=b.deviceid " ;
            if (!"".equals(allocatStartDate)) {
                queryString += " and a.rectime>=:allocatStartDate ";
            }
            if (!"".equals(allocatEndDate)) {
                queryString += " and a.rectime<=:allocatEndDate ";
            }
            if (!("all").equals(syncflag)) {
                queryString += " and a.syncflag =:syncflag";
            }

            if (!("").equals(devname)) {
                queryString += " and b.devname like :devname ";
            }
            if (!("all").equals(operflag)) {
                queryString += " and a.operflag =:operflag ";
            }
            if (!("").equals(buildingid)) {
                queryString += " and b.buildingid = :buildingid ";
            }
            if (!regionid.equals("")){
                queryString += " and b.regionid in  "
                        +"("
                        + "with recursive tmp as  "
                        + "("
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr where regionid = :regionid  "
                        + "union all  "
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  "
                        + ") select regionid from tmp  ) ";
            }
            if (!("").equals(custname)) {
                queryString += " and a.custname like :custname ";
            }
            if (!("").equals(cardno)) {
                queryString += " and a.cardno like :cardno ";
            }
            queryString += " ORDER by a.listid DESC ";

            Query query = entityManager.createNativeQuery(queryString, TDoorcardlstInfo.class);

            if (!"".equals(allocatStartDate)) {
                query.setParameter("allocatStartDate", allocatStartDate + "000000");
            }
            if (!"".equals(allocatEndDate)) {
                query.setParameter("allocatEndDate", allocatEndDate + "235959");
            }


            if (!("all").equals(syncflag)) {
                query.setParameter("syncflag", syncflag);
            }
            if (!("").equals(devname)) {
                query.setParameter("devname", "%" + devname + "%");
            }
            if (!("all").equals(operflag)) {
                query.setParameter("operflag", operflag);
            }
            if (!("").equals(buildingid)) {
                query.setParameter("buildingid", buildingid);
            }
            if (!("").equals(regionid)){
                query.setParameter("regionid", regionid);
            }
            if (!("").equals(custname)) {
                query.setParameter("custname", "%" + custname + "%");
            }
            if (!("").equals(cardno)) {
                query.setParameter("cardno", cardno);
            }

            pageNo = pageNo <= 0 ? 1 : pageNo;
            query.setFirstResult((pageNo - 1) * pageSize);
            query.setMaxResults(pageSize);
            Pagination page = new Pagination();
            page.setPageNo(pageNo);
            page.setPageSize(pageSize);

            int totalCount = getSystemCardListCount(allocatStartDate, allocatEndDate, devname, custname, cardno, syncflag, operflag, buildingid, regionid);
            page.setTotalCount(totalCount);

            List<TDoorcardlstInfo> tDoorcardlstInfos = query.getResultList();
            /*SimpleDateFormat _ymdhms = new SimpleDateFormat("yyyyMMddHHmmss");
            SimpleDateFormat ymdhms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (TDoorcardlstInfo grp : tDoorcardlstInfos) {
                List<String> factory = RedisUtil.lrange("dict_4", 0, -1);
                List<String> operFlag = RedisUtil.lrange("dict_2", 0, -1);
                List<String> sync = RedisUtil.lrange("dict_3", 0, -1);
                if(operflag!= null && operFlag.size()>0){
                    String operFlagIndex = grp.getOperflag();
                    for (String s : operFlag) {
                        String[] split = s.split("_");
                        if (operFlagIndex.equals(split[0])){
                            grp.setOperflag(split[1]);
                            break;
                        }
                    }
                }
                if(sync!= null && sync.size()>0){
                    String syncStatus1 = grp.getSyncflag();
                    for (String s : sync) {
                        String[] split = s.split("_");
                        if (syncStatus1.equals(split[0])){
                            grp.setSyncflag(split[1]);
                            break;
                        }else {
                            grp.setSyncflag("");
                        }
                    }
                }


                String time = grp.getRectime();
                Date date;
                String hms = "000000";
                if (time != null) {
                    if (time.length() == 14) {
                        date = _ymdhms.parse(time);
                        grp.setRectime(ymdhms.format(date));
                    } else {

                        time += hms.substring(0, 14 - time.length());
                        date = _ymdhms.parse(time + "");
                        grp.setRectime(ymdhms.format(date));
                    }

                }

                time = grp.getSynctime();
                if (time != null) {
                    if (time.length() == 14) {
                        date = _ymdhms.parse(time);
                        grp.setSynctime(ymdhms.format(date));
                    } else {
                        time += hms.substring(0, 14 - time.length());
                        date = _ymdhms.parse(time);
                        grp.setSynctime(ymdhms.format(date));
                    }

                }

            }
*/
            page.setList(tDoorcardlstInfos);
            return page;
        }catch (Exception e){
            e.printStackTrace();
        }
        return null;
    }

    private int getSystemCardListCount(String allocatStartDate, String allocatEndDate, String devname, String custname, String cardno, String syncflag, String operflag, String buildingid,String regionid){
        try {
            String queryString = "select count(*) from t_nc_cardlist a," +
                    " t_nc_device b "+
                    " left join tb_region c on b.regionid=c.regionid " +
                    " where 1>0 and a.deviceid = b.deviceid ";

            if (!"".equals(allocatStartDate)) {
                queryString += " and a.rectime>=:allocatStartDate ";
            }
            if (!"".equals(allocatEndDate)) {
                queryString += " and a.rectime<=:allocatEndDate ";
            }
            if (!("all").equals(syncflag)) {
                queryString += " and a.syncflag =:syncflag ";
            }
            if (!("all").equals(operflag)) {
                queryString += " and a.operflag =:operflag ";
            }
            if (!("").equals(buildingid)) {
                queryString += " and b.buildingid = :buildingid ";
            }
            if (!regionid.equals("")){
                queryString += " and b.regionid in  "
                        +"("
                        + "with recursive tmp as  "
                        + "("
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr where regionid = :regionid  "
                        + "union all  "
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  "
                        + ") select regionid from tmp  ) ";
            }
            if (!("").equals(devname)) {
                queryString += " and b.devname like :devname ";
            }
            if (!("").equals(custname)) {
                queryString += " and a.custname like :custname ";
            }
            if (!("").equals(cardno)) {
                queryString += " and a.cardno like :cardno ";
            }
            Query query = entityManager.createNativeQuery(queryString);
            if (!"".equals(allocatStartDate)) {
                query.setParameter("allocatStartDate", allocatStartDate + "000000");
            }
            if (!"".equals(allocatEndDate)) {
                query.setParameter("allocatEndDate", allocatEndDate + "235959");
            }

            if (!("all").equals(syncflag)) {
                query.setParameter("syncflag", syncflag);
            }

            if (!("all").equals(operflag)) {
                query.setParameter("operflag", operflag);
            }
            if (!("").equals(buildingid)) {
                query.setParameter("buildingid", buildingid);
            }
            if (!("").equals(regionid)){
                query.setParameter("regionid", regionid);
            }
            if (!("").equals(devname)) {
                query.setParameter("devname", "%" + devname + "%");
            }
            if (!("").equals(custname)) {
                query.setParameter("custname", "%" + custname + "%");
            }
            if (!("").equals(cardno)) {
                query.setParameter("cardno", cardno);
            }
            int cnt = 0;
            List list = query.getResultList();
            if (list!=null && list.size()>0){
                Object o = list.get(0);
                cnt = Integer.parseInt(o.toString());
            }
            return cnt;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    @Transactional
    @Override
    public Pagination getOperatorCardListFrSearch( String allocatStartDate, String allocatEndDate, String devname, String custname, String cardno, String syncflag, String operflag, String buildingid, String regionid, int pageNo, int pageSize, String operRegionid) {
        try {

            String queryString = "select a.listid,b.devname,a.custname,a.cardno,a.bankcardno,d.opername," +
                    "a.syncflag,a.operflag,a.rectime,a.synctime,a.closedate," +
                    "a.reason ,b.buildingname,c.regionname" +
                    " from t_nc_cardlist a " +
                    " left join tb_operator d on a.operid=d.operid," +
                    " t_nc_device b " +
                    " left join tb_region c on b.regionid=c.regionid " +
                    " where 1>0 and a.deviceid = b.deviceid " ;
            if (!"".equals(allocatStartDate)) {
                queryString += " and a.rectime>=:allocatStartDate ";
            }
            if (!"".equals(allocatEndDate)) {
                queryString += " and a.rectime<=:allocatEndDate ";
            }
            if (!("all").equals(syncflag)) {
                queryString += " and a.syncflag =:syncflag";
            }
            if (!("").equals(devname)) {
                queryString += " and b.devname like :devname";
            }
            if (!("all").equals(operflag)) {
                queryString += " and a.operflag = :operflag ";
            }
            if (!("").equals(buildingid)) {
                queryString += " and b.buildingid = :buildingid ";
            }

                queryString += " and b.regionid in  "
                        +"("
                        + "with recursive tmp as  "
                        + "("
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr where regionid = :regionid  "
                        + "union all  "
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  "
                        + ") select regionid from tmp  ) ";

            if (!("").equals(custname)) {
                queryString += " and a.custname like :custname ";
            }
            if (!("").equals(cardno)) {
                queryString += " and a.cardno like :cardno ";
            }
            queryString += " ORDER by a.listid DESC ";

            Query query = entityManager.createNativeQuery(queryString, TDoorcardlstInfo.class);

            if (!"".equals(allocatStartDate)) {
                query.setParameter("allocatStartDate", allocatStartDate + "000000");
            }
            if (!"".equals(allocatEndDate)) {
                query.setParameter("allocatEndDate", allocatEndDate + "235959");
            }


            if (!("all").equals(syncflag)) {
                query.setParameter("syncflag", syncflag);
            }
            if (!("").equals(devname)) {
                query.setParameter("devname", "%" + devname + "%");
            }
            if (!("all").equals(operflag)) {
                query.setParameter("operflag", operflag);
            }
            if (!("").equals(buildingid)) {
                query.setParameter("buildingid", buildingid);
            }
            if (!("").equals(regionid)){
                query.setParameter("regionid", regionid);
            }else {
                query.setParameter("regionid", operRegionid );
            }
            if (!("").equals(custname)) {
                query.setParameter("custname", "%" + custname + "%");
            }
            if (!("").equals(cardno)) {
                query.setParameter("cardno", cardno);
            }

            pageNo = pageNo <= 0 ? 1 : pageNo;
            query.setFirstResult((pageNo - 1) * pageSize);
            query.setMaxResults(pageSize);
            Pagination page = new Pagination();
            page.setPageNo(pageNo);
            page.setPageSize(pageSize);

            int totalCount = getOperatorCardListCount(allocatStartDate, allocatEndDate, devname, custname, cardno, syncflag, operflag, buildingid, regionid,operRegionid);
            page.setTotalCount(totalCount);

            List<TDoorcardlstInfo> tDoorcardlstInfos = query.getResultList();


            page.setList(tDoorcardlstInfos);
            return page;
        }catch (Exception e){
            e.printStackTrace();
        }
        return null;
    }

    private int getOperatorCardListCount(String allocatStartDate, String allocatEndDate, String devname, String custname, String cardno, String syncflag, String operflag, String buildingid,String regionid,String operRegionid){
        try {
            String queryString = "select count(*) from t_nc_cardlist a," +
                    " t_nc_device b "+
                    " left join tb_region c on b.regionid=c.regionid " +
                    "where 1>0 and a.deviceid = b.deviceid ";

            if (!"".equals(allocatStartDate)) {
                queryString += " and a.rectime>=:allocatStartDate ";
            }
            if (!"".equals(allocatEndDate)) {
                queryString += " and a.rectime<=:allocatEndDate ";
            }
            if (!("all").equals(syncflag)) {
                queryString += " and a.syncstatus =:syncStatus ";
            }
            if (!("all").equals(operflag)) {
                queryString += " and a.operflag =:operFlag ";
            }
            if (!("").equals(buildingid)) {
                queryString += " and b.buildingid = :buildingid ";
            }
                queryString += " and b.regionid in  "
                        +"("
                        + "with recursive tmp as  "
                        + "("
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr where regionid = :regionid  "
                        + "union all  "
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  "
                        + ") select regionid from tmp  ) ";
            if (!("").equals(devname)) {
                queryString += " and b.doorname like :devname ";
            }
            if (!("").equals(custname)) {
                queryString += " and a.custname like :custname ";
            }
            if (!("").equals(cardno)) {
                queryString += " and a.stuempno like :cardno ";
            }
            Query query = entityManager.createNativeQuery(queryString);
            if (!"".equals(allocatStartDate)) {
                query.setParameter("allocatStartDate", allocatStartDate + "000000");
            }
            if (!"".equals(allocatEndDate)) {
                query.setParameter("allocatEndDate", allocatEndDate + "235959");
            }


            if (!("all").equals(syncflag)) {
                query.setParameter("syncflag", syncflag);
            }
            if (!("").equals(devname)) {
                query.setParameter("devname", "%" + devname + "%");
            }
            if (!("all").equals(operflag)) {
                query.setParameter("operflag", operflag);
            }
            if (!("").equals(buildingid)) {
                query.setParameter("buildingid", buildingid);
            }
            if (!("").equals(regionid)){
                query.setParameter("regionid", regionid);
            }else {
                query.setParameter("regionid" ,operRegionid );
            }
            if (!("").equals(custname)) {
                query.setParameter("custname", "%" + custname + "%");
            }
            if (!("").equals(cardno)) {
                query.setParameter("cardno", cardno);
            }
            int cnt = 0;
            List list = query.getResultList();
            if (list!=null && list.size()>0){
                Object o = list.get(0);
                cnt = Integer.parseInt(o.toString());
            }
            return cnt;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    @Transactional
    @Override
    public Pagination getBuildingOperCardListFrSearch(String allocatStartDate, String allocatEndDate, String devname, String custname, String cardno, String syncflag, String operflag, String buildingid, String operid, int pageNo, int pageSize) {

        try {

            String queryString = "select a.listid,b.devname,a.custname,a.cardno,a.bankcardno,d.opername," +
                    "a.syncflag,a.operflag,a.rectime,a.synctime,a.closedate," +
                    "a.reason ,b.buildingname,c.regionname" +
                    " from t_nc_cardlist a " +
                    " left join tb_operator d on a.operid=d.operid," +
                    " t_nc_device b " +
                    " left join tb_region c on b.regionid=c.regionid " +
                    " left join t_operbuilding e on e.buildingid=b.buildingid "+
                    " where 1>0 and a.deviceid = b.deviceid and e.operid=:operid " ;
            if (!"".equals(allocatStartDate)) {
                queryString += " and a.rectime>=:allocatStartDate ";
            }
            if (!"".equals(allocatEndDate)) {
                queryString += " and a.rectime<=:allocatEndDate ";
            }
            if (!("all").equals(syncflag)) {
                queryString += " and a.syncflag =:syncflag ";
            }
            if (!("").equals(devname)) {
                queryString += " and b.devname like :devname ";
            }
            if (!("all").equals(operflag)) {
                queryString += " and a.operflag =:operflag ";
            }
            if (!("").equals(buildingid)) {
                queryString += " and b.buildingid = :buildingid ";
            }

            if (!("").equals(custname)) {
                queryString += " and a.custname like :custname ";
            }
            if (!("").equals(cardno)) {
                queryString += " and a.cardno like :cardno ";
            }
            queryString += " ORDER by a.listid DESC ";

            Query query = entityManager.createNativeQuery(queryString, TDoorcardlstInfo.class);
            query.setParameter("operid", operid);

            if (!"".equals(allocatStartDate)) {
                query.setParameter("allocatStartDate", allocatStartDate + "000000");
            }
            if (!"".equals(allocatEndDate)) {
                query.setParameter("allocatEndDate", allocatEndDate + "235959");
            }


            if (!("all").equals(syncflag)) {
                query.setParameter("syncflag", syncflag);
            }
            if (!("").equals(devname)) {
                query.setParameter("devname", "%" + devname + "%");
            }
            if (!("all").equals(operflag)) {
                query.setParameter("operflag", operflag);
            }
            if (!("").equals(buildingid)) {
                query.setParameter("buildingid", buildingid);
            }
            if (!("").equals(custname)) {
                query.setParameter("custname", "%" + custname + "%");
            }
            if (!("").equals(cardno)) {
                query.setParameter("cardno", cardno);
            }

            pageNo = pageNo <= 0 ? 1 : pageNo;
            query.setFirstResult((pageNo - 1) * pageSize);
            query.setMaxResults(pageSize);
            Pagination page = new Pagination();
            page.setPageNo(pageNo);
            page.setPageSize(pageSize);

            int totalCount = getBuildingOperCardListCount(allocatStartDate, allocatEndDate, devname, custname, cardno, syncflag, operflag, buildingid, operid);
            page.setTotalCount(totalCount);

            List<TDoorcardlstInfo> tDoorcardlstInfos = query.getResultList();
            SimpleDateFormat _ymdhms = new SimpleDateFormat("yyyyMMddHHmmss");
            SimpleDateFormat ymdhms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");


            page.setList(tDoorcardlstInfos);
            return page;
        }catch (Exception e){
            e.printStackTrace();
        }
        return null;
    }

    private int getBuildingOperCardListCount(String allocatStartDate, String allocatEndDate, String devname, String custname, String cardno, String syncflag, String operflag, String buildingid,String operid){
        try {
            String queryString = "select count(*) from t_nc_cardlist a," +
                    " t_nc_device b "+
                    " left join t_operbuilding e on e.buildingid=b.buildingid "+
                    " where 1>0 and a.deviceid = b.deviceid and e.operid=:operid " ;

            if (!"".equals(allocatStartDate)) {
                queryString += " and a.rectime>=:allocatStartDate ";
            }
            if (!"".equals(allocatEndDate)) {
                queryString += " and a.rectime<=:allocatEndDate ";
            }
            if (!("all").equals(syncflag)) {
                queryString += " and a.syncflag =:syncflag ";
            }
            if (!("all").equals(operflag)) {
                queryString += " and a.operflag =:operflag ";
            }
            if (!("").equals(buildingid)) {
                queryString += " and b.buildingid = :buildingid ";
            }
            if (!("").equals(devname)) {
                queryString += " and b.devname like :devname ";
            }
            if (!("").equals(custname)) {
                queryString += " and a.custname like :custname ";
            }
            if (!("").equals(cardno)) {
                queryString += " and a.cardno like :cardno ";
            }
            Query query = entityManager.createNativeQuery(queryString);
            query.setParameter("operid", operid);
            if (!"".equals(allocatStartDate)) {
                query.setParameter("allocatStartDate", allocatStartDate + "000000");
            }
            if (!"".equals(allocatEndDate)) {
                query.setParameter("allocatEndDate", allocatEndDate + "235959");
            }

            if (!("all").equals(syncflag)) {
                query.setParameter("syncflag", syncflag);
            }

            if (!("all").equals(operflag)) {
                query.setParameter("operflag", operflag);
            }
            if (!("").equals(buildingid)) {
                query.setParameter("buildingid", buildingid);
            }
            if (!("").equals(devname)) {
                query.setParameter("devname", "%" + devname + "%");
            }
            if (!("").equals(custname)) {
                query.setParameter("custname", "%" + custname + "%");
            }
            if (!("").equals(cardno)) {
                query.setParameter("cardno", cardno);
            }
            int cnt = 0;
            List list = query.getResultList();
            if (list!=null && list.size()>0){
                Object o = list.get(0);
                cnt = Integer.parseInt(o.toString());
            }
            return cnt;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    @Transactional
    @Override
    public List<TDoorcardlstInfo> getSystemCardListMap( String allocatStartDate, String allocatEndDate, String devname, String custname, String cardno, String syncflag, String operflag, String buildingid,String regionid) {
        try {
            String queryString = "select a.listid,b.devname,a.custname,a.cardno,a.bankcardno,d.opername," +
                    "a.syncflag,a.operflag,a.rectime,a.synctime,a.closedate," +
                    "a.reason ,b.buildingname,c.regionname" +
                    " from t_nc_cardlist a " +
                    " left join tb_operator d on a.operid=d.operid," +
                    " t_nc_device b " +
                    " left join tb_region c on b.regionid=c.regionid " +
                    " where 1>0 and a.deviceid = b.deviceid " ;
            if (!"".equals(allocatStartDate)) {
                queryString += " and a.rectime>=:allocatStartDate ";
            }
            if (!"".equals(allocatEndDate)) {
                queryString += " and a.rectime<=:allocatEndDate ";
            }
            if (!("all").equals(syncflag)) {
                queryString += " and a.syncflag =:syncflag ";
            }
            if (!("").equals(devname)) {
                queryString += " and b.devname like :devname ";
            }
            if (!("all").equals(operflag)) {
                queryString += " and a.operflag =:operflag ";
            }
            if (!("").equals(buildingid)) {
                queryString += " and b.buildingid = :buildingid ";
            }
            if (!regionid.equals("")){
                queryString += " and b.regionid in  "
                        +"("
                        + "with recursive tmp as  "
                        + "("
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr where regionid = :regionid  "
                        + "union all  "
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  "
                        + ") select regionid from tmp  ) ";
            }
            if (!("").equals(custname)) {
                queryString += " and a.custname like :custname ";
            }
            if (!("").equals(cardno)) {
                queryString += " and a.cardno like :cardno ";
            }
            queryString += " order by a.listid DESC ";

            Query query = entityManager.createNativeQuery(queryString, TDoorcardlstInfo.class);
            if (!"".equals(allocatStartDate)) {
                query.setParameter("allocatStartDate", allocatStartDate + "000000");
            }
            if (!"".equals(allocatEndDate)) {
                query.setParameter("allocatEndDate", allocatEndDate + "235959");
            }


            if (!("all").equals(syncflag)) {
                query.setParameter("syncflag", syncflag);
            }
            if (!("").equals(devname)) {
                query.setParameter("devname", "%" + devname + "%");
            }
            if (!("all").equals(operflag)) {
                query.setParameter("operflag", operflag);
            }
            if (!("").equals(buildingid)) {
                query.setParameter("buildingid", buildingid);
            }
            if (!("").equals(regionid)){
                query.setParameter("regionid",regionid);
            }
            if (!("").equals(custname)) {
                query.setParameter("custname", "%" + custname + "%");
            }
            if (!("").equals(cardno)) {
                query.setParameter("cardno", "%" + cardno + "%");
            }

            List<TDoorcardlstInfo> tDoorcardlstInfos = query.getResultList();
            SimpleDateFormat _ymdhms = new SimpleDateFormat("yyyyMMddHHmmss");
            SimpleDateFormat ymdhms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (TDoorcardlstInfo grp : tDoorcardlstInfos) {
                List<String> operFlag = dictionaryDao.findDictionaryStringByType(2);
                List<String> sync = dictionaryDao.findDictionaryStringByType(3);
                if(operflag!= null && operFlag.size()>0){
                    String operFlagIndex = grp.getOperflag();
                    for (String s : operFlag) {
                        String[] split = s.split("_");
                        if (operFlagIndex.equals(split[0])){
                            grp.setOperflag(split[1]);
                            break;
                        }
                    }
                }
                if(sync!= null && sync.size()>0){
                    String syncStatus1 = grp.getSyncflag();
                    for (String s : sync) {
                        String[] split = s.split("_");
                        if (syncStatus1.equals(split[0])){
                            grp.setSyncflag(split[1]);
                            break;
                        }else {
                            grp.setSyncflag("");
                        }
                    }
                }


                String time = grp.getRectime();
                Date date;
                String hms = "000000";
                if (time != null && !time.equals("")) {
                    if (time.length() == 14) {
                        date = _ymdhms.parse(time);
                        grp.setRectime(ymdhms.format(date));
                    } else {

                        time += hms.substring(0, 14 - time.length());
                        date = _ymdhms.parse(time + "");
                        grp.setRectime(ymdhms.format(date));
                    }

                }

                time = grp.getSynctime();
                if (time != null && !time.equals("")) {
                    if (time.length() == 14) {
                        date = _ymdhms.parse(time);
                        grp.setSynctime(ymdhms.format(date));
                    } else {
                        time += hms.substring(0, 14 - time.length());
                        date = _ymdhms.parse(time);
                        grp.setSynctime(ymdhms.format(date));
                    }

                }

            }

            return tDoorcardlstInfos;
        }catch (Exception e){
            e.printStackTrace();
        }
        return null;
    }

    @Transactional(readOnly = true)
    @Override
    public List<TDoorcardlstInfo> getOperatorCardListMap( String allocatStartDate, String allocatEndDate, String devname, String custname, String cardno, String syncflag, String operflag, String buildingid, String regionid, String operRegionid) {
        try {
            String queryString = "select a.listid,b.devname,a.custname,a.cardno,a.bankcardno,d.opername," +
                    "a.syncflag,a.operflag,a.rectime,a.synctime,a.closedate," +
                    "a.reason ,b.buildingname,c.regionname" +
                    " from t_nc_cardlist a " +
                    " left join tb_operator d on a.operid=d.operid," +
                    " t_nc_device b " +
                    " left join tb_region c on b.regionid=c.regionid " +
                    " where 1>0 and a.deviceid=b.deviceid " ;
            if (!"".equals(allocatStartDate)) {
                queryString += " and a.rectime>=:allocatStartDate ";
            }
            if (!"".equals(allocatEndDate)) {
                queryString += " and a.rectime<=:allocatEndDate ";
            }
            if (!("all").equals(syncflag)) {
                queryString += " and a.syncflag =:syncflag ";
            }
            if (!("").equals(devname)) {
                queryString += " and b.devname like :devname ";
            }
            if (!("all").equals(operflag)) {
                queryString += " and a.operflag =:operflag ";
            }
            if (!("").equals(buildingid)) {
                queryString += " and b.buildingid = :buildingid ";
            }

                queryString += " and b.regionid in  "
                    +"("
                    + "with recursive tmp as  "
                    + "("
                    + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr where regionid = :regionid  "
                    + "union all  "
                    + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  "
                    + ") select regionid from tmp ) ";


            if (!("").equals(custname)) {
                queryString += " and a.custname like :custname ";
            }
            if (!("").equals(cardno)) {
                queryString += " and a.cardno like :cardno ";
            }
            queryString += " order by a.listid DESC ";

            Query query = entityManager.createNativeQuery(queryString, TDoorcardlstInfo.class);

            if (!"".equals(allocatStartDate)) {
                query.setParameter("allocatStartDate", allocatStartDate + "000000");
            }
            if (!"".equals(allocatEndDate)) {
                query.setParameter("allocatEndDate", allocatEndDate + "235959");
            }


            if (!("all").equals(syncflag)) {
                query.setParameter("syncflag", syncflag);
            }
            if (!("").equals(devname)) {
                query.setParameter("devname", "%" + devname + "%");
            }
            if (!("all").equals(operflag)) {
                query.setParameter("operflag", operflag);
            }
            if (!("").equals(buildingid)) {
                query.setParameter("buildingid", buildingid);
            }
            if (!("").equals(regionid)){
                query.setParameter("regionid", regionid);
            }else {
                query.setParameter("regionid" ,operRegionid );
            }
            if (!("").equals(custname)) {
                query.setParameter("custname", "%" + custname + "%");
            }
            if (!("").equals(cardno)) {
                query.setParameter("cardno", cardno);
            }

            List<TDoorcardlstInfo> tDoorcardlstInfos = query.getResultList();
            SimpleDateFormat _ymdhms = new SimpleDateFormat("yyyyMMddHHmmss");
            SimpleDateFormat ymdhms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (TDoorcardlstInfo grp : tDoorcardlstInfos) {
                List<String> operFlag = dictionaryDao.findDictionaryStringByType(2);
                List<String> sync = dictionaryDao.findDictionaryStringByType(3);
                if(operflag!= null && operFlag.size()>0){
                    String operFlagIndex = grp.getOperflag();
                    for (String s : operFlag) {
                        String[] split = s.split("_");
                        if (operFlagIndex.equals(split[0])){
                            grp.setOperflag(split[1]);
                            break;
                        }
                    }
                }
                if(sync!= null && sync.size()>0){
                    String syncStatus1 = grp.getSyncflag();
                    for (String s : sync) {
                        String[] split = s.split("_");
                        if (syncStatus1.equals(split[0])){
                            grp.setSyncflag(split[1]);
                            break;
                        }else {
                            grp.setSyncflag("");
                        }
                    }
                }


                String time = grp.getRectime();
                Date date;
                String hms = "000000";
                if (time != null && !time.equals("")) {
                    if (time.length() == 14) {
                        date = _ymdhms.parse(time);
                        grp.setRectime(ymdhms.format(date));
                    } else {

                        time += hms.substring(0, 14 - time.length());
                        date = _ymdhms.parse(time + "");
                        grp.setRectime(ymdhms.format(date));
                    }

                }

                time = grp.getSynctime();
                if (time != null && !time.equals("")) {
                    if (time.length() == 14) {
                        date = _ymdhms.parse(time);
                        grp.setSynctime(ymdhms.format(date));
                    } else {
                        time += hms.substring(0, 14 - time.length());
                        date = _ymdhms.parse(time);
                        grp.setSynctime(ymdhms.format(date));
                    }

                }

            }

            return tDoorcardlstInfos;

        }catch (Exception e){
            e.printStackTrace();
        }
        return null;
    }

    @Transactional(readOnly = true)
    @Override
    public List<TDoorcardlstInfo> getBuildingOperCardListMap(String allocatStartDate, String allocatEndDate, String devname, String custname, String cardno, String syncflag, String operflag, String buildingid, String operid) {
        try {

            String queryString = "select a.listid,b.devname,a.custname,a.cardno,a.bankcardno,d.opername," +
                    "a.syncflag,a.operflag,a.rectime,a.synctime,a.closedate," +
                    "a.reason ,b.buildingname,c.regionname" +
                    " from t_nc_cardlist a " +
                    " left join tb_operator d on a.operid=d.operid," +
                    " t_nc_device b " +
                    " left join tb_region c on b.regionid=c.regionid " +
                    " left join t_operbuilding e on e.buildingid=b.buildingid "+
                    " where 1>0 and a.deviceid=b.deviceid and e.operid=:operid " ;
            if (!"".equals(allocatStartDate)) {
                queryString += " and a.rectime>=:allocatStartDate ";
            }
            if (!"".equals(allocatEndDate)) {
                queryString += " and a.rectime<=:allocatEndDate ";
            }
            if (!("all").equals(syncflag)) {
                queryString += " and a.syncflag =:syncflag ";
            }
            if (!("").equals(devname)) {
                queryString += " and b.devname like :devname ";
            }
            if (!("all").equals(operflag)) {
                queryString += " and a.operflag =:operflag ";
            }
            if (!("").equals(buildingid)) {
                queryString += " and b.buildingid = :buildingid ";
            }

            if (!("").equals(custname)) {
                queryString += " and a.custname like :custname ";
            }
            if (!("").equals(cardno)) {
                queryString += " and a.cardno like :cardno ";
            }
            queryString += " ORDER by a.listid DESC ";

            Query query = entityManager.createNativeQuery(queryString, TDoorcardlstInfo.class);
            query.setParameter("operid", operid);

            if (!"".equals(allocatStartDate)) {
                query.setParameter("allocatStartDate", allocatStartDate + "000000");
            }
            if (!"".equals(allocatEndDate)) {
                query.setParameter("allocatEndDate", allocatEndDate + "235959");
            }


            if (!("all").equals(syncflag)) {
                query.setParameter("syncflag", syncflag);
            }
            if (!("").equals(devname)) {
                query.setParameter("devname", "%" + devname + "%");
            }
            if (!("all").equals(operflag)) {
                query.setParameter("operflag", operflag);
            }
            if (!("").equals(buildingid)) {
                query.setParameter("buildingid", buildingid);
            }
            if (!("").equals(custname)) {
                query.setParameter("custname", "%" + custname + "%");
            }
            if (!("").equals(cardno)) {
                query.setParameter("cardno", cardno);
            }


            List<TDoorcardlstInfo> tDoorcardlstInfos = query.getResultList();
            SimpleDateFormat _ymdhms = new SimpleDateFormat("yyyyMMddHHmmss");
            SimpleDateFormat ymdhms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (TDoorcardlstInfo grp : tDoorcardlstInfos) {
                List<String> operFlag = dictionaryDao.findDictionaryStringByType(2);
                List<String> sync = dictionaryDao.findDictionaryStringByType(3);
                if(operflag!= null && operFlag.size()>0){
                    String operFlagIndex = grp.getOperflag();
                    for (String s : operFlag) {
                        String[] split = s.split("_");
                        if (operFlagIndex.equals(split[0])){
                            grp.setOperflag(split[1]);
                            break;
                        }
                    }
                }
                if(sync!= null && sync.size()>0){
                    String syncStatus1 = grp.getSyncflag();
                    for (String s : sync) {
                        String[] split = s.split("_");
                        if (syncStatus1.equals(split[0])){
                            grp.setSyncflag(split[1]);
                            break;
                        }else {
                            grp.setSyncflag("");
                        }
                    }
                }


                String time = grp.getRectime();
                Date date;
                String hms = "000000";
                if (time != null && !time.equals("")) {
                    if (time.length() == 14) {
                        date = _ymdhms.parse(time);
                        grp.setRectime(ymdhms.format(date));
                    } else {

                        time += hms.substring(0, 14 - time.length());
                        date = _ymdhms.parse(time + "");
                        grp.setRectime(ymdhms.format(date));
                    }

                }

                time = grp.getSynctime();
                if (time != null && !time.equals("")) {
                    if (time.length() == 14) {
                        date = _ymdhms.parse(time);
                        grp.setSynctime(ymdhms.format(date));
                    } else {
                        time += hms.substring(0, 14 - time.length());
                        date = _ymdhms.parse(time);
                        grp.setSynctime(ymdhms.format(date));
                    }

                }

            }

            return tDoorcardlstInfos;
        }catch (Exception e){
            e.printStackTrace();
        }
        return null;
    }

    @Transactional
    @Override
    public void updateDoorcardlstToNoWithIds(List<Long> listIds) {
        String sql = "update T_NC_CARDLIST set version = version+1,syncflag='N',SYNCTIME='', RECTIME=to_char(current_timestamp, 'YYYYMMDDHH24MISS') where cast(listid as INTEGER) in " + StringUtil.intOrLikeIntListTransToStr(listIds);
        Query query = entityManager.createNativeQuery(sql);
        query.executeUpdate();
    }
}
