package com.supwisdom.dlpay.mainservice.dao.impl;

import com.supwisdom.dlpay.mainservice.bean.TDoordtlInfo;
import com.supwisdom.dlpay.mainservice.dao.DoordtlDao;
import com.supwisdom.dlpay.system.page.Pagination;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import java.util.List;

@Repository
public class DoordtlDaoImpl implements DoordtlDao {
    @PersistenceContext
    EntityManager entityManager;

    @Transactional
    @Override
    public List<TDoordtlInfo> findSystemExportExcelDoordtl(String startTranDate, String endTranDate, String startTranTime, String endTranTime, String cardno, String custname, String buildingid, String regionid, String devname, String streamstatus) {
        try {
            String queryString = "select a.doorseqno,b.deviceid,b.devname,a.custname,c.cardno,c.cardphyid,c.bankcardno,to_char(to_date(a.transdate ,'yyyymmdd'),'yyyy-mm-dd')||' '||to_char(to_timestamp(a.transtime,'hh24miss'),'hh24:mi:ss') transdate, " +
                    " to_char(to_date(a.coldate ,'yyyymmdd'),'yyyy-mm-dd')||' '||to_char(to_timestamp(a.coltime,'hh24miss'),'hh24:mi:ss') coldate,"
                    + " case when a.status='' then '失败' else '成功' end status,a.dtldesc "
                    + " from t_doordtl a "
                    + " left join t_card c on a.custid=c.custid,t_nc_device b "
                    + " left join tb_region d on b.regionid=d.regionid "
                    + " left join t_building e on b.buildingid=e.buildingid "
                    + " where 1>0 and cast(substr(a.doorid,5) as integer) = b.deviceid ";
            if (!startTranDate.equals("") && !endTranDate.equals("")) {
                queryString += " and a.transdate between :startTranDate and :endTranDate ";
            }
            if (!cardno.equals("")) {
                queryString += " and a.cardno like :cardno ";
            }
            if (!custname.equals("")) {
                queryString += " and a.custname like :custname ";
            }
            if (!devname.equals("")) {
                queryString += " and b.devname like :devname ";
            }
            if (!streamstatus.equals("all")) {
                queryString += " and a.status =:streamstatus ";
            }
            if(!buildingid.equals("")){
                queryString += " and e.buildingid = :buildingid ";
            }
            if (!regionid.equals("")){
                queryString += " and d.regionid in  "
                        +"("
                        + "with recursive tmp as  "
                        + "("
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr where regionid = :regionid  "
                        + "union all  "
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  "
                        + ") select regionid from tmp  ) ";
            }
            queryString += " order by a.transdate DESC,doorseqno";
            Query query = entityManager.createNativeQuery(queryString, TDoordtlInfo.class);
            if (!startTranDate.equals("")) {
                query.setParameter("startTranDate", startTranDate);
                query.setParameter("endTranDate", endTranDate);
            }
            if (!cardno.equals("")) {
                query.setParameter("cardno", cardno);
            }
            if (!custname.equals("")) {
                query.setParameter("custname", "%" + custname + "%");
            }
            if (!devname.equals("")) {
                query.setParameter("devname", "%" + devname + "%");
            }
            if (!streamstatus.equals("all")) {
                query.setParameter("streamstatus", streamstatus);
            }
            if(!buildingid.equals("")){
                query.setParameter("buildingid",buildingid);
            }
            if (!regionid.equals("")){
                query.setParameter("regionid", regionid);
            }
            List<TDoordtlInfo> list = query.getResultList();
            return list;
        }catch (Exception e){
            e.printStackTrace();
        }
        return null;
    }

    @Transactional
    @Override
    public List<TDoordtlInfo> findOperatorExportExcelDoordtl(String startTranDate, String endTranDate, String startTranTime, String endTranTime, String cardno, String custname, String buildingid, String regionid, String devname, String streamstatus, String operRegionid) {
        try {
            String queryString = "select a.doorseqno,b.deviceid,b.devname,a.custname,c.cardno,c.cardphyid,c.bankcardno,to_char(to_date(a.transdate ,'yyyymmdd'),'yyyy-mm-dd')||' '||to_char(to_timestamp(a.transtime,'hh24miss'),'hh24:mi:ss') transdate, " +
                    " to_char(to_date(a.coldate ,'yyyymmdd'),'yyyy-mm-dd')||' '||to_char(to_timestamp(a.coltime,'hh24miss'),'hh24:mi:ss') coldate,"
                    + " case when a.status='' then '失败' else '成功' end status,a.dtldesc "
                    + " from t_doordtl a "
                    + " left join t_card c on a.custid=c.custid,t_nc_devcie b "
                    + " left join tb_region d on b.regionid=d.regionid "
                    + " left join t_building e on b.buildingid=e.buildingid "
                    + " where 1>0 and cast(substr(a.doorid,5) as integer) = b.deviceid ";
            if (!startTranDate.equals("")) {
                queryString += " and a.transdate between :startTranDate and :endTranDate ";
            }
            if (!cardno.equals("")) {
                queryString += " and a.cardno like :cardno ";
            }
            if (!custname.equals("")) {
                queryString += " and a.custname like :custname ";
            }
            if (!devname.equals("")) {
                queryString += " and d.devname like :devname ";
            }
            if (!streamstatus.equals("all")) {
                queryString += " and a.status =:streamstatus ";
            }
            if(!buildingid.equals("")){
                queryString += " and e.buildingid = :buildingid ";
            }

                queryString += " and d.regionid in  "
                        +"("
                        + "with recursive tmp as  "
                        + "("
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr where regionid = :regionid  "
                        + "union all  "
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  "
                        + ") select regionid from tmp ) ";

            queryString += " order by transdate DESC";
            Query query = entityManager.createNativeQuery(queryString, TDoordtlInfo.class);

            if (!startTranDate.equals("")) {
                query.setParameter("startTranDate", startTranDate);
                query.setParameter("endTranDate", endTranDate);
            }
            if (!cardno.equals("")) {
                query.setParameter("cardno", cardno);
            }
            if (!custname.equals("")) {
                query.setParameter("custname", "%" + custname + "%");
            }
            if (!devname.equals("")) {
                query.setParameter("devname", "%" + devname + "%");
            }
            if (!streamstatus.equals("all")) {
                query.setParameter("streamstatus", streamstatus);
            }
            if (!buildingid.equals("")) {
                query.setParameter("buildingid", buildingid);
            }
            if(regionid.equals("")){
                query.setParameter("regionid",regionid);
            }else {
                query.setParameter("regionid", operRegionid);
            }
            List<TDoordtlInfo> list = query.getResultList();
            return list;
        }catch (Exception e){
            e.printStackTrace();
        }
        return null;
    }

    @Transactional
    @Override
    public List<TDoordtlInfo> findBuildingOperExportExcelDoorDtl(String startTranDate, String endTranDate, String startTranTime, String endTranTime, String cardno, String custname, String buildingid, String devname, String streamstatus, String operid) {
        try{
            String queryString = "select a.doorseqno,b.deviceid,b.devname,a.custname,c.cardno,c.cardphyid,c.bankcardno,to_char(to_date(a.transdate ,'yyyymmdd'),'yyyy-mm-dd')||' '||to_char(to_timestamp(a.transtime,'hh24miss'),'hh24:mi:ss') transdate, " +
                    " to_char(to_date(a.coldate ,'yyyymmdd'),'yyyy-mm-dd')||' '||to_char(to_timestamp(a.coltime,'hh24miss'),'hh24:mi:ss') coldate,"
                    + " case when a.status='' then '失败' else '成功' end status,a.dtldesc "
                    + " from t_doordtl a "
                    + " left join t_card c on a.custid=c.custid,t_nc_device b "
                    + " left join tb_region d on b.regionid=d.regionid "
                    + " left join t_building e on b.buildingid=e.buildingid "
                    + " left join t_operBuilding f on e.buildingid = f.buildingid "
                    + " where 1>0 and cast(substr(a.doorid,5) as integer) = b.deviceid and f.operid = :operid ";
            if (!startTranDate.equals("")) {
                queryString += " and a.transdate between :startTranDate and :endTranDate ";
            }
            if (!cardno.equals("")) {
                queryString += " and a.cardno like :cardno ";
            }
            if (!custname.equals("")) {
                queryString += " and a.custname like :custname ";
            }
            if (!devname.equals("")) {
                queryString += " and d.devname like :devname ";
            }
            if (!streamstatus.equals("all")) {
                queryString += " and a.status =:streamstatus ";
            }
            if(!buildingid.equals("")){
                queryString += " and e.buildingid = :buildingid ";
            }
            queryString += " order by transdate DESC";
            Query query = entityManager.createNativeQuery(queryString, TDoordtlInfo.class);

            if (!startTranDate.equals("")) {
                query.setParameter("startTranDate", startTranDate);
                query.setParameter("endTranDate", endTranDate);
            }
            if (!cardno.equals("")) {
                query.setParameter("cardno", cardno);
            }
            if (!custname.equals("")) {
                query.setParameter("custname", "%" + custname + "%");
            }
            if (!devname.equals("")) {
                query.setParameter("devname", "%" + devname + "%");
            }
            if (!streamstatus.equals("all")) {
                query.setParameter("streamstatus", streamstatus);
            }
            if (!buildingid.equals("")) {
                query.setParameter("buildingid", buildingid);
            }
            query.setParameter("operid", operid);

            List<TDoordtlInfo> list = query.getResultList();
            return list;
        }catch (Exception e){
            e.printStackTrace();
        }
        return null;
    }

    @Transactional
    @Override
    public Pagination findSystemTDoordtl(String startTranDate, String endTranDate, String startTranTime, String endTranTime, String cardno, String custname, String buildingid, String devname, String streamstatus, int pageNo, int pageSize, String regionid) {
        String queryString = "select a.doorseqno,b.deviceid,b.devname,a.custname,c.cardno,c.cardphyid,c.bankcardno,a.transdate||a.transtime transdate, a.coldate||a.coltime coldate,"
                + " case when a.status='' then '失败' else '成功' end status,a.dtldesc "
                + " from t_doordtl a left join t_card c on a.custid=c.custid,  t_nc_device b "
                + " left join tb_region d on b.regionid=d.regionid "
                + " left join t_building e on b.buildingid=e.buildingid "
                + " where 1>0 and cast(substr(a.doorid,5) as integer) = b.deviceid ";
        if (!startTranDate.equals("") && !endTranDate.equals("")) {
            queryString += " and transdate between :startTranDate and :endTranDate ";
        }
        if (!cardno.equals("")) {
            queryString += " and a.cardno like :cardno ";
        }
        if (!custname.equals("")) {
            queryString += " and a.custname like :custname ";
        }
        if (!devname.equals("")) {
            queryString += " and b.devname like :devname ";
        }
        if (!streamstatus.equals("all")) {
            queryString += " and a.status =:streamstatus ";
        }
        if(!buildingid.equals("")){
            queryString += " and e.buildingid = :buildingid ";
        }
        if (!regionid.equals("")){
            queryString += " and d.regionid in  "
                    +"("
                    + "with recursive tmp as  "
                    + "("
                    + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr where regionid = :regionid  "
                    + "union all  "
                    + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  "
                    + ") select regionid from tmp  )";
        }
        queryString += " order by a.transdate DESC";
        Query query = entityManager.createNativeQuery(queryString, TDoordtlInfo.class);
        if (!startTranDate.equals("")) {
            query.setParameter("startTranDate", startTranDate);
            query.setParameter("endTranDate", endTranDate);
        }
        if (!cardno.equals("")) {
            query.setParameter("cardno", cardno);
        }
        if (!custname.equals("")) {
            query.setParameter("custname", "%" + custname + "%");
        }
        if (!devname.equals("")) {
            query.setParameter("devname", "%" + devname + "%");
        }
        if (!streamstatus.equals("all")) {
            query.setParameter("streamstatus", streamstatus);
        }
        if(!buildingid.equals("")){
            query.setParameter("buildingid",buildingid);
        }
        if (!regionid.equals("")){
            query.setParameter("regionid", regionid);
        }
        pageNo = pageNo <= 0 ? 1 : pageNo;
        query.setFirstResult((pageNo - 1) * pageSize);
        query.setMaxResults(pageSize);
        Pagination page = new Pagination();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        List<TDoordtlInfo> list = query.getResultList();
        page.setList(list);
        int totalCount = getSystemCount(startTranDate, endTranDate, cardno, custname,
                buildingid, devname, streamstatus,regionid);
        page.setTotalCount(totalCount);
        return page;
    }




    private int getSystemCount(String startTranDate, String endTranDate,
                         String cardno, String custname, String buildingid, String devname, String streamstatus,String regionid) {
        try {
            String queryString = "select count(*) as cnt "
                    + " from t_doordtl a "
                    + " left join t_card c on a.custid=c.custid, t_nc_device b "
                    + " left join tb_region d on b.regionid=d.regionid "
                    + " left join t_building e on b.buildingid=e.buildingid "
                    + " where 1>0 and cast(substr(a.doorid,5) as integer) = b.deviceid ";

            if (!startTranDate.equals("")) {
                queryString += " and a.transdate between :startTranDate and :endTranDate ";
            }
            if (!cardno.equals("")) {
                queryString += " and a.cardno like :cardno ";
            }
            if (!custname.equals("")) {
                queryString += " and a.custname like :custname ";
            }
            if (!devname.equals("")) {
                queryString += " and b.devname like :devname ";
            }
            if (!streamstatus.equals("all")) {
                queryString += " and a.status =:streamstatus ";
            }
            if(!buildingid.equals("")){
                queryString += " and e.buildingid = :buildingid ";
            }
            if (!regionid.equals("")){
                queryString += " and d.regionid in  "
                        +"("
                        + "with recursive tmp as  "
                        + "("
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr where regionid = :regionid  "
                        + "union all  "
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  "
                        + ") select regionid from tmp  ) ";
            }
            Query query = entityManager.createNativeQuery(queryString);
            query.setMaxResults(5);
            if (!startTranDate.equals("")) {
                query.setParameter("startTranDate", startTranDate);
                query.setParameter("endTranDate", endTranDate);
            }
            if (!cardno.equals("")) {
                query.setParameter("cardno", cardno);
            }
            if (!custname.equals("")) {
                query.setParameter("custname", "%" + custname + "%");
            }
			if (!buildingid.equals("")) {
                query.setParameter("buildingid", buildingid);
			}
            if (!devname.equals("")) {
                query.setParameter("devname", "%" + devname + "%");
            }
            if (!streamstatus.equals("all")) {
                query.setParameter("streamstatus", streamstatus);
            }
            if(!regionid.equals("")){
                query.setParameter("regionid",regionid);
            }
            List list = query.getResultList();
            int cnt = 0;
            if (list!=null && list.size()>0){
                cnt = Integer.parseInt(list.get(0).toString());
            }
            return cnt;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }


    @Transactional
    @Override
    public Pagination findOperatorTDoordtl(String startTranDate, String endTranDate, String startTranTime, String endTranTime, String cardno, String custname, String buildingid, String devname, String streamstatus, int pageNo, int pageSize, String regionid,String operRegionid) {
        try{
            String queryString = "select a.doorseqno,b.deviceid,b.devname,a.custname,c.cardno,c.cardphyid,c.bankcardno,a.transdate||a.transtime transdate, a.coldate||a.coltime coldate,"
                    + " case when a.status='' then '失败' else '成功' end status,a.dtldesc "
                    + " from t_doordtl a  "
                    + " left join t_card c on a.custid=c.custid,t_nc_device b "
                    + " left join tb_region d on b.regionid=d.regionid "
                    + " left join t_building e on b.buildingid=e.buildingid "
                    + " where 1>0 and cast(substr(a.doorid,5) as integer) = b.deviceid ";
            if (!startTranDate.equals("")) {
                queryString += " and transdate between :startTranDate and :endTranDate ";
            }
            if (!cardno.equals("")) {
                queryString += " and a.cardno like :cardno ";
            }
            if (!custname.equals("")) {
                queryString += " and a.custname like :custname ";
            }
            if (!devname.equals("")) {
                queryString += " and d.devname like :devname ";
            }
            if (!streamstatus.equals("all")) {
                queryString += " and a.status =:streamstatus ";
            }
            if(!buildingid.equals("")){
                queryString += " and e.buildingid = :buildingid ";
            }

                queryString += "and d.regionid in  "
                        +"("
                        + "with recursive tmp as  "
                        + "("
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr where regionid = :regionid  "
                        + "union all  "
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  "
                        + ") select regionid from tmp )";

            queryString += " order by transdate DESC";
            Query query = entityManager.createNativeQuery(queryString, TDoordtlInfo.class);

            if (!startTranDate.equals("")) {
                query.setParameter("startTranDate", startTranDate);
                query.setParameter("endTranDate", endTranDate);
            }
            if (!cardno.equals("")) {
                query.setParameter("cardno", cardno);
            }
            if (!custname.equals("")) {
                query.setParameter("custname", "%" + custname + "%");
            }
            if (!devname.equals("")) {
                query.setParameter("devname", "%" + devname + "%");
            }
            if (!streamstatus.equals("all")) {
                query.setParameter("streamstatus", streamstatus);
            }
            if (!buildingid.equals("")) {
                query.setParameter("buildingid", buildingid);
            }
            if(!regionid.equals("")){
                query.setParameter("regionid",regionid);
            }else {
                query.setParameter("regionid" ,operRegionid );
            }
            pageNo = pageNo <= 0 ? 1 : pageNo;
            query.setFirstResult((pageNo - 1) * pageSize);
            query.setMaxResults(pageSize);
            Pagination page = new Pagination();
            page.setPageNo(pageNo);
            page.setPageSize(pageSize);
            List<TDoordtlInfo> list = query.getResultList();
            page.setList(list);
            int totalCount = getOperatorCount(startTranDate, endTranDate, cardno, custname,
                    buildingid, devname, streamstatus,regionid,operRegionid);
            page.setTotalCount(totalCount);
            return page;
        }catch (Exception e){
            e.printStackTrace();
        }
        return null;
    }



    private int getOperatorCount(String startTranDate, String endTranDate,
                         String cardno, String custname, String buildingid, String devname,
                          String streamstatus,String regionid,String operRegionid) {
        try {
            String queryString = "select count(*) as cnt "
                    + " from t_doordtl a "
                    + " left join t_card c on a.custid=c.custid, t_nc_device b "
                    + " left join tb_region d on b.regionid=d.regionid "
                    + " left join t_building e on b.buildingid=e.buildingid "
                    + " where 1>0 and cast(substr(a.doorid,5) as integer) = b.deviceid ";

            if (!startTranDate.equals("")) {
                queryString += " and a.transdate between :startTranDate and :endTranDate ";
            }
            if (!cardno.equals("")) {
                queryString += " and a.cardno like :cardno ";
            }
            if (!custname.equals("")) {
                queryString += " and a.custname like :custname ";
            }
            if (!devname.equals("")) {
                queryString += " and b.devname like :devname ";
            }
            if (!streamstatus.equals("all")) {
                queryString += " and a.status =:streamstatus ";
            }
            if(!buildingid.equals("")){
                queryString += " and e.buildingid = :buildingid ";
            }

                queryString += " and d.regionid in  "
                        +"("
                        + "with recursive tmp as  "
                        + "("
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr where regionid like :regionid  "
                        + "union all  "
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  "
                        + ") select regionid from tmp )";

            Query query = entityManager.createNativeQuery(queryString);
            query.setMaxResults(5);
            if (!startTranDate.equals("")) {
                query.setParameter("startTranDate", startTranDate);
                query.setParameter("endTranDate", endTranDate);
            }
            if (!cardno.equals("")) {
                query.setParameter("cardno", cardno);
            }
            if (!custname.equals("")) {
                query.setParameter("custname", "%" + custname + "%");
            }
            if (!devname.equals("")) {
                query.setParameter("devname", "%" + devname + "%");
            }
            if (!streamstatus.equals("all")) {
                query.setParameter("streamstatus", streamstatus);
            }
            if (!buildingid.equals("")) {
                query.setParameter("buildingid", buildingid);
            }

            if(!regionid.equals("")){
                query.setParameter("regionid",regionid);
            }else {
                query.setParameter("regionid", operRegionid);
            }
            List list = query.getResultList();
            int cnt = 0;
            if (list!=null && list.size()>0){
                cnt = Integer.parseInt(list.get(0).toString());
            }
            return cnt;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    @Transactional
    @Override
    public Pagination findBuildingOperTDoordtl(String startTranDate, String endTranDate, String startTranTime, String endTranTime, String cardno, String custname, String buildingid, String devname, String streamstatus, int pageNo, int pageSize, String operid) {
        try{
        String queryString = "select a.doorseqno,b.deviceid,b.devname,a.custname,c.cardno,c.cardphyid,c.bankcardno,a.transdate||a.transtime transdate, a.coldate||a.coltime coldate,"
                + " case when a.status='' then '失败' else '成功' end status,a.dtldesc "
                + " from t_doordtl a "
                + " left join t_card c on a.custid=c.custid,t_nc_device b "
                + " left join tb_region d on b.regionid=d.regionid "
                + " left join t_building e on b.buildingid=e.buildingid "
                + " left join t_operBuilding f on e.buildingid = f.buildingid "
                + " where 1>0 and cast(substr(a.doorid,5) as integer) = b.deviceid and f.operid = :operid ";
        if (!startTranDate.equals("")) {
            queryString += " and transdate between :startTranDate and :endTranDate ";
        }
        if (!cardno.equals("")) {
            queryString += " and a.cardno like :cardno ";
        }
        if (!custname.equals("")) {
            queryString += " and a.custname like :custname ";
        }
        if (!devname.equals("")) {
            queryString += " and d.devname like :devname ";
        }
        if (!streamstatus.equals("all")) {
            queryString += " and a.status =:streamstatus ";
        }
        if(!buildingid.equals("")){
            queryString += " and e.buildingid = :buildingid ";
        }
        queryString += " order by transdate DESC";
        Query query = entityManager.createNativeQuery(queryString, TDoordtlInfo.class);

        if (!startTranDate.equals("")) {
            query.setParameter("startTranDate", startTranDate);
            query.setParameter("endTranDate", endTranDate);
        }
        if (!cardno.equals("")) {
            query.setParameter("cardno", cardno);
        }
        if (!custname.equals("")) {
            query.setParameter("custname", "%" + custname + "%");
        }
        if (!devname.equals("")) {
            query.setParameter("devname", "%" + devname + "%");
        }
        if (!streamstatus.equals("all")) {
            query.setParameter("streamstatus", streamstatus);
        }
        if (!buildingid.equals("")) {
            query.setParameter("buildingid", buildingid);
        }
        query.setParameter("operid", operid);
        pageNo = pageNo <= 0 ? 1 : pageNo;
        query.setFirstResult((pageNo - 1) * pageSize);
        query.setMaxResults(pageSize);
        Pagination page = new Pagination();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        List<TDoordtlInfo> list = query.getResultList();
        page.setList(list);
        int totalCount = getBuildingOperCount(startTranDate, endTranDate, cardno, custname,
                buildingid, devname, streamstatus,operid);
        page.setTotalCount(totalCount);
        return page;
    }catch (Exception e){
        e.printStackTrace();
    }
        return null;
    }

    private int getBuildingOperCount(String startTranDate, String endTranDate,
                                     String cardno, String custname, String buildingid, String devname,
                                     String streamstatus,String operid){
        try {
            String queryString = "select count(*) as cnt "
                    + " from t_doordtl a "
                    + " left join t_card c on a.custid=c.custid,t_nc_device b "
                    + " left join tb_region d on b.regionid=d.regionid "
                    + " left join t_building e on b.buildingid=e.buildingid "
                    + " left join t_operBuilding f on e.buildingid = f.buildingid "
                    + " where 1>0 and cast(substr(a.doorid,5) as integer) = b.deviceid and f.operid = :operid ";

            if (!startTranDate.equals("")) {
                queryString += " and a.transdate between :startTranDate and :endTranDate ";
            }
            if (!cardno.equals("")) {
                queryString += " and a.cardno like :cardno ";
            }
            if (!custname.equals("")) {
                queryString += " and a.custname like :custname ";
            }
            if (!devname.equals("")) {
                queryString += " and b.devname like :devname ";
            }
            if (!streamstatus.equals("all")) {
                queryString += " and a.status =:streamstatus ";
            }
            if(!buildingid.equals("")){
                queryString += " and e.buildingid = :buildingid ";
            }
            Query query = entityManager.createNativeQuery(queryString);
            query.setMaxResults(5);
            if (!startTranDate.equals("")) {
                query.setParameter("startTranDate", startTranDate);
                query.setParameter("endTranDate", endTranDate);
            }
            if (!cardno.equals("")) {
                query.setParameter("cardno", cardno);
            }
            if (!custname.equals("")) {
                query.setParameter("custname", "%" + custname + "%");
            }
            if (!devname.equals("")) {
                query.setParameter("devname", "%" + devname + "%");
            }
            if (!streamstatus.equals("all")) {
                query.setParameter("streamstatus", streamstatus);
            }
            if (!buildingid.equals("")) {
                query.setParameter("buildingid", buildingid);
            }
            query.setParameter("operid", operid);
            List list = query.getResultList();
            int cnt = 0;
            if (list!=null && list.size()>0){
                cnt = Integer.parseInt(list.get(0).toString());
            }
            return cnt;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }
}
