package com.supwisdom.dlpay.mainservice.dao.impl;

import com.supwisdom.dlpay.mainservice.dao.KeyDao;
import com.supwisdom.dlpay.mainservice.domain.TKey;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import java.util.List;

@Repository
public class KeyDaoImpl implements KeyDao {

    @PersistenceContext
    EntityManager entityManager;

    @Transactional
    @Override
    public List<TKey> getAllKeys() throws Exception {
        String sql = "select bean from TKey bean order by bean.factoryid desc";
        TypedQuery<TKey> query = entityManager.createQuery(sql, TKey.class);
        return query.getResultList();
    }
}
