package com.supwisdom.dlpay.mainservice.service.impl;

import com.supwisdom.dlpay.doorlist.bean.TCustomerInfo;
import com.supwisdom.dlpay.mainservice.bean.TDoorcardlstInfo;
import com.supwisdom.dlpay.mainservice.bean.TDoordtlInfo;
import com.supwisdom.dlpay.mainservice.dao.*;
import com.supwisdom.dlpay.mainservice.domain.TCard;
import com.supwisdom.dlpay.mainservice.domain.TCustomer;
import com.supwisdom.dlpay.mainservice.domain.TKey;
import com.supwisdom.dlpay.mainservice.service.WebInterfaceService;
import com.supwisdom.dlpay.system.page.Pagination;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class WebInterfaceServiceImpl implements WebInterfaceService {
    @Autowired
    KeyDao keyDao;
    @Autowired
    CardListDao cardListDao;
    @Autowired
    DoordtlDao doordtlDao;
    @Autowired
    CustomerDao customerDao;
    @Autowired
    CardDao cardDao;

    @Override
    public List<TKey> getAllKeys() throws Exception {
        return keyDao.getAllKeys();
    }

    @Override
    public Pagination getSystemCardListFrSearch(String allocatStartDate, String allocatEndDate, String devname, String custname, String cardno, String syncflag, String operflag, String buildingid, String regionid, int pageNo, int pageSize) {
        return cardListDao.getSystemCardListFrSearch(allocatStartDate, allocatEndDate, devname, custname, cardno, syncflag, operflag, buildingid, regionid, pageNo, pageSize);
    }

    @Override
    public Pagination getOperatorCardListFrSearch(String allocatStartDate, String allocatEndDate, String devname, String custname, String cardno, String syncflag, String operflag, String buildingid, String regionid, int pageNo, int pageSize, String operRegionid) {
        return cardListDao.getOperatorCardListFrSearch(allocatStartDate, allocatEndDate, devname, custname, cardno, syncflag, operflag, buildingid, regionid, pageNo, pageSize, operRegionid);
    }

    @Override
    public Pagination getBuildingOperCardListFrSearch(String allocatStartDate, String allocatEndDate, String devname, String custname, String cardno, String syncflag, String operflag, String buildingid, String operid, int pageNo, int pageSize) {
        return cardListDao.getBuildingOperCardListFrSearch(allocatStartDate, allocatEndDate, devname, custname, cardno, syncflag, operflag, buildingid, operid, pageNo, pageSize);
    }

    @Override
    public List<TDoorcardlstInfo> getSystemCardListMap(String allocatStartDate, String allocatEndDate, String devname, String custname, String cardno, String syncflag, String operflag, String buildingid, String regionid) {
        return cardListDao.getSystemCardListMap(allocatStartDate, allocatEndDate, devname, custname, cardno, syncflag, operflag, buildingid, regionid);
    }

    @Override
    public List<TDoorcardlstInfo> getOperatorCardListMap(String allocatStartDate, String allocatEndDate, String devname, String custname, String cardno, String syncflag, String operflag, String buildingid, String regionid, String operRegionid) {
        return cardListDao.getOperatorCardListMap(allocatStartDate, allocatEndDate, devname, custname, cardno, syncflag, operflag, buildingid, regionid, operRegionid);
    }

    @Override
    public List<TDoorcardlstInfo> getBuildingOperCardListMap(String allocatStartDate, String allocatEndDate, String devname, String custname, String cardno, String syncflag, String operflag, String buildingid, String operid) {
        return cardListDao.getBuildingOperCardListMap(allocatStartDate, allocatEndDate, devname, custname, cardno, syncflag, operflag, buildingid, operid);
    }


    @Override
    public void updateDoorcardlstToNoWithIds(List<Long> listIds) {
        cardListDao.updateDoorcardlstToNoWithIds(listIds);
    }

    @Override
    public List<TDoordtlInfo> findSystemExportExcelDoordtl(String startTranDate, String endTranDate, String startTranTime, String endTranTime, String cardno, String custname, String buildingid, String regionid, String devname, String streamstatus) {
        return doordtlDao.findSystemExportExcelDoordtl(startTranDate, endTranDate, startTranTime, endTranTime, cardno, custname, buildingid, regionid, devname,  streamstatus);
    }

    @Override
    public List<TDoordtlInfo> findOperatorExportExcelDoordtl(String startTranDate, String endTranDate, String startTranTime, String endTranTime, String cardno, String custname, String buildingid, String regionid, String devname, String streamstatus, String operRegionid) {
        return doordtlDao.findOperatorExportExcelDoordtl(startTranDate, endTranDate, startTranTime, endTranTime, cardno, custname, buildingid, regionid, devname, streamstatus, operRegionid);
    }

    @Override
    public List<TDoordtlInfo> findBuildingOperExportExcelDoorDtl(String startTranDate, String endTranDate, String startTranTime, String endTranTime, String cardno, String custname, String buildingid, String devname, String streamstatus, String operid) {
        return doordtlDao.findBuildingOperExportExcelDoorDtl(startTranDate, endTranDate, startTranTime, endTranTime, cardno, custname, buildingid, devname, streamstatus, operid);
    }

    @Override
    public Pagination findSystemTDoordtl(String startTranDate, String endTranDate, String startTranTime, String endTranTime, String cardno, String custname, String buildingid, String devname, String streamstatus, int pageNo, int pageSize, String regionid) {
        return doordtlDao.findSystemTDoordtl(startTranDate, endTranDate, startTranTime, endTranTime, cardno, custname, buildingid, devname, streamstatus, pageNo, pageSize, regionid);
    }

    @Override
    public Pagination findOperatorTDoordtl( String startTranDate, String endTranDate, String startTranTime, String endTranTime, String cardno, String custname, String buildingid, String devname, String streamstatus, int pageNo, int pageSize, String regionid, String operRegionid) {
        return doordtlDao.findOperatorTDoordtl(startTranDate, endTranDate, startTranTime, endTranTime, cardno, custname, buildingid, devname, streamstatus, pageNo, pageSize, regionid, operRegionid);
    }

    @Override
    public Pagination findBuildingOperTDoordtl(String startTranDate, String endTranDate, String startTranTime, String endTranTime, String cardno, String custname, String buildingid, String devname, String streamstatus, int pageNo, int pageSize, String operid) {
        return doordtlDao.findBuildingOperTDoordtl(startTranDate, endTranDate, startTranTime, endTranTime, cardno, custname, buildingid, devname, streamstatus, pageNo, pageSize, operid);
    }


    @Override
    public TCustomer findCustomerByNo(String cardno) {
        return customerDao.findCustomerByNo(cardno);
    }

    @Override
    public TCustomer findCustomerById(String custid) {
        return customerDao.findCustomerById(custid);
    }

    @Override
    public boolean saveCustomer(TCustomer bean) {
        return customerDao.saveCustomer(bean);
    }

    @Override
    public List<TCustomerInfo> getAllTCustomerList(String perName, String cardno, String bankcardno) {
        return customerDao.getAllTCustomerList(perName, cardno, bankcardno);
    }

    @Override
    public TCard findCardByCustid(String custid) {
        return cardDao.findCardByCustid(custid);
    }

    @Override
    public boolean saveCard(TCard bean) {
        return cardDao.saveCard(bean);
    }

    @Override
    public TCustomerInfo getTCustomerByExcel(String cardno) {
        return customerDao.getTCustomerByExcel(cardno);
    }

    @Override
    public TCard findCardByCardno(String cardno) {

        return cardDao.findCardByCardno(cardno);
    }

    @Override
    public boolean updateCard(TCard bean) {
        return cardDao.updateCard(bean);
    }
}
