package com.supwisdom.dlpay.ncmgr.dao;

import com.supwisdom.dlpay.doorlist.bean.TDoordevInfo;
import com.supwisdom.dlpay.ncmgr.domain.TBuilding;
import com.supwisdom.dlpay.ncmgr.domain.TNcDevice;
import com.supwisdom.dlpay.system.domain.TRegion;
import com.supwisdom.dlpay.system.page.Pagination;

import java.util.List;

public interface NcDeviceDao {
    public Pagination getSystemNcDeviceWithPage(String devname, int pageNo, int pageSize, String buildingid,String regionid, String devtype);

    public Pagination getOperatorNcDeviceWithPage(String devname,int pageNo,int pageSize, String buildingid,String regionid,String devtype,String operRegionid);

    public Pagination getBuildingOperNcDeviceWithPage(String devname,int pageNo,int pageSize,String buildingid,String devtype,String operid);

    public List<TBuilding> getAllBuilding();

    public List<TRegion> getAllRegion();

    public TBuilding getBuidingById(String id);

    public List<TNcDevice> getSystemDevByType(String type);

    public List<TNcDevice> getOperatorDevByType(String type,String regionid);

    public List<TNcDevice> getBuildingOperDevByType(String type,String operid);

    public TNcDevice findDevById(int id);

    public TNcDevice validDevName(int devid,String devname);

    public TNcDevice validDevPhyid(int devid,String devPhyid);

    public TNcDevice validDevNo(int fdevid,int devno,int devid);

    public boolean updateDevice(TNcDevice bean);

    public int getMaxId();

    public boolean saveDevice(TNcDevice bean);

    public TNcDevice getDevInfoByDevid(int devid);

    public List<TNcDevice> getDevListByfDevid(int devid);

    public boolean updateTodelDevById(int devid);

    public List<TNcDevice> findAllNcDevices();

    public TNcDevice getDevByBuildingid(String buildingid);

    public List<TNcDevice> findOperatorDevices(String operRegionid);


    public List<TDoordevInfo> getSystemDevList(String devname,String regionid,String buildingid);

    public List<TDoordevInfo> getOperatorDevList(String devname,String regionid,String buildingid,String operRegionid);

    public List<TDoordevInfo> getBuildingOperDevList(String devname,String regionid,String buildingid,String operid);

    public void updateBuildingnameByBuildingid(String buildingid,String buildingname);

    public Pagination getAllRemoteDev(String devname, int pageNo, int pageSize, String buildingid,String regionid);

    public Pagination getOperateRemoteDev(String devname, int pageNo, int pageSize, String buildingid,String regionid,String operRegionid);

    public Pagination getBuildingOperRemoteDev(String devname, int pageNo, int pageSize, String buildingid,String regionid,String operid);

}
