package com.supwisdom.dlpay.ncmgr.dao.impl;

import com.supwisdom.dlpay.doorlist.bean.TNcCardlistDeleteInfo;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.ncmgr.dao.NcCardListDao;
import com.supwisdom.dlpay.ncmgr.domain.TNcCardlist;
import com.supwisdom.dlpay.system.page.Pagination;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import java.util.List;

@Repository
public class NcCardListDaoImpl implements NcCardListDao {

    @PersistenceContext
    EntityManager entityManager;

    @Transactional
    @Override
    public TNcCardlist getCleanList(int devid) {
        String sql = "select t from TNcCardlist t where t.deviceid=:devid and t.operflag = 'Q'";
        TypedQuery<TNcCardlist> query = entityManager.createQuery(sql, TNcCardlist.class);
        query.setParameter("devid", devid);
        List<TNcCardlist> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public boolean saveCardlist(TNcCardlist bean) {
        boolean flag=false;
        try {
            entityManager.persist(bean);
            flag=true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    @Transactional
    @Override
    public boolean updateCardlist(TNcCardlist bean) {
        boolean flag = false;
        try {
            entityManager.merge(bean);
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    @Transactional
    @Override
    public void updateForListReload(int devid) {
        String sql = "update T_NC_CARDLIST set syncflag='N' ,synctime='' "+
                " where deviceid=?1 and operflag != 'Q'";
        Query query = entityManager.createNativeQuery(sql);
        query.setParameter(1, devid);
        query.executeUpdate();
    }

    @Transactional
    @Override
    public TNcCardlist getNcCardlist(int deviceid, String cardphyid, String timeid) {
        String sql = "select lst from TNcCardlist as lst,TNcAllottime as t where lst.listid=t.id.listid and" +
                " lst.deviceid=:deviceid and lst.cardphyid=:cardphyid and t.id.timeid=:timeid order by lst.listid desc";
        TypedQuery<TNcCardlist> query = entityManager.createQuery(sql, TNcCardlist.class);
        query.setParameter("deviceid", deviceid);
        query.setParameter("cardphyid", cardphyid);
        query.setParameter("timeid", timeid);
        List<TNcCardlist> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public Pagination getSystemCardList(String devname, String custname, String cardno, String syncflag, String regionid, String allocatStartDate, String allocatEndDate, String operflag, int pageNo, int pageSize) {
        String sql = "select a.listid,c.devname,a.custname,a.cardno,a.bankcardno,b.opername,a.syncflag,a.operflag,a.rectime,a.synctime " +
                " from t_nc_cardlist a left join tb_operator b on a.operid=b.operid left join t_nc_device c on a.deviceid = c.deviceid " +
                " where c.operflag='A' ";
        if (!StringUtil.isEmpty(allocatStartDate)){
            sql += " and substr(a.rectime,0,9)>=:allocatStartDate ";
        }
        if (!StringUtil.isEmpty(allocatEndDate)){
            sql += "and substr(a.rectime,0,9)<=:allocatEndDate ";
        }
        if (!StringUtil.isEmpty(devname)){
            sql += " and c.devname like :devname ";
        }
        if (!StringUtil.isEmpty(custname)){
            sql += " and a.custname like :custname ";
        }
        if (!StringUtil.isEmpty(cardno)){
            sql += " and a.cardno like :cardno ";
        }
        if (!StringUtil.isEmpty(syncflag)){
            sql += " and a.syncflag = :syncflag ";
        }
        if (!StringUtil.isEmpty(operflag)){
            sql += " and a.operflag = :operflag ";
        }
        if (!StringUtil.isEmpty(regionid)){
            sql += "and c.regionid in  " +
                    "(with recursive tmp as  (select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr " +
                    " where regionid= :regionid union all  select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  " +
                    " ) select regionid from tmp  )";
        }
        sql +=" order by a.listid desc " ;
        Query query = entityManager.createNativeQuery(sql, TNcCardlistDeleteInfo.class);
        if (!StringUtil.isEmpty(devname)){
            query.setParameter("devname", "%"+devname+"%");
        }
        if (!StringUtil.isEmpty(custname)){
            query.setParameter("custname", "%"+custname+"%");
        }
        if (!StringUtil.isEmpty(cardno)){
            query.setParameter("cardno", cardno);
        }
        if (!StringUtil.isEmpty(syncflag)){
            query.setParameter("syncflag", syncflag);
        }
        if (!StringUtil.isEmpty(operflag)){
            query.setParameter("operflag", operflag);
        }
        if (!StringUtil.isEmpty(regionid)){
            query.setParameter("regionid", regionid);
        }
        if (!StringUtil.isEmpty(allocatStartDate)) {
            query.setParameter("allocatStartDate", allocatStartDate);
        }
        if (!StringUtil.isEmpty(allocatEndDate)) {
            query.setParameter("allocatEndDate", allocatEndDate);
        }
        pageNo = pageNo <= 0 ? 1 : pageNo;
        query.setFirstResult((pageNo - 1) * pageSize);
        query.setMaxResults(pageSize);
        Pagination page = new Pagination();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        List<TNcCardlistDeleteInfo> list = query.getResultList();
        page.setList(list);
        int totalCount = getSystemCardListCount(devname,custname,cardno,syncflag,operflag,regionid,allocatStartDate, allocatEndDate);
        page.setTotalCount(totalCount);
        return page;
    }

    private int getSystemCardListCount(String devname, String custname, String cardno, String syncflag,String operflag, String regionid, String allocatStartDate, String allocatEndDate){
        String sql = " select count(*) from t_nc_cardlist a "+
                " left join t_nc_device c on a.deviceid = c.deviceid " +
                " where c.operflag='A' ";
        if (!StringUtil.isEmpty(allocatStartDate)){
            sql += " and substr(a.rectime,0,9)>=:allocatStartDate ";
        }
        if (!StringUtil.isEmpty(allocatEndDate)){
            sql += "and substr(a.rectime,0,9)<=:allocatEndDate ";
        }
        if (!StringUtil.isEmpty(devname)){
            sql += " and c.devname like :devname ";
        }
        if (!StringUtil.isEmpty(custname)){
            sql += " and a.custname like :custname ";
        }
        if (!StringUtil.isEmpty(cardno)){
            sql += " and a.cardno like :cardno ";
        }
        if (!StringUtil.isEmpty(syncflag)){
            sql += " and a.syncflag = :syncflag ";
        }
        if (!StringUtil.isEmpty(operflag)){
            sql += " and a.operflag = :operflag ";
        }
        if (!StringUtil.isEmpty(regionid)){
            sql += "and c.regionid in  " +
                    "(with recursive tmp as  (select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr " +
                    " where regionid= :regionid union all  select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  " +
                    " ) select regionid from tmp  )";
        }
        Query query = entityManager.createNativeQuery(sql);
        if (!StringUtil.isEmpty(devname)){
            query.setParameter("devname", "%"+devname+"%");
        }
        if (!StringUtil.isEmpty(custname)){
            query.setParameter("custname", "%"+custname+"%");
        }
        if (!StringUtil.isEmpty(cardno)){
            query.setParameter("cardno", cardno);
        }
        if (!StringUtil.isEmpty(syncflag)){
            query.setParameter("syncflag", syncflag);
        }
        if (!StringUtil.isEmpty(operflag)){
            query.setParameter("operflag", operflag);
        }
        if (!StringUtil.isEmpty(regionid)){
            query.setParameter("regionid", regionid);
        }
        if (!StringUtil.isEmpty(allocatStartDate)) {
            query.setParameter("allocatStartDate", allocatStartDate);
        }
        if (!StringUtil.isEmpty(allocatEndDate)) {
            query.setParameter("allocatEndDate", allocatEndDate);
        }
        int cnt=0;
        List list = query.getResultList();
        if (list!=null && list.size()>0){
            cnt = Integer.parseInt(list.get(0).toString());
        }
        return cnt;
    }

    @Transactional
    @Override
    public Pagination getOperatorCardList(String devname, String custname, String cardno, String syncflag, String regionid, String allocatStartDate, String allocatEndDate, String operflag, int pageNo, int pageSize, String operRegionid) {
        String sql = "select a.listid,c.devname,a.custname,a.cardno,a.bankcardno,b.opername,a.syncflag,a.operflag,a.rectime,a.synctime " +
                " from t_nc_cardlist a left join tb_operator b on a.operid=b.operid left join t_nc_device c on a.deviceid = c.deviceid " +
                " where c.operflag='A' ";
        if (!StringUtil.isEmpty(allocatStartDate)){
            sql += " and substr(a.rectime,0,9)>=:allocatStartDate ";
        }
        if (!StringUtil.isEmpty(allocatEndDate)){
            sql += "and substr(a.rectime,0,9)<=:allocatEndDate ";
        }
        if (!StringUtil.isEmpty(devname)){
            sql += " and c.devname like :devname ";
        }
        if (!StringUtil.isEmpty(custname)){
            sql += " and a.custname like :custname ";
        }
        if (!StringUtil.isEmpty(cardno)){
            sql += " and a.cardno like :cardno ";
        }
        if (!StringUtil.isEmpty(syncflag)){
            sql += " and a.syncflag = :syncflag ";
        }
        if (!StringUtil.isEmpty(operflag)){
            sql += " and a.operflag = :operflag ";
        }

            sql += "and c.regionid in  "
                    +"("
                    + "with recursive tmp as  "
                    + "("
                    + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr where regionid =:regionid  "
                    + "union all  "
                    + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  "
                    + ") select regionid from tmp  )";

        sql +=" order by a.listid desc " ;
        Query query = entityManager.createNativeQuery(sql, TNcCardlistDeleteInfo.class);
        if (!StringUtil.isEmpty(devname)){
            query.setParameter("devname", "%"+devname+"%");
        }
        if (!StringUtil.isEmpty(custname)){
            query.setParameter("custname", "%"+custname+"%");
        }
        if (!StringUtil.isEmpty(devname)){
            query.setParameter("cardno", cardno);
        }
        if (!StringUtil.isEmpty(syncflag)){
            query.setParameter("syncflag", syncflag);
        }
        if (!StringUtil.isEmpty(operflag)){
            query.setParameter("operflag", operflag);
        }
        if (!StringUtil.isEmpty(regionid)){
            query.setParameter("regionid", regionid);
        }else {
            query.setParameter("regionid", operRegionid);
        }
        if (!StringUtil.isEmpty(allocatStartDate)) {
            query.setParameter("allocatStartDate", allocatStartDate);
        }
        if (!StringUtil.isEmpty(allocatEndDate)) {
            query.setParameter("allocatEndDate", allocatEndDate);
        }
        pageNo = pageNo <= 0 ? 1 : pageNo;
        query.setFirstResult((pageNo - 1) * pageSize);
        query.setMaxResults(pageSize);
        Pagination page = new Pagination();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        List<TNcCardlistDeleteInfo> list = query.getResultList();
        page.setList(list);
        int totalCount = getOperatorCardListCount(devname,custname,cardno,syncflag,operflag,regionid,allocatStartDate, allocatEndDate,operRegionid);
        page.setTotalCount(totalCount);
        return page;
    }

    private int getOperatorCardListCount(String devname, String custname, String cardno, String syncflag,String operflag, String regionid, String allocatStartDate, String allocatEndDate,String operRegionid){
        String sql = "select count(*) from t_nc_cardlist a " +
                " left join t_nc_device c on a.deviceid = c.deviceid " +
                " where c.operflag='A' ";
        if (!StringUtil.isEmpty(allocatStartDate)){
            sql += " and substr(a.rectime,0,9)>=:allocatStartDate ";
        }
        if (!StringUtil.isEmpty(allocatEndDate)){
            sql += "and substr(a.rectime,0,9)<=:allocatEndDate ";
        }
        if (!StringUtil.isEmpty(devname)){
            sql += " and c.devname like :devname ";
        }
        if (!StringUtil.isEmpty(custname)){
            sql += " and a.custname like :custname ";
        }
        if (!StringUtil.isEmpty(cardno)){
            sql += " and a.cardno like :cardno ";
        }
        if (!StringUtil.isEmpty(syncflag)){
            sql += " and a.syncflag = :syncflag ";
        }
        if (!StringUtil.isEmpty(operflag)){
            sql += " and a.operflag = :operflag ";
        }

            sql += "and c.regionid in  "
                    +"("
                    + "with recursive tmp as  "
                    + "("
                    + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr where regionid =:regionid  "
                    + "union all  "
                    + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  " + ") select regionid from tmp  )";

        Query query = entityManager.createNativeQuery(sql);
        if (!StringUtil.isEmpty(devname)){
            query.setParameter("devname", "%"+devname+"%");
        }
        if (!StringUtil.isEmpty(custname)){
            query.setParameter("custname", "%"+custname+"%");
        }
        if (!StringUtil.isEmpty(devname)){
            query.setParameter("cardno", cardno);
        }
        if (!StringUtil.isEmpty(syncflag)){
            query.setParameter("syncflag", syncflag);
        }
        if (!StringUtil.isEmpty(operflag)){
            query.setParameter("operflag", operflag);
        }
        if (!StringUtil.isEmpty(regionid)){
            query.setParameter("regionid", regionid);
        }else {
            query.setParameter("regionid", operRegionid);
        }
        if (!StringUtil.isEmpty(allocatStartDate)) {
            query.setParameter("allocatStartDate", allocatStartDate);
        }
        if (!StringUtil.isEmpty(allocatEndDate)) {
            query.setParameter("allocatEndDate", allocatEndDate);
        }

        int cnt=0;
        List list = query.getResultList();
        if (list!=null && list.size()>0){
            cnt = Integer.parseInt(list.get(0).toString());
        }
        return cnt;
    }

    @Transactional
    @Override
    public Pagination getBuildingOperCardList(String devname, String custname, String cardno, String syncflag, String allocatStartDate, String allocatEndDate, String operflag, int pageNo, int pageSize, String operid) {
        String sql = "select a.listid,c.devname,a.custname,a.cardno,a.bankcardno,b.opername,a.syncflag,a.operflag,a.rectime,a.synctime " +
                " from t_nc_cardlist a left join tb_operator b on a.operid=b.operid left join t_nc_device c on a.deviceid = c.deviceid " +
                " left join t_operbuilding d on d.buildingid = c.buildingid "+
                " where c.operflag='A' and d.operid = :operid ";
        if (!StringUtil.isEmpty(allocatStartDate)){
            sql += " and substr(a.rectime,0,9)>=:allocatStartDate ";
        }
        if (!StringUtil.isEmpty(allocatEndDate)){
            sql += "and substr(a.rectime,0,9)<=:allocatEndDate ";
        }
        if (!StringUtil.isEmpty(devname)){
            sql += " and c.devname like :devname ";
        }
        if (!StringUtil.isEmpty(custname)){
            sql += " and a.custname like :custname ";
        }
        if (!StringUtil.isEmpty(cardno)){
            sql += " and a.cardno like :cardno ";
        }
        if (!StringUtil.isEmpty(syncflag)){
            sql += " and a.syncflag = :syncflag ";
        }
        if (!StringUtil.isEmpty(operflag)){
            sql += " and a.operflag = :operflag ";
        }
        sql +=" order by a.listid desc " ;
        Query query = entityManager.createNativeQuery(sql, TNcCardlistDeleteInfo.class);
        if (!StringUtil.isEmpty(devname)){
            query.setParameter("devname", "%"+devname+"%");
        }
        if (!StringUtil.isEmpty(custname)){
            query.setParameter("custname", "%"+custname+"%");
        }
        if (!StringUtil.isEmpty(devname)){
            query.setParameter("cardno", cardno);
        }
        if (!StringUtil.isEmpty(syncflag)){
            query.setParameter("syncflag", syncflag);
        }
        if (!StringUtil.isEmpty(operflag)){
            query.setParameter("operflag", operflag);
        }
        query.setParameter("operid", operid);
        if (!StringUtil.isEmpty(allocatStartDate)) {
            query.setParameter("allocatStartDate", allocatStartDate);
        }
        if (!StringUtil.isEmpty(allocatEndDate)) {
            query.setParameter("allocatEndDate", allocatEndDate);
        }
        pageNo = pageNo <= 0 ? 1 : pageNo;
        query.setFirstResult((pageNo - 1) * pageSize);
        query.setMaxResults(pageSize);
        Pagination page = new Pagination();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        List<TNcCardlistDeleteInfo> list = query.getResultList();
        page.setList(list);
        int totalCount = getBuildingOperCardListCount(devname,custname,cardno,syncflag,operflag,operid,allocatStartDate, allocatEndDate);
        page.setTotalCount(totalCount);
        return page;
    }

    private int getBuildingOperCardListCount(String devname, String custname, String cardno, String syncflag,String operflag, String operid, String allocatStartDate, String allocatEndDate){
        String sql = "select count(*) from t_nc_cardlist a " +
                " left join t_nc_device c on a.deviceid = c.deviceid " +
                " left join t_operbuilding d on d.buildingid = c.buildingid "+
                " where c.operflag='A' and d.operid = :operid ";
        if (!StringUtil.isEmpty(allocatStartDate)){
            sql += " and substr(a.rectime,0,9)>=:allocatStartDate ";
        }
        if (!StringUtil.isEmpty(allocatEndDate)){
            sql += "and substr(a.rectime,0,9)<=:allocatEndDate ";
        }
        if (!StringUtil.isEmpty(devname)){
            sql += " and c.devname like :devname ";
        }
        if (!StringUtil.isEmpty(custname)){
            sql += " and a.custname like :custname ";
        }
        if (!StringUtil.isEmpty(cardno)){
            sql += " and a.cardno like :cardno ";
        }
        if (!StringUtil.isEmpty(syncflag)){
            sql += " and a.syncflag = :syncflag ";
        }
        if (!StringUtil.isEmpty(operflag)){
            sql += " and a.operflag = :operflag ";
        }
        Query query = entityManager.createNativeQuery(sql);
        if (!StringUtil.isEmpty(devname)){
            query.setParameter("devname", "%"+devname+"%");
        }
        if (!StringUtil.isEmpty(custname)){
            query.setParameter("custname", "%"+custname+"%");
        }
        if (!StringUtil.isEmpty(devname)){
            query.setParameter("cardno", cardno);
        }
        if (!StringUtil.isEmpty(syncflag)){
            query.setParameter("syncflag", syncflag);
        }
        if (!StringUtil.isEmpty(operflag)){
            query.setParameter("operflag", operflag);
        }
        query.setParameter("operid", operid);
        if (!StringUtil.isEmpty(allocatStartDate)) {
            query.setParameter("allocatStartDate", allocatStartDate);
        }
        if (!StringUtil.isEmpty(allocatEndDate)) {
            query.setParameter("allocatEndDate", allocatEndDate);
        }
        int cnt=0;
        List list = query.getResultList();
        if (list!=null && list.size()>0){
            cnt = Integer.parseInt(list.get(0).toString());
        }
        return cnt;
    }

    @Transactional
    @Override
    public TNcCardlist getNcCardlistById(String id) {
        String sql = " select bean from TNcCardlist bean where bean.operflag='A' and bean.listid = :listid ";
        TypedQuery<TNcCardlist> query = entityManager.createQuery(sql, TNcCardlist.class);
        query.setParameter("listid", id);
        List<TNcCardlist> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public boolean updateNcCardlist(TNcCardlist bean) {
        boolean flag = false;
        try {
            entityManager.merge(bean);
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    @Transactional
    @Override
    public List<TNcCardlist> getNcCardlistByCardno(String cardno) {
        String sql = " select bean from TNcCardlist bean where bean.cardno = :cardno ";
        TypedQuery<TNcCardlist> query = entityManager.createQuery(sql, TNcCardlist.class);
        query.setParameter("cardno", cardno);
        List<TNcCardlist> list = query.getResultList();
        return list;
    }
}
