package com.supwisdom.dlpay.system.controller;

import com.supwisdom.dlpay.api.bean.JsonResult;
import com.supwisdom.dlpay.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import com.supwisdom.dlpay.system.common.DictPool;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import java.util.Map;

@RestController
public class DictPoolAction {
  @Autowired
  private DictPool dictPool;
  @Autowired
  SystemService systemService;

  @GetMapping("/dictpool")
  public Map getDictDataByDicttype(@FormParam("dicttype") String dictType, HttpServletRequest request) {
    dictType = request.getParameter("dicttype");
    Map res = DictPool.getDictMap(dictType);
    return res;
  }

  @GetMapping("/dictrefresh")
  public JsonResult refreshDict() {
    //dictPool.init();
    systemService.refreshCache();
    systemService.refreshOpertypesCashe();
    return JsonResult.ok();
  }

}
