package com.supwisdom.dlpay.system.domain;

import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;


@Entity
@Table(name = "T_OPERBUILDING")
public class TOperbuilding implements java.io.Serializable {

	// Fields

	private TOperbuildingId id;
	private String updtime;
	private String allotoperid;
	private String memo;

	// Constructors

	/** default constructor */
	public TOperbuilding() {
	}

	/** minimal constructor */
	public TOperbuilding(TOperbuildingId id) {
		this.id = id;
	}

	/** full constructor */
	public TOperbuilding(TOperbuildingId id, String updtime, String allotoperid,
			String memo) {
		this.id = id;
		this.updtime = updtime;
		this.allotoperid = allotoperid;
		this.memo = memo;
	}

	// Property accessors
	@EmbeddedId
	@AttributeOverrides({
			@AttributeOverride(name = "operid", column = @Column(name = "OPERID", nullable = false, length = 32)),
			@AttributeOverride(name = "buildingid", column = @Column(name = "BUILDINGID", nullable = false, length = 32)) })
	public TOperbuildingId getId() {
		return this.id;
	}

	public void setId(TOperbuildingId id) {
		this.id = id;
	}

	@Column(name = "UPDTIME", length = 30)
	public String getUpdtime() {
		return this.updtime;
	}

	public void setUpdtime(String updtime) {
		this.updtime = updtime;
	}

	@Column(name = "ALLOTOPERID", length = 32)
	public String getAllotoperid() {
		return this.allotoperid;
	}

	public void setAllotoperid(String allotoperid) {
		this.allotoperid = allotoperid;
	}

	@Column(name = "MEMO", length = 255)
	public String getMemo() {
		return this.memo;
	}

	public void setMemo(String memo) {
		this.memo = memo;
	}

}