package com.supwisdom.dlpay.system.service.impl;

import com.supwisdom.dlpay.framework.dao.DictionaryDao;
import com.supwisdom.dlpay.framework.domain.TTDictionary;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.system.service.DictionaryDataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;

@Service
public class DictionaryDataServiceImpl implements DictionaryDataService {
  @Autowired
  private DictionaryDao dictionaryDao;


  @Override
  public HashMap<String, Object> getSystemAllSourcetype() {
    return null;
  }

  @Override
  public HashMap<String, Object> getDictionaryByDicttype(int dicttype) {
    HashMap<String, Object> result = new HashMap<>(0);
    List<TTDictionary> list = dictionaryDao.findAllByDicttype(dicttype);
    if (!StringUtil.isEmpty(list)) {
      for (TTDictionary dict : list) {
        result.put(dict.getDictval() == null ? "" : dict.getDictval(), dict.getDictcaption());
      }
    }
    return result;
  }
}
