package com.supwisdom.dlpay.system.service.impl;

import com.supwisdom.dlpay.ncmgr.domain.TBuilding;
import com.supwisdom.dlpay.system.bean.AllotBuildingBean;
import com.supwisdom.dlpay.system.bean.RegionZTreeNodes;
import com.supwisdom.dlpay.system.dao.*;
import com.supwisdom.dlpay.system.domain.*;
import com.supwisdom.dlpay.system.page.Pagination;
import com.supwisdom.dlpay.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class SystemServiceImpl implements SystemService {
    @Autowired
    private DictionaryDao dictionaryDao;
    @Autowired
    private OperatorDao operatorDao;
    @Autowired
    private RegionDao regionDao;
    @Autowired
    private BuildingDao buildingDao;
    @Autowired
    private SystemParamDao systemParamDao;

    @Override
    @CacheEvict(cacheNames = "door_dictionary_cache", key = "'.*'", allEntries = true)
    public void refreshCache() {

    }

    @Override
    @CacheEvict(cacheNames = "door_opertypes_cache", key = "'.*'", allEntries = true)
    public void refreshOpertypesCashe() {

    }

    @Override
    public Pagination findDictionary(String dicttype, String dictcaption, Integer pageNo, Integer pageSize) {
        return dictionaryDao.findDictionary(dicttype, dictcaption, pageNo, pageSize);
    }

    @Override
    public List<DictionaryType> findDictionaryType() {
        return dictionaryDao.findDictionaryType();
    }

    @Override
    @CacheEvict(cacheNames = "door_dicationary_cache", key = "#p0")
    public boolean saveDictionary(String dicttype, String dicttypename, String dictval, String dictcaption) {
        TDictionary tDictionary = new TDictionary();
        TDictionaryId tDictionaryId = new TDictionaryId();
        tDictionaryId.setDicttype(Integer.parseInt(dicttype));
        tDictionaryId.setDicttypename(dicttypename);
        tDictionaryId.setDictval(dictval);
        tDictionaryId.setDictcaption(dictcaption);
        tDictionary.setId(tDictionaryId);
        boolean b = dictionaryDao.saveDictionary(tDictionary);
        return b;
    }

    @Override
    @Cacheable(cacheNames = "door_dicationary_cache", key = "#p0")
    public List<TDictionaryId> findTDictionaryByType(int type) {
        return dictionaryDao.findTDictionaryByType(type);
    }

    @Override
    @Cacheable(cacheNames = "door_opertypes_cache", key = "#p0")
    public List<TDictionaryId> findOpertypes(String opertype) {
        return dictionaryDao.findOpertypes(opertype);
    }

    @Override
    public List<TDictionaryId> findByType(int type, String dicVal) {
        return dictionaryDao.findByType(type, dicVal);
    }

    @Override
    @CacheEvict(cacheNames = "door_dicationary_cache", key = "#p0")
    public TDictionary updateDictionary(String dicttype, String dicttypename, String dictval, String dictcaption, String oriengaltype, String oriengalval) {
        return dictionaryDao.updateDictionary(dicttype, dicttypename, dictval, dictcaption, oriengaltype, oriengalval);
    }

    @Override
    public TSystemParam getSystemParamByKey(String paramKey) {
        return systemParamDao.getSystemParamByKey(paramKey);
    }

    @Override
    public boolean updateSystemParamValueByKey(String paramKey, String paramValue) {
        return systemParamDao.updateSystemParamValueByKey(paramKey, paramValue);
    }

    @Override
    public boolean saveSystemParam(TSystemParam bean) {
        return systemParamDao.saveSystemParam(bean);
    }


    @Override
    public Pagination getSystemRegionList(String regionname, int pageNo, int pageSize) {
        return regionDao.getSystemRegionList(regionname, pageNo, pageSize);
    }

    @Override
    public Pagination getOperatorRegionList(String regionname, String regionid, int pageNo, int pageSize) {
        return regionDao.getOperatorRegionList(regionname, regionid, pageNo, pageSize);
    }

    @Override
    public List<TBuilding> getBuildingByRegionId(String regionid) {
        return buildingDao.getBuildingByRegionId(regionid);
    }

    @Override
    public List<TBuilding> getOperatorBuildingByRegionId(String regionid, String operRegionid) {
        return buildingDao.getOperatorBuildingByRegionId(regionid,operRegionid);
    }

    @Override
    public List<TBuilding> getBuildingOperBuildingByRegionId(String regionid,String operid) {
        return buildingDao.getBuildingOperBuildingByRegionId(regionid, operid);
    }

    @Override
    public boolean deleteRegionById(String regionid) {
        return regionDao.updateRegionFlag(regionid);
    }

    @Override
    public TRegion getRegionById(String regionid) {
        return regionDao.getRegionById(regionid);
    }

    @Override
    public TRegion getRegionAllFlagById(String regionid) {
        return regionDao.getRegionAllFlagById(regionid);
    }

    @Override
    public List<TRegion> getRegionListById(String regionid) {
        return regionDao.getRegionListById(regionid);
    }

    @Override
    public List<TRegion> getLowRegionListById(String regionid) {
        return regionDao.getLowRegionListById(regionid);
    }

    @Override
    public List<TRegion> getRegionListByLevel(int level) {
        return regionDao.getRegionListByLevel(level);
    }

    @Override
    public List<TRegion> getOperRegionListByLevel(int level, String regionid) {
        return regionDao.getOperRegionListByLevel(level, regionid);
    }

    @Override
    public List<TRegion> getAllRegions() {
        return regionDao.getAllRegions();
    }

    @Override
    public TRegion getRegionByName(String regionname) {
        return regionDao.getRegionByName(regionname);
    }

    @Override
    public boolean saveRegion(TRegion bean) {
        return regionDao.saveRegion(bean);
    }

    @Override
    public TRegion getRegionByNameAndId(String regionname, String regionid) {
        return regionDao.getRegionByNameAndId(regionname, regionid);
    }

    @Override
    public boolean updateRegion(TRegion bean) {
        return regionDao.updateRegion(bean);
    }

    @Override
    public boolean updateParentnameById(String regionid, String parentname) {
        return regionDao.updateParentnameById(regionid, parentname);
    }

    @Override
    public List<RegionZTreeNodes> getAllRegionTreeList() {
        List<RegionZTreeNodes> regionZTreeNodesList = new ArrayList<>();
        List<TRegion> regions = regionDao.getAllRegions();
        for (TRegion region:regions){
            RegionZTreeNodes node = new RegionZTreeNodes();
            node.setId(region.getRegionid());
            node.setName(region.getRegionname()+"-"+region.getLevel()+"级");
            node.setpId(region.getParentid());
            node.setParent(false);
            regionZTreeNodesList.add(node);
        }

        return regionZTreeNodesList;
    }


    @Override
    public Pagination getSystemBuildingList(String regionid, String buildingname, int pageNo, int pageSize) {
        return buildingDao.getSystemBuildingList(regionid, buildingname, pageNo, pageSize);
    }

    @Override
    public Pagination getOperatorBuildingList(String operRegionid, String regionid, String buildingname, int pageNo, int pageSize) {
        return buildingDao.getOperatorBuildingList(operRegionid, regionid, buildingname, pageNo, pageSize);
    }

    @Override
    public Pagination getBuildingOperBuildingList(String regionid, String buildingname, String operid, int pageNo, int pageSize) {
        return buildingDao.getBuildingOperBuildingList(regionid, buildingname, operid, pageNo, pageSize);
    }

    @Override
    public TBuilding getBuildingById(String buildingid) {
        return buildingDao.getBuildingById(buildingid);
    }

    @Override
    public TBuilding getBuildingByName(String buildingname) {
        return buildingDao.getBuildingByName(buildingname);
    }

    @Override
    public boolean saveBuilding(TBuilding bean) {
        return buildingDao.saveBuilding(bean);
    }

    @Override
    public TBuilding getBuildingByNameAndId(String buildingname, String buildingid) {
        return buildingDao.getBuildingByNameAndId(buildingname, buildingid);
    }

    @Override
    public boolean updateBuilding(TBuilding bean) {
        return buildingDao.updateBuilding(bean);
    }

    @Override
    public boolean delBuilding(String buildingid) {
        return buildingDao.updateBuildingFlag(buildingid);
    }

    @Override
    public List<AllotBuildingBean> findSystemAllotBuildingList() {
        return buildingDao.findSystemAllotBuildingList();
    }

    @Override
    public List<AllotBuildingBean> findOperatorAllotBuildingList(String operRegionid) {
        return buildingDao.findOperatorAllotBuildingList(operRegionid);
    }

    @Override
    public List<AllotBuildingBean> findBuildingInOper(String operid) {
        return buildingDao.findBuildingInOper(operid);
    }

    @Override
    public boolean deleteOperBuildingByOperid(String operid) {
        return buildingDao.deleteOperBuildingByOperid(operid);
    }

    @Override
    public boolean saveOperBuilding(TOperbuilding bean) {
        return buildingDao.saveOperBuilding(bean);
    }

    @Override
    public List<TBuilding> getAllBuildings() {
        return buildingDao.getAllBuildings();
    }

    @Override
    public List<TBuilding> getOperatorBuildings(String regionid) {
        return buildingDao.getOperatorBuildings(regionid);
    }

    @Override
    public List<TBuilding> getBuildingOperBuildings(String operid) {
        return buildingDao.getBuildingOperBuildings(operid);
    }

}
