package com.supwisdom.dlpay.task;

import com.supwisdom.dlpay.api.bean.CardsResponse;
import com.supwisdom.dlpay.api.bean.CitizenCardInfo;
import com.supwisdom.dlpay.api.bean.QueryCardsParam;
import com.supwisdom.dlpay.doorlist.service.DoorlistMgrService;
import com.supwisdom.dlpay.framework.util.DateUtil;
import com.supwisdom.dlpay.mainservice.domain.TCard;
import com.supwisdom.dlpay.mainservice.service.WebInterfaceService;
import com.supwisdom.dlpay.paysdk.ApiLoginHelper;
import com.supwisdom.dlpay.paysdk.proxy.ApiLoginProxy;
import com.supwisdom.dlpay.paysdk.proxy.UserProxy;
import com.supwisdom.dlpay.system.domain.TSystemParam;
import com.supwisdom.dlpay.system.service.SystemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.LinkedHashMap;
import java.util.List;

@Component
@Configuration      //1.主要用于标记配置类，兼备Component的效果。
@EnableScheduling   // 2.开启定时任务
@EnableFeignClients(basePackages = "com.supwisdom.dlpay.paysdk")
@ComponentScan(basePackages = {"com.supwisdom.dlpay.paysdk"})
public class SyncCustomerTask {

    protected static Logger logger = LoggerFactory.getLogger(SyncCustomerTask.class);

    private static final String impcustomeFirstFlag = "IMPCUSTOME_FIRST_FLAG";

    private static final String impcustomeFirstTime = "IMPCUSTOME_FIRST_TIME";

    private static final String lastSyncTime = "LAST_SYNC_TIME";

    private static final String payapiAppid = "PAYAPI_APPID";

    private static final String payapiSecret = "PAYAPI_SECRET";

    @Autowired
    private SystemService systemService;

    @Autowired
    private WebInterfaceService webInterfaceService;

    @Autowired
    private DoorlistMgrService doorlistMgrService;


    @Autowired
    private ApiLoginProxy apiLoginProxy;

    @Autowired
    private UserProxy userProxy;

    @Scheduled(cron = "${sync.cardStatus.cron}")//十分钟执行一次
    private void getCardStatusChangeTask(){
        String startTime = "";
        boolean firstImpFlag = false;
        try {
            String now = DateUtil.getNow();
            logger.info("时间:" + now + "--开始进行数据同步");
            //1.验证是否导入过名单
            TSystemParam impcustomeFirstParam = systemService.getSystemParamByKey(impcustomeFirstFlag);
            if ("0".equals(impcustomeFirstParam.getParamValue())) {
                //没有名单导入 不进行数据同步
                return;
            } else if ("1".equals(impcustomeFirstParam.getParamValue())) {
                //名单第一次导入 未进行数据同步
                TSystemParam impcustomeFirstTimeParam = systemService.getSystemParamByKey(impcustomeFirstTime);
                startTime = impcustomeFirstTimeParam.getParamValue();
                firstImpFlag = true;
            } else {
                //上次数据同步时间
                TSystemParam lastSyncTimeParam = systemService.getSystemParamByKey(lastSyncTime);
                startTime = lastSyncTimeParam.getParamValue();
            }
            //2.登陆核心平台
            ApiLoginHelper helper = new ApiLoginHelper(apiLoginProxy);
            TSystemParam appidSystemParam = systemService.getSystemParamByKey(payapiAppid);
            String appid = appidSystemParam.getParamValue();
            TSystemParam secretSystemParam = systemService.getSystemParamByKey(payapiSecret);
            String secret = secretSystemParam.getParamValue();
            helper.login(appid, secret);


            QueryCardsParam param = new QueryCardsParam();
            param.setStarttime(startTime);
            param.setEndtime(now);

            CardsResponse response = userProxy.querycards(param);
            if (0 == response.getRetcode()) {
                List<CitizenCardInfo> cards = response.getCards();
                for (CitizenCardInfo card : cards) {//3.根据获取到的card数据进行同步
                    String cardno = card.getCardno();
                    String status = card.getCardstatus();
                    String transStatus = card.getTransstatus();
                    //(1).判断数据库中是否存在该卡
                    TCard cardByCardno = webInterfaceService.findCardByCardno(cardno);
                    if (cardByCardno == null) {
                        continue;
                    }
                    //(2).同步卡状态
                    cardByCardno.setStatus(status);
                    cardByCardno.setTranstatus(transStatus);
                    cardByCardno.setLastsavedtime(now);
                    cardByCardno.setCardverno((Integer.parseInt(cardByCardno.getCardverno()) + 1)+"");
                    webInterfaceService.updateCard(cardByCardno);
                    //(3).同步下发状态
                    doorlistMgrService.syncNcCardlistByCardnoAndStatus(cardno, status, transStatus);
                }

                if (firstImpFlag) {//第一次导入成功后 需要修改第一次导入参数
                    systemService.updateSystemParamValueByKey(impcustomeFirstFlag, "2");
                }

                //保存此次同步时间
                systemService.updateSystemParamValueByKey(lastSyncTime, now);

            }
        }catch (Exception e){
            logger.error(e.getMessage());
        }
    }
}
