package com.supwisdom.dlpay.util;

import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class UploadExcelCardno {

	public static List readExcel(File file,String sheetName) throws Exception{
		Workbook rwb = null;
		InputStream  is = null;
		List<List<String>> biglist = new ArrayList<List<String>>();
//		String cardno = "";
		List<String> cardno = new ArrayList<String>();
		List<String> deviceid = new ArrayList<>();
		try {
			// 构建Workbook对象, 只读Workbook对象
			// 直接从本地文件创建Workbook
			// 从输入流创建
			is = new FileInputStream(file);
			rwb = Workbook.getWorkbook(is);
			// Sheet(术语：工作表)就是Excel表格左下角的Sheet1,Sheet2,Sheet3但在程序中Sheet的下标是从0开始
			// 获取第一张Sheet表
//			Sheet rs = rwb.getSheet(0);
			Sheet rs = rwb.getSheet(sheetName);
			System.out.println(rs);
			if(rs==null){
				return null;
			}
			// 获取Sheet表中所包含的总列数
			int rsColumns = rs.getColumns();
			// 获取Sheet表中所包含的总行数
			int rsRows = rs.getRows();
			// 获取指定单元格的对象引用
			List<String> colnames = new ArrayList<String>();
			int cardIndex = 0;
			for (int j = 0; j < rsColumns; j++) {
				Cell cell = rs.getCell(j, 0);
				String colname = cell.getContents();
				if(("卡号").equals(colname)){
					cardIndex = j;
				}
				colnames.add(cell.getContents());
			}
			
			biglist.add(colnames);
			// **从第二行开始读取数据 这里默认从第2行开始读取
			for (int i = 1; i < rsRows; i++) {
				List<String> smalllist = new ArrayList<String>();
				boolean flag = false;
				for (int j = 0; j < rsColumns; j++) {
					Cell cell = rs.getCell(j, i);
					smalllist.add(cell.getContents());
					if (cell.getContents() != null
							&& !"".equals(cell.getContents())) {
						flag = true;
					}
					if(j == cardIndex){
						cardno.add(cell.getContents());
					}
				}
				if (flag) {
					biglist.add(smalllist);
				}
			}
			return biglist;
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			if (rwb != null) {
				rwb.close();
			}
			try {
				is.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return biglist;
	}	
}
