package com.supwisdom.dlpay.consume.controller;

import com.supwisdom.dlpay.consume.bean.BaseResp;
import com.supwisdom.dlpay.consume.bean.ReqParam;
import com.supwisdom.dlpay.consume.service.PayapiService;
import com.supwisdom.dlpay.consume.service.PaytypeService;
import com.supwisdom.dlpay.framework.data.SystemDateTime;
import com.supwisdom.dlpay.util.Code;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 统一支付入口
 * 1.支付
 * 2.冲正
 * 3.充值
 *
 * 校验
 * -参数
 * -签名
 */
@RestController
@RequestMapping("/unified")
public class PayapiAction {
    @Autowired
    private PayapiService payapiService;

    /**
     * 公共参数校验
     * */

    private boolean checkCommonParam(BaseResp resp,ReqParam param){
        if(param.getAmount()==null){
            resp.setRetcode("1");
            resp.setRetmsg("参数错误[amount]");
            return false;
        }
        if(StringUtils.isEmpty(param.getPayinfo())){
            resp.setRetcode("1");
            resp.setRetmsg("参数错误[payinfo]");
            return false;
        }
        if(StringUtils.isEmpty(param.getPaytype())){
            resp.setRetcode("1");
            resp.setRetmsg("参数错误[paytype]");
            return false;
        }
        if(StringUtils.isEmpty(param.getRefno())){
            resp.setRetcode("1");
            resp.setRetmsg("参数错误[refno]");
            return false;
        }
        return true;
    }
    /**
     *
     * 统一消费接口
     *
     *
     * */
    @RequestMapping("/consume")
    public BaseResp consume(@RequestBody ReqParam param) {
        BaseResp resp = new BaseResp();
        if(!checkCommonParam(resp,param)){
            return resp;
        }
        payapiService.doConsume(param,resp);
        return resp;
    }

    /**
     *
     * 统一冲正接口
     *
     *
     * */
    @RequestMapping("/reverse")
    public BaseResp reverse() {
        BaseResp resp = new BaseResp();
        resp.setCode(Code.SUCCESS);
        return resp;
    }

    /**
     *
     * 统一充值接口
     *
     * */
    @RequestMapping("/recharge")
    public BaseResp recharge() {
        BaseResp resp = new BaseResp();
        resp.setCode(Code.SUCCESS);
        return resp;
    }
}
