package com.supwisdom.dlpay.consume.dao;

import com.supwisdom.dlpay.consume.domain.TDebitCreditDtl;
import com.supwisdom.dlpay.consume.domain.TDebitCreditDtlPK;
import com.supwisdom.dlpay.framework.data.VoucherTemp;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@Repository
public interface DebitCreditDtlDao extends JpaRepository<TDebitCreditDtl, TDebitCreditDtlPK> {

  @Query(value = "select a.drsubjno,a.draccno,a.crsubjno,a.craccno,a.summary,count(*) as transcnt,sum(amount) as transamt " +
      "from TB_USERDTL_DEBITCREDIT a left join TB_USERDTL b on a.refno=b.refno " +
      "where b.status='success' and b.accdate=:settledate " +
      "group by a.drsubjno,a.draccno,a.crsubjno,a.craccno,a.summary ", nativeQuery = true)
  List<VoucherTemp> getVoucherData(@RequestParam("settledate") String settledate);


  List<TDebitCreditDtl> findByRefno(String refno);
}
