package com.supwisdom.dlpay.consume.service.impl;

import com.google.gson.Gson;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.supwisdom.dlpay.consume.bean.BaseResp;
import com.supwisdom.dlpay.consume.bean.ReqParam;
import com.supwisdom.dlpay.consume.bean.SupStatusRevResp;
import com.supwisdom.dlpay.consume.bean.SupYktResp;
import com.supwisdom.dlpay.consume.dao.TransdtlDao;
import com.supwisdom.dlpay.consume.domain.TPaytype;
import com.supwisdom.dlpay.consume.domain.TTransdtl;
import com.supwisdom.dlpay.consume.service.PayapiService;
import com.supwisdom.dlpay.consume.service.PaytypeService;
import com.supwisdom.dlpay.framework.data.SystemDateTime;
import com.supwisdom.dlpay.framework.service.SystemUtilService;
import com.supwisdom.dlpay.framework.util.DateUtil;
import com.supwisdom.dlpay.framework.util.TradeCode;
import com.supwisdom.dlpay.util.*;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by shuwei on 2019/4/9.
 */
@Service
public class PayapiServiceImpl implements PayapiService {
    @Autowired
    private TransdtlDao transdtlDao;
    @Autowired
    private SystemUtilService systemUtilService;
    @Autowired
    private PaytypeService paytypeService;
    private static final Logger logger = Logger.getLogger(PayapiServiceImpl.class);
    private static final Gson gson = new Gson();

    @Override
    public boolean doConsume(ReqParam param, BaseResp resp) {
        TTransdtl tTransdtl = transdtlDao.getByOuttradenoAndStatus(param.getRefno(), ConstUtil.STATUS_SUCCESS);
        if (tTransdtl != null) {
            resp.setRetcode("1");
            resp.setRetmsg("流水号重复");
            return false;
        }
        String refno = transdtlDao.getReno();
        if (StringUtils.isEmpty(refno)) {
            resp.setCode(Code.SYS_ERROR);
            return false;
        }
        tTransdtl = new TTransdtl();
        tTransdtl.setAccno(param.getAccno());
        tTransdtl.setAmount(MoneyUtil.FenToYuan(param.getAmount()));
        tTransdtl.setPaidamt(MoneyUtil.FenToYuan(param.getAmount()));
        tTransdtl.setShopaccno(param.getShopaccno());
        tTransdtl.setOuttradeno(param.getRefno());
        tTransdtl.setPaytype(param.getPaytype());
        tTransdtl.setTransdate(DateUtil.getNow("yyyyMMdd"));
        tTransdtl.setTranstime(DateUtil.getNow("hhmmss"));
        tTransdtl.setCreatetime(DateUtil.getNow());
        tTransdtl.setPayinfo(param.getPayinfo());
        tTransdtl.setStatus(ConstUtil.STATUS_INIT);
        tTransdtl.setRefno(refno);
        transdtlDao.save(tTransdtl);
        switch (param.getPaytype()) {
            case PaytypeUtil.YKTPAY:
                return doYKTPay(param, tTransdtl, resp);
        }
        resp.setCode(Code.PAYTYPE_NOT_SUPPORT);
        return false;
    }

    /**
     * 一卡通支付
     */

    private boolean doYKTPay(ReqParam param, TTransdtl dtl, BaseResp resp) {
        //TODO
        TPaytype paytype = paytypeService.getByPaytype(PaytypeUtil.YKTPAY);
        if (paytype == null || !ConstUtil.ENABLE_YES.equals(paytype.getEnable())) {
            resp.setCode(Code.PAYTYPE_NOT_SUPPORT);
            return false;
        }
        Map<String, String> config = paytypeService.getPaytypeConfigByPaytype(PaytypeUtil.YKTPAY);
        String appid = config.get("appid");
        String appkey = config.get("appkey");
        String orderurl = config.get("orderurl");
        if (config.size() == 0
                || StringUtils.isEmpty(appid)
                || StringUtils.isEmpty(appkey)
                || StringUtils.isEmpty(orderurl)) {
            resp.setCode(Code.PAYTYPE_CONFIG_ERROR);
            logger.error("支付方式未配置,appid=" + appid + ",appkey=" + appkey + ",orderurl=" + orderurl);
            return false;
        }
        SystemDateTime systemDateTime = systemUtilService.getSysdatetime();
        dtl.setAccdate(systemDateTime.getHostdate());
        Map<String, String> params = new HashMap<String, String>();
        params.put("partner_id", appid);
        params.put("stuempno", param.getAccno());
        params.put("tradeno", dtl.getRefno());
        params.put("tradename", param.getPayinfo());
        params.put("amount", param.getAmount() + "");
        params.put("shopid", param.getYktshopid());
        params.put("devphyid", param.getDevphyid());
        params.put("calcmanagefee", "T");//是否计算费率
        params.put("timestamp", systemDateTime.getHostdatetime());

        params.put("sign_method", "HMAC");
        params.put("limitflag", "off"); //是否判断消费限额，on-判断；off-不判断。默认on（判断限额）。为空或不为off都是on；
        String signstr = HmacUtil.createLinkString(HmacUtil.paraFilter(params));
        String sign = HmacUtil.HMACSHA1(signstr, appkey);
        signstr += "&sign=" + sign + "&sourcetype=food";
        Client c = Client.create();
        c.setConnectTimeout(20000);
        dtl.setTranstype(TradeCode.TRANSTYPE_YKTPAY);
        dtl.setTranscode(TradeCode.TRANSCODE_YKTPAY);

        WebResource r = c.resource(orderurl);
        ClientResponse respClient = r.post(ClientResponse.class, signstr);
        if (200 == respClient.getStatus()) {
            String ret = respClient.getEntity(String.class);
            logger.error("***************yktpay.ret=" + ret + "*************************");
            if (ret != null) {
                try {
                    SupYktResp result = gson.fromJson(ret, SupYktResp.class);
                    if (result == null) {
                        resp.setCode(Code.RESPNOSE_CONTENT_ERROR);
                        logger.error("支付内容转换失败:null");
                        return false;
                    }
                    if (!"0".equals(result.getRetcode())) {
                        if ("30".equals(result.getRetcode())) {
                            if (result.getOther() != null) {
                                try {
                                    SupStatusRevResp supStatusRevResp = gson.fromJson(result.getOther(), SupStatusRevResp.class);
                                    if (supStatusRevResp != null) {
                                        //同流水号，同一笔已经支付完成的，不重复支付。
                                        if (3 == supStatusRevResp.getStatus() && supStatusRevResp.getRevflag() != null && !supStatusRevResp.getRevflag()) {
                                            dtl.setStatus(ConstUtil.STATUS_SUCCESS);
                                            dtl.setAccdate(systemDateTime.getHostdate());
                                            transdtlDao.save(dtl);
                                            resp.setCode(Code.SUCCESS);
                                            return true;
                                        }
                                    }
                                } catch (Exception e) {
                                    e.printStackTrace();
                                    logger.error("返回内容转换失败:" + e.getMessage());
                                }
                            }
                        }
                        resp.setRetcode("1");
                        resp.setRetmsg("交易失败:" + result.getRetmsg());
                        logger.error(result.getRetmsg());
                        //dtl.setErrmsg(result.getRetmsg());
                        //payApiDTLDao.save(dtl);
                        return false;
                    }
                    dtl.setStatus(ConstUtil.STATUS_SUCCESS);
                    dtl.setAccdate(systemDateTime.getHostdate());
                    transdtlDao.save(dtl);
                    resp.setCode(Code.SUCCESS);
                    return true;
                } catch (Exception e) {
                    e.printStackTrace();
                    resp.setCode(Code.RESPNOSE_CONTENT_ERROR);
                    logger.error("支付内容转换失败:" + e.getMessage());
                    return false;
                }
            } else {
                resp.setCode(Code.REQUEST_ERROR);
                return false;
            }
        } else {
            resp.setCode(Code.REQUEST_ERROR);
            logger.error("请求返回失败:" + respClient.getEntity(String.class) + ",code=" + respClient.getStatus());
            return false;
        }
    }
}
