package com.supwisdom.dlpay.framework.dao;

import com.supwisdom.dlpay.framework.domain.TPeriod;
import com.supwisdom.dlpay.framework.domain.TPeriodPK;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.web.bind.annotation.RequestParam;

import javax.persistence.LockModeType;

@Repository
public interface PeriodDao extends JpaRepository<TPeriod, TPeriodPK> {
  @Query(value = "from TPeriod t where t.periodYear=:periodyear and t.periodMonth=:periodmonth ")
  TPeriod getPeriod(@RequestParam("periodyear") Integer periodyear, @RequestParam("periodmonth") Integer periodmonth);

  @Lock(LockModeType.PESSIMISTIC_FORCE_INCREMENT)
  @Query(value = "from TPeriod t where t.periodYear=:periodyear and t.periodMonth=:periodmonth ")
  TPeriod getTPeriodWithLock(@RequestParam("periodyear") Integer periodyear, @RequestParam("periodmonth") Integer periodmonth);
}
