package com.supwisdom.dlpay.framework.dao;

import com.supwisdom.dlpay.framework.domain.TShopaccbal;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.web.bind.annotation.RequestParam;

import javax.persistence.LockModeType;
import java.util.List;

@Repository
public interface ShopaccbalDao extends JpaRepository<TShopaccbal, String> {

  @Query(value = "select t.* from TB_SHOPACCBAL t left join (select shopaccno from TB_SHOPACCDAY where accdate=:lastsettday ) a on t.shopaccno=a.shopaccno where a.shopaccno is null ", nativeQuery = true)
  List<TShopaccbal> getUnsettleShopacc(@RequestParam("lastsettday") String lastsettday);

  @Lock(LockModeType.PESSIMISTIC_FORCE_INCREMENT)
  @Query(value = "from TShopaccbal where shopaccno=:shopaccno ")
  TShopaccbal getTShopaccbalByIdWithLock(@RequestParam("shopaccno")String shopaccno);

}
