package com.supwisdom.dlpay.framework.service;

import com.supwisdom.dlpay.framework.data.SystemDateTime;
import com.supwisdom.dlpay.framework.domain.TTaskLock;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public interface SystemUtilService {

  /**
   * 取数据库日期
   * */
  SystemDateTime getSysdatetime();

  /**
   * 更新任务表
   * */
  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
  TTaskLock updateTaskLock(TTaskLock lock);

  /**
   * 取任务表
   * */
  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
  TTaskLock doLockTask(String taskcode, Integer minRecover, String remark);

  /**
   * 获取记账日期
   * */
  String getAccdate();

  /**
   * 获取流水号
   * */
  String getRefno();

  /**
   * 按交易码取交易名称
   */
  String getTranscodeName(int transocde, String defaultValue);


}
