package com.supwisdom.dlpay.framework.service.impl;

import com.supwisdom.dlpay.consume.dao.DebitCreditDtlDao;
import com.supwisdom.dlpay.framework.dao.*;
import com.supwisdom.dlpay.framework.data.*;
import com.supwisdom.dlpay.framework.domain.*;
import com.supwisdom.dlpay.framework.service.DayendSettleService;
import com.supwisdom.dlpay.framework.service.SystemUtilService;
import com.supwisdom.dlpay.framework.util.DateUtil;
import com.supwisdom.dlpay.framework.util.MoneyUtil;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.framework.util.TradeDict;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class DayendSettleServiceImpl implements DayendSettleService {
  @Autowired
  private SystemUtilService systemUtilService;
  @Autowired
  private SettleLogDao settleLogDao;
  @Autowired
  private SettleCtlDao settleCtlDao;
  @Autowired
  private PeriodDao periodDao;
  @Autowired
  private VouchernoCtlDao vouchernoCtlDao;
  @Autowired
  private ShopaccDao shopaccDao;
  @Autowired
  private ShopaccbalDao shopaccbalDao;
  @Autowired
  private SubjectDao subjectDao;
  @Autowired
  private SubjectbalDao subjectbalDao;
  @Autowired
  private VoucherDao voucherDao;
  @Autowired
  private VoucherEntryDao voucherEntryDao;

  @Autowired
  private ShopaccdayDao shopaccdayDao;
  @Autowired
  private SubjectdayDao subjectdayDao;
  @Autowired
  private DebitCreditDtlDao debitCreditDtlDao;


  private static final Logger logger = Logger.getLogger(DayendSettleServiceImpl.class);

  private int hostdate;
  private int periodYear; // 记账年份
  private int periodMonth; // 记账月份
  private int settledate; //结算日期
  private int lastsettday; //结算前一天

  @Override
  public TSettleLog doCreateSettleLog() {
    TSettleLog log = new TSettleLog();
    log.setStarttime(systemUtilService.getSysdatetime().getHostdatetime());
    return settleLogDao.save(log);
  }

  @Override
  public TSettleLog doUpdateSettleLog(TSettleLog log) {
    if (null == log) return null;
    log.setEndtime(systemUtilService.getSysdatetime().getHostdatetime());
    return settleLogDao.save(log);
  }

  private boolean doSwitchPeriod() throws Exception {
    TPeriod period = periodDao.getTPeriodWithLock(periodYear, periodMonth);
    if (period.getSettleflag() == 1) {
      throw new Exception("月末结转已完成");
    }
    period.setSettleflag(1);
    periodDao.save(period); //已结

    if (periodMonth >= 12) {
      periodMonth = 1;
      periodYear = periodYear + 1; //年份加一
    } else {
      periodMonth = periodMonth + 1; //year不变
    }

    TPeriod nextPerid = periodDao.getPeriod(periodYear, periodMonth);
    if (null != nextPerid) {
      if (settledate != Integer.valueOf(nextPerid.getStartdate())) {
        throw new Exception("下一个会计期间的开始日期不正确");
      } else if (nextPerid.getSettleflag() == 1) {
        throw new Exception("下一个会计期间的月末结转已完成");
      }
    } else {
      Integer startdate = periodYear * 10000 + periodMonth * 100 + 1;
      Integer enddate = DateUtil.getLastDayOfMonth(periodYear, periodMonth);
      if (settledate != startdate) {
        throw new Exception("下一个会计期间的开始日期不正确");
      }
      nextPerid = new TPeriod();
      nextPerid.setPeriodYear(periodYear);
      nextPerid.setPeriodMonth(periodMonth);
      nextPerid.setStartdate(startdate.toString());
      nextPerid.setEnddate(enddate.toString());
      nextPerid.setSettleflag(0);
      periodDao.save(nextPerid); //保存下个会计期间
    }

    settleCtlDao.updateSettlePeriod(periodYear, periodMonth);
    vouchernoCtlDao.updateVoucherno(periodMonth, 0);
    return true;
  }

  private void saveVoucher(VoucherTemp voucherTemp) {
    TVoucher voucher = new TVoucher(periodYear, periodMonth, 0, settledate, settledate, voucherTemp.getTranscnt(), Math.abs(voucherTemp.getTransamt()), voucherTemp.getSummary(), "auto", hostdate);
    voucher = voucherDao.save(voucher);
    TVoucherEntry entry1;
    TVoucherEntry entry2;
    if (voucherTemp.getTransamt() >= 0) {
      entry1 = new TVoucherEntry(voucher.getVoucherid(), 1, voucherTemp.getDrsubjno(), voucherTemp.getDraccno(), Math.abs(voucherTemp.getTransamt()), 0D, voucherTemp.getSummary(), voucherTemp.getCrsubjno(), voucherTemp.getCraccno());
      entry2 = new TVoucherEntry(voucher.getVoucherid(), 2, voucherTemp.getCrsubjno(), voucherTemp.getCraccno(), 0D, Math.abs(voucherTemp.getTransamt()), voucherTemp.getSummary(), voucherTemp.getDrsubjno(), voucherTemp.getDraccno());
    } else {
      entry1 = new TVoucherEntry(voucher.getVoucherid(), 1, voucherTemp.getCrsubjno(), voucherTemp.getCraccno(), 0D, Math.abs(voucherTemp.getTransamt()), voucherTemp.getSummary(), voucherTemp.getDrsubjno(), voucherTemp.getDraccno());
      entry2 = new TVoucherEntry(voucher.getVoucherid(), 2, voucherTemp.getDrsubjno(), voucherTemp.getDraccno(), Math.abs(voucherTemp.getTransamt()), 0D, voucherTemp.getSummary(), voucherTemp.getCrsubjno(), voucherTemp.getCraccno());
    }
    voucherEntryDao.save(entry1);
    voucherEntryDao.save(entry2);
  }

  @Override
  public boolean doDayendSettle() throws Exception {
    TSettlectl tSettlectl = settleCtlDao.findByBooksetnoWithLock(1);
    if (null == tSettlectl || null == tSettlectl.getBooksetno()) {
      throw new Exception("初始化错误，T_SETTLECTL 无初始化数据");
    }
    tSettlectl.setStatus(1); //结算标记
    settleCtlDao.save(tSettlectl);

    hostdate = Integer.valueOf(systemUtilService.getSysdatetime().getHostdate());
    periodYear = tSettlectl.getPeriodYear();
    periodMonth = tSettlectl.getPeriodMonth();
    settledate = tSettlectl.getSettledate();
    lastsettday = Integer.valueOf(DateUtil.getNewDay(tSettlectl.getSettledate().toString(), -1));

    if (settledate >= hostdate) {
      throw new Exception("日终结算已完成");
    }

    TPeriod period = periodDao.getPeriod(periodYear, periodMonth);
    if (null == period) throw new Exception("year=[" + periodYear + "],month=[" + periodMonth + "] t_period not find ");
    if (settledate > Integer.valueOf(period.getEnddate())) {
      //月切
      if (!doSwitchPeriod()) {
        throw new Exception("月切失败");
      }
    }

    //新增商户插入商户余额表
    List<AccnoBean> newShopaccList = shopaccDao.getNewShopacc();
    if (!StringUtil.isEmpty(newShopaccList)) {
      for (AccnoBean bean : newShopaccList) {
        TShopaccbal shopaccbal = new TShopaccbal(bean.getAccno());
        shopaccbalDao.save(shopaccbal);
      }
    }
    if (shopaccDao.checkSettleShopacc().getExisted() > 0) {
      throw new Exception("初始化数据错误:商户余额表数据没有包含所有有效的商户账户余额");
    }

    //新增科目插入科目余额表（末级科目）
    List<AccnoBean> newEndsubjectList = subjectDao.getNewSubject();
    if (!StringUtil.isEmpty(newEndsubjectList)) {
      for (AccnoBean bean : newEndsubjectList) {
        TSubjectbal subjectbal = new TSubjectbal(bean.getAccno());
        subjectbalDao.save(subjectbal);
      }
    }
    if (subjectDao.checkSettleSubject().getExisted() > 0) {
      throw new Exception("初始化数据错误:科目余额表数据没有包含所有的科目余额");
    }

    //删除未入账凭证
    if (voucherDao.checkExistUnpostVouhcer().getExisted() > 0) {
      voucherEntryDao.deleteUnpostVoucherentry();
      voucherDao.deleteUnpostVoucher();
    }

    //充值凭证
//    List<VoucherTemp> dpsList = dpsdtlDao.getVoucherData(String.valueOf(settledate));
//    if (!StringUtil.isEmpty(dpsList)) {
//      for (VoucherTemp dps : dpsList) {
//        saveVoucher(dps);
//      }
//    }
//
//    List<VoucherTemp> dpsfeeList = dpsdtlDao.getFeeVoucherData(String.valueOf(settledate));
//    if (!StringUtil.isEmpty(dpsfeeList)) {
//      for (VoucherTemp dpsfee : dpsfeeList) {
//        saveVoucher(dpsfee);
//      }
//    }
//
//    //消费凭证
//    List<VoucherTemp> payList = transdtlDao.getFeeVoucherData(String.valueOf(settledate));
//    if (!StringUtil.isEmpty(payList)) {
//      for (VoucherTemp pay : payList) {
//        saveVoucher(pay);
//      }
//    }
//
//    List<VoucherTemp> payfeeList = transdtlDao.getFeeVoucherData(String.valueOf(settledate));
//    if (!StringUtil.isEmpty(payfeeList)) {
//      for (VoucherTemp payfee : payfeeList) {
//        saveVoucher(payfee);
//      }
//    }

    //用户交易凭证
    List<VoucherTemp> userList = debitCreditDtlDao.getVoucherData(String.valueOf(settledate));
    if (!StringUtil.isEmpty(userList)) {
      for (VoucherTemp temp : userList) {
        saveVoucher(temp);
      }
    }

    //凭证号
    TVouchernoCtl vouchernoCtl = vouchernoCtlDao.getVoucherno();
    if (null == vouchernoCtl) {
      vouchernoCtl = new TVouchernoCtl();
      vouchernoCtl.setVouchertype(1);
      vouchernoCtl.setPeriodMonth(periodMonth);
      vouchernoCtl.setVoucherno(0);
      vouchernoCtlDao.save(vouchernoCtl);
    }
    int voucherno = vouchernoCtl.getVoucherno();
    List<TVoucher> voucherList = voucherDao.getSettleVouchers();
    if (!StringUtil.isEmpty(voucherList)) {
      for (TVoucher voucher : voucherList) {
        voucherno++;
        voucher.setVoucherno(voucherno);
        voucher.setPostflag(1);
        voucherDao.save(voucher);
      }
      vouchernoCtl.setVoucherno(voucherno);
      vouchernoCtlDao.save(vouchernoCtl);
    }

    Map<String, Double> v_merchbaldict = new HashMap<String, Double>(0);
    //根据商户昨天日结表生成当天日结表（交易前余额）， 新增商户添加记录（交易前余额为商户余额）
    List<TShopaccday> lastShopaccdays = shopaccdayDao.getShopaccdayByAccdate(String.valueOf(lastsettday));
    if (!StringUtil.isEmpty(lastShopaccdays)) {
      for (TShopaccday lastday : lastShopaccdays) {
        TShopaccday today = new TShopaccday(String.valueOf(settledate), lastday.getShopaccno(), periodYear, periodMonth, lastday.getBalance(), 0D, 0D, 0D);
        shopaccdayDao.save(today);
        v_merchbaldict.put(lastday.getShopaccno(), lastday.getBalance());
      }
    }
    List<TShopaccbal> newShopbals = shopaccbalDao.getUnsettleShopacc(String.valueOf(lastsettday));
    if (!StringUtil.isEmpty(newShopbals)) {
      for (TShopaccbal newShopbal : newShopbals) {
        TShopaccday today = new TShopaccday(String.valueOf(settledate), newShopbal.getShopaccno(), periodYear, periodMonth, newShopbal.getBeginbal(), 0D, 0D, 0D);
        shopaccdayDao.save(today);
        v_merchbaldict.put(newShopbal.getShopaccno(), newShopbal.getBeginbal());
      }
    }
    List<MerchBean> merchBeanList = voucherDao.getShopVoucherByAccdate(settledate);
    if (!StringUtil.isEmpty(merchBeanList)) {
      for (MerchBean merch : merchBeanList) {
        TShopaccday merchday = shopaccdayDao.getTShopaccdayById(String.valueOf(settledate), merch.getShopaccno());
        if (null == merchday) {
          throw new Exception("商户余额表无此商户账号[" + merch.getShopaccno() + "]");
        }
        merchday.setDramt(merch.getDramt() == null ? 0D : merch.getDramt());
        merchday.setCramt(merch.getCramt() == null ? 0D : merch.getCramt());
        shopaccdayDao.save(merchday);
      }
    }
    shopaccdayDao.updateShopaccdayBalance(String.valueOf(settledate), systemUtilService.getSysdatetime().getHostdatetime()); //批量更新余额,商户日结表生成

    //根据科目昨天日结表生成当天日结表（交易前借贷方余额），新增末级科目插入记录（交易前余额为科目贷方余额）
    List<TSubjectday> lastSubjectDays = subjectdayDao.getAllByAccdate(String.valueOf(lastsettday));
    if (!StringUtil.isEmpty(lastSubjectDays)) {
      for (TSubjectday lastday : lastSubjectDays) {
        TSubjectday today = new TSubjectday(String.valueOf(settledate), lastday.getSubjno(), periodYear, periodMonth, lastday.getDrbal(), lastday.getCrbal(), 0D, 0D, 0D, 0D);
        subjectdayDao.save(today);
      }
    }
    List<TSubjectbal> newSubjectBals = subjectbalDao.getUnsettleSubjectbal(String.valueOf(lastsettday));
    if (!StringUtil.isEmpty(newSubjectBals)) {
      for (TSubjectbal newSubject : newSubjectBals) {
        TSubjectday today = new TSubjectday(String.valueOf(settledate), newSubject.getSubjno(), periodYear, periodMonth, newSubject.getBegindrbal(), newSubject.getBegincrbal(), 0D, 0D, 0D, 0D);
        subjectdayDao.save(today);
      }
    }
    List<AccnoBean> newFSubjnos = subjectDao.getNewSubjnos(String.valueOf(settledate)); //新增非末级科目
    if (!StringUtil.isEmpty(newFSubjnos)) {
      for (AccnoBean bean : newFSubjnos) {
        double beginDrbal = 0;
        double beginCrbal = 0;
        MerchBean balInfo = subjectbalDao.getSubjectInfo(bean.getAccno()); //统计下级所有科目的交易前余额
        if (null != balInfo) {
          beginDrbal = (balInfo.getDramt() == null ? 0 : balInfo.getDramt().doubleValue());
          beginCrbal = (balInfo.getCramt() == null ? 0 : balInfo.getCramt().doubleValue());
        }
        TSubjectday today = new TSubjectday(String.valueOf(settledate), bean.getAccno(), periodYear, periodMonth, beginDrbal, beginCrbal, 0D, 0D, 0D, 0D);
        subjectdayDao.save(today);
      }
    }

    //初始化末级科目期初余额(包含商户科目)
    Map<String, Double> v_subjbaldict = new HashMap<String, Double>(0);
    Map<String, Integer> v_subjbalflagdict = new HashMap<String, Integer>(0);
    List<MerchBean> subjectList = subjectdayDao.getEndSubjectbalInfos(String.valueOf(settledate));
    if (!StringUtil.isEmpty(subjectList)) {
      for (MerchBean bean : subjectList) {
        v_subjbaldict.put(bean.getShopaccno(), MoneyUtil.formatYuan(bean.getDramt() + bean.getCramt()));
      }
    }

    List<SubjectInfoBean> subjInfoList = subjectbalDao.getSubjectbalAndFlag();
    for (SubjectInfoBean subj : subjInfoList) {
      TSubjectday tSubjectday = subjectdayDao.getSubjectDayById(String.valueOf(settledate), subj.getSubjno());
      if (null == tSubjectday) {
        throw new Exception("科目日结表无此科目记录[" + subj.getSubjno() + "]");
      }

      v_subjbalflagdict.put(subj.getSubjno(), subj.getBalflag());
      MerchBean suminfo = voucherDao.getSettleSuminfo(settledate, subj.getSubjno());
      double sumDramt = ((null == suminfo || null == suminfo.getDramt()) ? 0 : suminfo.getDramt().doubleValue());
      double sumCramt = ((null == suminfo || null == suminfo.getCramt()) ? 0 : suminfo.getCramt().doubleValue());
      tSubjectday.setDramt(sumDramt);
      tSubjectday.setCramt(sumCramt);
      tSubjectday.setUpdtime(systemUtilService.getSysdatetime().getHostdatetime());
      if (subj.getBalflag() == 1) {
        tSubjectday.setDrbal(MoneyUtil.formatYuan(tSubjectday.getBegindrbal() + sumDramt - sumCramt));
      } else {
        tSubjectday.setCrbal(MoneyUtil.formatYuan(tSubjectday.getBegincrbal() - sumDramt + sumCramt));
      }
      subjectdayDao.save(tSubjectday);
    }
    //根据二级更新一级科目日结
    List<TSubjectday> parentSubject = subjectdayDao.getParentSubjectday(String.valueOf(settledate));
    for (TSubjectday fsub : parentSubject) {
      FSubjectInfoBean sumInfo = subjectdayDao.getParentSumInfo(String.valueOf(settledate), fsub.getSubjno());
      fsub.setBegindrbal((null == sumInfo || null == sumInfo.getBegindrbal()) ? 0D : sumInfo.getBegindrbal());
      fsub.setBegincrbal((null == sumInfo || null == sumInfo.getBegincrbal()) ? 0D : sumInfo.getBegincrbal());
      fsub.setDramt((null == sumInfo || null == sumInfo.getDramt()) ? 0D : sumInfo.getDramt());
      fsub.setCramt((null == sumInfo || null == sumInfo.getCramt()) ? 0D : sumInfo.getCramt());
      fsub.setDrbal((null == sumInfo || null == sumInfo.getDrbal()) ? 0D : sumInfo.getDrbal());
      fsub.setCrbal((null == sumInfo || null == sumInfo.getCrbal()) ? 0D : sumInfo.getCrbal());
      fsub.setUpdtime(systemUtilService.getSysdatetime().getHostdatetime());
      subjectdayDao.save(fsub);
    }

    //批量更新凭证明细中商户或科目账户的余额
    List<TVoucherEntry> entryList = voucherEntryDao.getVoucherEntryByVoucherdate(settledate);
    if (!StringUtil.isEmpty(entryList)) {
      for (TVoucherEntry vce : entryList) {
        if (TradeDict.SUBJNO_SHOP.equals(vce.getSubjno())) {
          //商户科目
          Double befbal = v_merchbaldict.get(vce.getAccno());
          if (null == befbal) throw new Exception("商户表商户账号[" + vce.getAccno() + "]不存在");
          v_merchbaldict.put(vce.getAccno(), MoneyUtil.formatYuan(befbal + vce.getCramt() - vce.getDramt())); //更新余额
          vce.setBalflag(2);
          vce.setBalance(v_merchbaldict.get(vce.getAccno()));
          if (!StringUtil.isEmpty(vce.getOppaccno())) {
            vce.setOppname(shopaccDao.getShopname(vce.getOppaccno()).getAccname());
          } else {
            vce.setOppname(subjectDao.getSubjectname(vce.getOppsubjno()).getAccname());
          }
          voucherEntryDao.save(vce);
          Double befMerchbal = v_subjbaldict.get(vce.getSubjno());
          if (null == befMerchbal) throw new Exception("商户科目号[" + vce.getSubjno() + "]不存在");
          v_subjbaldict.put(vce.getSubjno(), MoneyUtil.formatYuan(befMerchbal - vce.getDramt() + vce.getCramt())); //商户科目总余额更新
        } else {
          //其他科目
          Integer balflag = v_subjbalflagdict.get(vce.getSubjno());
          Double befbal = v_subjbaldict.get(vce.getSubjno());
          if (null == balflag || null == befbal) throw new Exception("科目表科目号[" + vce.getSubjno() + "]不存在");
          if (balflag == 1) {
            v_subjbaldict.put(vce.getSubjno(), MoneyUtil.formatYuan(befbal + vce.getDramt() - vce.getCramt()));
          } else {
            v_subjbaldict.put(vce.getSubjno(), MoneyUtil.formatYuan(befbal - vce.getDramt() + vce.getCramt()));
          }
          vce.setBalflag(balflag);
          vce.setBalance(v_subjbaldict.get(vce.getSubjno()));
          if (!StringUtil.isEmpty(vce.getOppaccno())) {
            vce.setOppname(shopaccDao.getShopname(vce.getOppaccno()).getAccname());
          } else {
            vce.setOppname(subjectDao.getSubjectname(vce.getOppsubjno()).getAccname());
          }
          voucherEntryDao.save(vce);
        }
      }
    }

    //开始校验
    //核算商户日结表商户余额 和凭证明细余额是否一致
    for (String shopaccno : v_merchbaldict.keySet()) {
      TShopaccday tShopaccday = shopaccdayDao.getTShopaccdayById(String.valueOf(settledate), shopaccno);
      if (!MoneyUtil.moneyEqual(v_merchbaldict.get(shopaccno), tShopaccday.getBalance())) {
        throw new Exception("结算后检查失败:商户余额不等,商户余额[" + tShopaccday.getBalance() + "]凭证商户余额[" + v_merchbaldict.get(shopaccno) + "]");
      }
      TShopaccbal tShopaccbal = shopaccbalDao.getOne(shopaccno);
      tShopaccbal.setBalance(tShopaccday.getBalance());
      tShopaccbal.setUpdtime(systemUtilService.getSysdatetime().getHostdatetime());
      shopaccbalDao.save(tShopaccbal);
    }
    //核算科目日结表科目余额和凭证明细余额是否一致
    for (String subjno : v_subjbaldict.keySet()) {
      TSubjectday tSubjectday = subjectdayDao.getSubjectDayById(String.valueOf(settledate), subjno);
      if (!MoneyUtil.moneyEqual(v_subjbaldict.get(subjno), tSubjectday.getDrbal() + tSubjectday.getCrbal())) {
        throw new Exception("结算后检查失败:科目日结表期末余额不等,科目号[" + subjno + "],科目余额[" + (tSubjectday.getDrbal() + tSubjectday.getCrbal()) + "],凭证科目余额[" + v_subjbaldict.get(subjno) + "]");
      }
      TSubjectbal tSubjectbal = subjectbalDao.getOne(subjno);
      tSubjectbal.setBegindrbal(tSubjectday.getBegindrbal());
      tSubjectbal.setBegincrbal(tSubjectday.getBegincrbal());
      tSubjectbal.setDramt(tSubjectday.getDramt());
      tSubjectbal.setCramt(tSubjectday.getCramt());
      tSubjectbal.setDrbal(tSubjectday.getDrbal());
      tSubjectbal.setCrbal(tSubjectday.getCrbal());
      tSubjectbal.setUpdtime(systemUtilService.getSysdatetime().getHostdatetime());
      subjectbalDao.save(tSubjectbal);
    }
    //核对商户日结表余额表和科目日结表商户余额是否一致
    TSubjectday shopSubjectday = subjectdayDao.getSubjectDayById(String.valueOf(settledate), TradeDict.SUBJNO_SHOP);
    AmountBean merchbal = shopaccdayDao.getSumBalance(String.valueOf(settledate));
    double shopSubbal = (shopSubjectday == null ? 0 : shopSubjectday.getCrbal());
    double shopMerchbal = ((null == merchbal || null == merchbal.getAmount()) ? 0 : merchbal.getAmount());
    if (!MoneyUtil.moneyEqual(shopSubbal, shopMerchbal)) {
      throw new Exception("结算后检查失败:商户日结表和科目日结表期末余额不平衡,商户[" + shopMerchbal + "] 科目[" + shopSubbal + "]");
    }
    //核算一级科目余额是否平衡
    FSubjectInfoBean allParentSubjbal = subjectdayDao.getAllParentSubjectSumInfo(String.valueOf(settledate));
    if (!MoneyUtil.moneyEqual(allParentSubjbal.getBegindrbal(), allParentSubjbal.getBegincrbal())) {
      throw new Exception("结算后检查失败:一级科目余额表期初余额不平衡,借方[" + allParentSubjbal.getBegindrbal() + "],贷方[" + allParentSubjbal.getBegincrbal() + "]");
    }
    if (!MoneyUtil.moneyEqual(allParentSubjbal.getDramt(), allParentSubjbal.getCramt())) {
      throw new Exception("结算后检查失败:一级科目余额表发生额不平衡,借方[" + allParentSubjbal.getDramt() + "],贷方[" + allParentSubjbal.getCramt() + "]");
    }
    if (!MoneyUtil.moneyEqual(allParentSubjbal.getDrbal(), allParentSubjbal.getCrbal())) {
      throw new Exception("结算后检查失败:一级科目余额表期末额不平衡,借方[" + allParentSubjbal.getDrbal() + "]贷方[" + allParentSubjbal.getCrbal() + "]");
    }
    //校验科目余额表的balflag=1的总期末余额和balflag=2的总期末余额是否一致
    AmountBean balflag_1_sumbal = subjectbalDao.getSumEndsubjectBalByEndflag(1);
    AmountBean balflag_2_sumbal = subjectbalDao.getSumEndsubjectBalByEndflag(2);
    if (null == balflag_1_sumbal || null == balflag_1_sumbal) throw new Exception("结算后检查失败:科目余额表无数据");
    if (!MoneyUtil.moneyEqual(balflag_1_sumbal.getAmount(), balflag_2_sumbal.getAmount())) {
      throw new Exception("结算后检查失败:科目余额表期末余额不平衡,借方[" + balflag_1_sumbal.getAmount() + "],贷方[" + balflag_2_sumbal.getAmount() + "]");
    }
    //TODO: 校验 账户余额汇总值和科目日结表值是否一致

    //日切
    tSettlectl.setStatus(0); //清标记
    tSettlectl.setSettledate(Integer.valueOf(DateUtil.getNewDay(String.valueOf(settledate), 1)));
    tSettlectl.setUpdtime(systemUtilService.getSysdatetime().getHostdatetime());
    return true;
  }

  @Override
  public boolean doVoucherSettle(String voucherid) throws Exception {
    if (StringUtil.isEmpty(voucherid)) throw new Exception("参数为空");

    TSettlectl settlectl = settleCtlDao.findByBooksetno(1);
    if (null == settlectl || null == settlectl.getBooksetno()) {
      throw new Exception("系统初始化参数错误");
    }

//    int hostDate = Integer.valueOf(systemUtilService.getSysdatetime().getHostdatetime());
//    int prdyear = settlectl.getPeriodYear();
//    int prdmonth = settlectl.getPeriodMonth();
    int settday = settlectl.getSettledate();

    List<AccnoBean> newShopList = shopaccDao.getNewAddShopacc(String.valueOf(settday));
    if (!StringUtil.isEmpty(newShopList)) {
      for (AccnoBean accno : newShopList) {
        TShopaccbal shopBal = new TShopaccbal(accno.getAccno());
        shopaccbalDao.save(shopBal);
      }
    }
    if (shopaccDao.checkSettleShopacc().getExisted() > 0) {
      throw new Exception("初始化数据错误:商户余额表数据没有包含所有有效的商户账户余额");
    }

    //新增科目插入科目余额表（末级科目）
    List<AccnoBean> newEndsubjectList = subjectDao.getNewSubject();
    if (!StringUtil.isEmpty(newEndsubjectList)) {
      for (AccnoBean bean : newEndsubjectList) {
        TSubjectbal subjectbal = new TSubjectbal(bean.getAccno());
        subjectbalDao.save(subjectbal);
      }
    }
    if (subjectDao.checkSettleSubject().getExisted() > 0) {
      throw new Exception("初始化数据错误:科目余额表数据没有包含所有的科目余额");
    }

    TVoucher voucher = voucherDao.findByVoucheridWithLock(voucherid);
    List<TVoucherEntry> entryList = voucherEntryDao.getVoucherEntryByVoucherid(voucherid);
    if (null == voucher) {
      throw new Exception("凭证查询无记录");
    } else if ("auto".equals(voucher.getSourcetype())) {
      throw new Exception("该凭证不是手工录入凭证");
    } else if (voucher.getCheckflag() != 1) {
      throw new Exception("该凭证未审核");
    } else if (StringUtil.isEmpty(voucher.getSummary())) {
      throw new Exception("摘要不能为空");
    } else if (voucher.getPostflag() == 1) {
      throw new Exception("凭证已入账");
    }

    if (StringUtil.isEmpty(entryList)) {
      throw new Exception("凭证无借贷明细！");
    }

    //凭证号
    TVouchernoCtl vouchernoCtl = vouchernoCtlDao.getVoucherno();
    if (null == vouchernoCtl) {
      vouchernoCtl = new TVouchernoCtl(1, periodMonth, 0);
      vouchernoCtlDao.save(vouchernoCtl);
    }
    int voucherno = vouchernoCtl.getVoucherno() + 1;
    vouchernoCtl.setVoucherno(voucherno);
    vouchernoCtlDao.save(vouchernoCtl);

    voucher.setVoucherno(voucherno);
    voucher.setPostflag(1);
    voucherDao.save(voucher); //修改凭证表凭证号、入账标志

    //明细
    for (TVoucherEntry entry : entryList) {
      if (TradeDict.SUBJNO_SHOP.equals(entry.getSubjno())) {
        TShopaccbal tShopaccbal = shopaccbalDao.getTShopaccbalByIdWithLock(entry.getAccno());
        if (null == tShopaccbal) {
          throw new Exception("商户表商户账号[" + entry.getAccno() + "]不存在");
        }
        tShopaccbal.setBalance(tShopaccbal.getBeginbal() + entry.getCramt() - entry.getDramt());
        shopaccbalDao.save(tShopaccbal);
        entry.setBalflag(2);
        entry.setBalance(tShopaccbal.getBalance());
      } else {
        TSubjectbal tSubjectbal = subjectbalDao.getTSubjectbalBySubjnoWithLock(entry.getSubjno());
        TSubject subject = subjectDao.getOne(entry.getSubjno());
        if (null == tSubjectbal || null == subject) {
          throw new Exception("科目表科目号[" + entry.getSubjno() + "]不存在");
        } else if (subject.getEndflag() != 1) {
          throw new Exception("科目[" + entry.getSubjno() + "]非末级科目");
        }
        entry.setBalflag(subject.getBalflag());
        if (subject.getBalflag() == 1) {
          tSubjectbal.setDrbal(tSubjectbal.getDrbal() + entry.getDramt() - entry.getCramt());
          entry.setBalance(tSubjectbal.getDrbal());
        } else {
          tSubjectbal.setCrbal(tSubjectbal.getCrbal() - entry.getDramt() + entry.getCramt());
          entry.setBalance(tSubjectbal.getCrbal());
        }
        subjectbalDao.save(tSubjectbal);
      }

      if (!StringUtil.isEmpty(entry.getOppaccno())) {
        entry.setOppname(shopaccDao.getShopname(entry.getOppaccno()).getAccname());
      } else {
        entry.setOppname(subjectDao.getSubjectname(entry.getOppsubjno()).getAccname());
      }
      voucherEntryDao.save(entry);
    }

    return true;
  }
}
