package com.supwisdom.dlpay.util;


import java.text.DecimalFormat;

public class MoneyUtil {

  public static int YuanToFen(double yuan) {
    return (int) (Math.round(yuan * 100));
  }

  public static boolean moneyCompare(double x1, double x2) {
    return YuanToFen(x1) == YuanToFen(x2);
  }

  public static double formatYuan(double yuan) {
    DecimalFormat df = new DecimalFormat("##0.00");
    double money = ((double) YuanToFen(yuan)) / 100;
    return Double.valueOf(df.format(money));
  }

  public static double FenToYuan(int fen) {
    return formatYuan(fen / 100.0);
  }

  public static String format(double num, String format) {
    DecimalFormat df = new DecimalFormat(format);
    return df.format(num);
  }
}
