package com.supwisdom.dlpay.consume.service.impl

import com.supwisdom.dlpay.consume.PersonTransBuilder
import com.supwisdom.dlpay.consume.dao.AccountDao
import com.supwisdom.dlpay.consume.dao.DebitCreditDtlDao
import com.supwisdom.dlpay.consume.dao.UserdtlDao
import com.supwisdom.dlpay.consume.domain.TAccount
import com.supwisdom.dlpay.consume.domain.TDebitCreditDtl
import com.supwisdom.dlpay.consume.domain.TUserdtl
import com.supwisdom.dlpay.consume.service.AccountUtilServcie
import com.supwisdom.dlpay.consume.service.PersonBalancePayService
import com.supwisdom.dlpay.exception.TransactionProcessException
import com.supwisdom.dlpay.framework.dao.ShopaccDao
import com.supwisdom.dlpay.framework.dao.SubjectDao
import com.supwisdom.dlpay.framework.domain.TShopacc
import com.supwisdom.dlpay.framework.domain.TSubject
import com.supwisdom.dlpay.framework.domain.TTranstype
import com.supwisdom.dlpay.framework.service.SystemUtilService
import com.supwisdom.dlpay.framework.util.StringUtil
import com.supwisdom.dlpay.framework.util.TradeDict
import com.supwisdom.dlpay.framework.util.TradeErrorCode
import com.supwisdom.dlpay.framework.util.Tradetype
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service
import javax.persistence.EntityManager
import javax.persistence.PersistenceContext


@Service
class AccountUtilServcieImpl : AccountUtilServcie {
    @Autowired
    lateinit var accountDao: AccountDao

    @Autowired
    lateinit var shopaccDao: ShopaccDao

    @Autowired
    lateinit var subjectDao: SubjectDao


    override fun readAccountForUpdate(userid: String, nowait: Boolean): TAccount {
        //TODO("not implemented") //To change body of created functions use File | Settings | File Templates.
        return accountDao.findByUserid(userid);
    }

    override fun readAccount(userid: String): TAccount {
        accountDao.findByUserid(userid).let {
            if (null != it) {
                return it
            }
            throw TransactionProcessException(TradeErrorCode.ACCOUNT_NOT_EXISTS, "账户<$userid>不存在")
        }
    }

    override fun readShopAccForUpdate(shopId: Int, nowait: Boolean): TShopacc {
        // TODO("not implemented") //To change body of created functions use File | Settings | File Templates.
        return shopaccDao.findByShopid(shopId)
    }

    override fun readShopAcc(shopId: Int): TShopacc {
        shopaccDao.findByShopid(shopId).let {
            if (null != it) {
                return it
            }
            throw TransactionProcessException(TradeErrorCode.SHOP_NOT_EXISTS, "商户<$shopId>不存在")
        }
    }

    override fun readSubjectForUpdate(subjno: String, nowait: Boolean): TSubject {
        //TODO("not implemented") //To change body of created functions use File | Settings | File Templates.
        return subjectDao.getOne(subjno);
    }

    override fun readSubject(subjno: String): TSubject {
        subjectDao.getOne(subjno).let {
            if (null != it) {
                return it
            }
            throw TransactionProcessException(TradeErrorCode.SUBJECT_NOT_EXISTS, "科目<$subjno>不存在")
        }
    }

    override fun readTranstype(transtype: Int): TTranstype {
        //TODO("not implemented") //To change body of created functions use File | Settings | File Templates.
        return TTranstype();
    }
}

@Service
class PersonBalancePayServiceImpl : PersonBalancePayService {
    @Autowired
    lateinit var userdtlDao: UserdtlDao
    @Autowired
    lateinit var debitCreditDtlDao: DebitCreditDtlDao

    @Autowired
    lateinit var accountDao: AccountDao

    @PersistenceContext
    lateinit var em: EntityManager

    @Autowired
    lateinit var systemUtilService: SystemUtilService


    private fun getlockAccount(accno: String): TAccount {
        //TODO 等待锁
        return accountDao.getOne(accno)
    }

    private fun getlockAccountNowait(accno: String): TAccount {
        //TODO 等待锁
        return accountDao.getOne(accno)
    }

    private fun getLockUserdtlNowait(refno: String): TUserdtl {
        //TODO 加锁，非等待
        userdtlDao.findByRefno(refno).let {
            if (null != it) {
                return it
            }
            throw TransactionProcessException(TradeErrorCode.TRANSACTION_NOT_EXISTS, "交易参考号<$refno>不存在")
        }
    }

    private fun getLockUserdtl(refno: String): TUserdtl {
        //TODO 加锁，等待
        return userdtlDao.findByRefno(refno)
    }

    private fun checkOuttradenoExist(outtradeno: String): Boolean {
//        TODO("判断 outtradeno 重复发起")
        return false
    }

    private fun doDealAccount(accno: String, amount: Double, overdraft: Boolean): TAccount {
        var account = getlockAccount(accno)
        if (account.tacCheck())
            throw TransactionProcessException(TradeErrorCode.ACCOUNT_TAC_ERROR, "账户<$accno>tac校验异常")

        account.addAmount(amount) //入账
        if (account.checkOverflow())
            throw TransactionProcessException(TradeErrorCode.OVERFLOW_BALANCE_ERROR, "账户<$accno>已超最大余额限制")

        if (!overdraft && account.checkOverdraft())
            throw TransactionProcessException(TradeErrorCode.SHORT_BALANCE_ERROR, "账户<$accno>余额不足")

        return accountDao.save(account) //入库更新
    }

    private fun doDealShopacc(shopaccno: String, amount: Double) {
        TODO("商户更新余额逻辑")
    }

    override fun process(builder: PersonTransBuilder): TUserdtl {
        return finish(init(builder), TradeDict.DTL_STATUS_SUCCESS, null)
    }

    override fun init(builder: PersonTransBuilder): TUserdtl {
        var userdtl = TUserdtl()
        userdtl.refno = systemUtilService.refno
        userdtl.accdate = systemUtilService.accdate
        userdtl.userid = builder.person?.userid
        if (StringUtil.isEmpty(builder.transDate)) {
            userdtl.transdate = systemUtilService.sysdatetime.hostdate
        } else {
            userdtl.transdate = builder.transDate
        }
        if (StringUtil.isEmpty(builder.transTime)) {
            userdtl.transdate = systemUtilService.sysdatetime.hosttime
        } else {
            userdtl.transtime = builder.transTime
        }
        userdtl.paytype = builder.paytype
        userdtl.payinfo = builder.payinfo
        userdtl.transcode = builder.transcode
        if (StringUtil.isEmpty(builder.description)) {
            userdtl.transdesc = systemUtilService.getTranscodeName(builder.transcode, null);
        } else {
            userdtl.transdesc = builder.description
        }
        userdtl.outtradeno = builder.outtradeno
//        userdtl.operid =
        when (builder.tradetype) {
            Tradetype.RECHARGE -> userdtl.tradeflag = 1
            Tradetype.CONSUME -> userdtl.tradeflag = 2
        }
        userdtl.createtime = systemUtilService.sysdatetime.hostdatetime
        if (checkOuttradenoExist(userdtl.outtradeno)) {
            throw TransactionProcessException(TradeErrorCode.OUTTRADENO_ALREADY_EXISTS, "外部流水号重复")
        }

        userdtl.amount = builder.amount
        userdtl.status = TradeDict.DTL_STATUS_INIT
        userdtlDao.save(userdtl)

        for (detail in builder.details) {
            var dtl = TDebitCreditDtl()
            dtl.refno = userdtl.refno
            dtl.seqno = detail.rowno
            dtl.drsubjno = detail.debitSubjNo
            dtl.draccno = detail.debitAccNo
            dtl.crsubjno = detail.creditSubjNo
            dtl.craccno = detail.creditAccNo
            dtl.amount = detail.amount
            dtl.summary = detail.summary
            debitCreditDtlDao.save(dtl)
        }
        return userdtl
    }

    override fun finish(paydtl: TUserdtl, status: String, businessData: Map<String, String>?): TUserdtl {
        return finish(paydtl.refno, status, businessData)
    }

    override fun finish(refno: String, status: String, businessData: Map<String, String>?): TUserdtl {
        var userdtl = getLockUserdtl(refno)
        when (status) {
            TradeDict.DTL_STATUS_FAIL -> {
                //失败
                if (TradeDict.DTL_STATUS_SUCCESS == userdtl.status)
                    throw TransactionProcessException(TradeErrorCode.TRANSACTION_IS_FINISHED, "流水已经交易成功")
                userdtl.status = TradeDict.DTL_STATUS_FAIL
                userdtl.endtime = systemUtilService.sysdatetime.hostdatetime
                userdtl.remark = businessData?.get("errmsg")
                return userdtlDao.save(userdtl)
            }

            TradeDict.DTL_STATUS_SUCCESS -> {
                //成功
                if (TradeDict.DTL_STATUS_SUCCESS == userdtl.status)
                    return userdtl //已成功直接返回

                for (detail in debitCreditDtlDao.findByRefno(userdtl.refno)) {
                    //个人账户入账
                    if (TradeDict.SUBJNO_ACCOUNT == detail.drsubjno) {
                        doDealAccount(detail.drsubjno, -1 * detail.amount, false) //借方消费
                    }
                    if (TradeDict.SUBJNO_ACCOUNT == detail.crsubjno) {
                        doDealAccount(detail.drsubjno, detail.amount, false) //贷方充值
                    }

                    //商户入账
                    if (TradeDict.SUBJNO_SHOP == detail.drsubjno) {
                        doDealShopacc(detail.draccno, -1 * detail.amount)
                    }
                    if (TradeDict.SUBJNO_SHOP == detail.crsubjno) {
                        doDealShopacc(detail.draccno, detail.amount)
                    }
                }

                userdtl.status = TradeDict.DTL_STATUS_SUCCESS
                userdtl.accdate = systemUtilService.accdate //入账成功时更新
                userdtl.endtime = systemUtilService.sysdatetime.hostdatetime
                //TODO 存储一些业务参数
                return userdtlDao.save(userdtl)
            }

            else -> throw TransactionProcessException(TradeErrorCode.TRANSDTL_STATUS_ERROR, "未指定明确的交易结束状态")
        }
    }

    override fun wip(paydtl: TUserdtl, builder: PersonTransBuilder): TUserdtl {
        return wip(paydtl.refno, builder)
    }

    override fun wip(refno: String, builder: PersonTransBuilder): TUserdtl {
        var userdtl = getLockUserdtlNowait(refno)
        if (TradeDict.DTL_STATUS_INIT != userdtl.status)
            throw TransactionProcessException(TradeErrorCode.TRANSDTL_STATUS_NOT_INIT, "交易参考号<$refno>非初始化流水")

        userdtl.status = TradeDict.DTL_STATUS_WIP  //待支付
        return userdtlDao.save(userdtl)
    }
}