package com.supwisdom.dlpay.consume.domain;

import javax.persistence.*;

@Entity
@Table(name = "TB_USERDTL",
    indexes = {@Index(name = "userdtl_transdate_idx", columnList = "transdate"),
        @Index(name = "userdtl_accdate_idx", columnList = "accdate"),
        @Index(name = "userdtl_status_idx", columnList = "status"),
        @Index(name = "userdtl_reverse_idx", columnList = "REVERSE_FLAG")})
public class TUserdtl {
  @Id
  @Column(name = "REFNO", nullable = false, length = 32)
  private String refno; //流水号

  @Column(name = "ACCDATE", length = 8)
  private String accdate; //记账日期

  @Column(name = "USERID", length = 32)
  private String userid;  //用户ID，或账号

  @Column(name = "TRANSDATE", length = 8)
  private String transdate;

  @Column(name = "TRANSTIME", length = 6)
  private String transtime;

  @Column(name = "STATUS", length = 20)
  private String status;

  @Column(name = "BEFBAL", precision = 9, scale = 2)
  private Double befbal;

  @Column(name = "AMOUNT", precision = 9, scale = 2)
  private Double amount;

  @Column(name = "AFTBAL", precision = 9, scale = 2)
  private Double aftbal;

  @Column(name = "PAYTYPE", length = 20)
  private String paytype; //支付方式 balance,wechat,alipay

  @Column(name = "PAYINFO", length = 200)
  private String payinfo; //记录支付信息备用字段

  @Column(name = "TRANSCODE", precision = 4)
  private Integer transcode;

  @Column(name = "TRANSDESC", length = 240)
  private String transdesc; //交易描述

  @Column(name = "OUTTRADENO", length = 60)
  private String outtradeno; //第三方流水号

  @Column(name = "OPERID", precision = 9)
  private Integer operid; //操作员ID

  @Column(name = "REVERSE_FLAG", nullable = false, precision = 1)
  private String reverseFlag = "none"; //none, cancel, reversed

  @Column(name = "REVERSE_AMOUNT", precision = 9, scale = 2)
  private Double reverseAmount = 0D; //撤销金额填写

  @Column(name = "TRADEFLAG", nullable = false, precision = 1)
  private Integer tradeflag; //1-充值；2-消费

  @Column(name = "REMARK", length = 240)
  private String remark;

  @Column(name = "CREATETIME", length = 14)
  private String createtime;  //创建时间

  @Column(name = "ENDTIME", length = 14)
  private String endtime;  //支付结束时间

  public String getRefno() {
    return refno;
  }

  public void setRefno(String refno) {
    this.refno = refno;
  }

  public String getAccdate() {
    return accdate;
  }

  public void setAccdate(String accdate) {
    this.accdate = accdate;
  }

  public String getUserid() {
    return userid;
  }

  public void setUserid(String userid) {
    this.userid = userid;
  }

  public String getTransdate() {
    return transdate;
  }

  public void setTransdate(String transdate) {
    this.transdate = transdate;
  }

  public String getTranstime() {
    return transtime;
  }

  public void setTranstime(String transtime) {
    this.transtime = transtime;
  }

  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public Double getBefbal() {
    return befbal;
  }

  public void setBefbal(Double befbal) {
    this.befbal = befbal;
  }

  public Double getAmount() {
    return amount;
  }

  public void setAmount(Double amount) {
    this.amount = amount;
  }

  public Double getAftbal() {
    return aftbal;
  }

  public void setAftbal(Double aftbal) {
    this.aftbal = aftbal;
  }

  public String getPaytype() {
    return paytype;
  }

  public void setPaytype(String paytype) {
    this.paytype = paytype;
  }

  public String getPayinfo() {
    return payinfo;
  }

  public void setPayinfo(String payinfo) {
    this.payinfo = payinfo;
  }

  public Integer getTranscode() {
    return transcode;
  }

  public void setTranscode(Integer transcode) {
    this.transcode = transcode;
  }

  public String getTransdesc() {
    return transdesc;
  }

  public void setTransdesc(String transdesc) {
    this.transdesc = transdesc;
  }

  public String getOuttradeno() {
    return outtradeno;
  }

  public void setOuttradeno(String outtradeno) {
    this.outtradeno = outtradeno;
  }

  public Integer getOperid() {
    return operid;
  }

  public void setOperid(Integer operid) {
    this.operid = operid;
  }

  public String getReverseFlag() {
    return reverseFlag;
  }

  public void setReverseFlag(String reverseFlag) {
    this.reverseFlag = reverseFlag;
  }

  public Double getReverseAmount() {
    return reverseAmount;
  }

  public void setReverseAmount(Double reverseAmount) {
    this.reverseAmount = reverseAmount;
  }

  public Integer getTradeflag() {
    return tradeflag;
  }

  public void setTradeflag(Integer tradeflag) {
    this.tradeflag = tradeflag;
  }

  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  public String getCreatetime() {
    return createtime;
  }

  public void setCreatetime(String createtime) {
    this.createtime = createtime;
  }

  public String getEndtime() {
    return endtime;
  }

  public void setEndtime(String endtime) {
    this.endtime = endtime;
  }
}
