package com.supwisdom.dlpay.framework.service.impl;

import com.supwisdom.dlpay.framework.core.DatabaseConfig;
import com.supwisdom.dlpay.framework.dao.SettleCtlDao;
import com.supwisdom.dlpay.framework.dao.TaskLockDao;
import com.supwisdom.dlpay.framework.dao.TranscodeDao;
import com.supwisdom.dlpay.framework.data.SystemDateTime;
import com.supwisdom.dlpay.framework.domain.TSettlectl;
import com.supwisdom.dlpay.framework.domain.TTaskLock;
import com.supwisdom.dlpay.framework.domain.TTranscode;
import com.supwisdom.dlpay.framework.service.SystemUtilService;
import com.supwisdom.dlpay.framework.util.DateUtil;
import com.supwisdom.dlpay.framework.util.StringUtil;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.Date;

@Service
public class SystemUtilServiceImpl implements SystemUtilService {
  @Autowired
  private DatabaseConfig databaseConfig;

  @Autowired
  private TaskLockDao taskLockDao;
  @Autowired
  private SettleCtlDao settleCtlDao;
  @Autowired
  private TranscodeDao transcodeDao;

  private static final Logger logger = Logger.getLogger(SystemUtilServiceImpl.class);

  public static class SystemDateTimeImpl implements SystemDateTime {
    private Date now;
    private static final SimpleDateFormat sdft = new SimpleDateFormat("yyyyMMddHHmmss");

    public SystemDateTimeImpl(Date now) {
      this.now = now;
    }

    @Override
    public String getHostdate() {
      return sdft.format(this.now).substring(0, 8);
    }

    @Override
    public String getHosttime() {
      return sdft.format(this.now).substring(8, 14);
    }

    @Override
    public String getHostdatetime() {
      return sdft.format(this.now);
    }

    @Override
    public Date getSysdate() {
      return this.now;
    }
  }

  /**
   * 获取oracle数据库时间
   */
  private SystemDateTime getOracleDatetime() {
    return taskLockDao.getOracleDatetime();
  }

  private SystemDateTime getPGDatetime() {
    return taskLockDao.getPGDatetime();
  }

  @Override
  public SystemDateTime getSysdatetime() {
    switch (databaseConfig.getPlatform()) {
      case "postgresql":
        return getPGDatetime();
      default:
        return getOracleDatetime();
    }
  }

  @Override
  public TTaskLock updateTaskLock(TTaskLock lock) {
    return taskLockDao.save(lock);
  }

  @Override
  public TTaskLock doLockTask(String taskcode, Integer minRecover, String remark) {
    if (null == minRecover) minRecover = 10; //默认10分钟
    String hostdatetime = getSysdatetime().getHostdatetime(); //yyyyMMddHHmmss
    TTaskLock lock = taskLockDao.getTaskLockWithLock(taskcode);
    if (lock != null) {
      if (lock.getTaskstatus() == 1 && DateUtil.compareDatetime(DateUtil.getNewTime(hostdatetime, -60 * minRecover), lock.getTasktime()) < 0) {
        // 被锁，正在执行操作
        return null;
      } else {
        lock.setTaskstatus(1);
        lock.setTasktime(hostdatetime);
        taskLockDao.save(lock);
        return lock;
      }
    } else {
      lock = new TTaskLock();
      lock.setTaskcode(taskcode);
      lock.setTaskstatus(1);
      lock.setTasktime(hostdatetime);
      lock.setRemark(remark);
      taskLockDao.save(lock);
    }
    return lock;
  }

  @Override
  public String getAccdate() {
    String hostdate = getSysdatetime().getHostdate();
    TSettlectl settlectl = settleCtlDao.getOne(1);
    if (null != settlectl && null != settlectl.getSettledate()) {
      if (Integer.valueOf(hostdate) < settlectl.getSettledate().intValue()) {
        return settlectl.getSettledate().toString();
      }
    }
    return hostdate;
  }

  private String getOracleRefno() {
    return taskLockDao.getOracleRefno();
  }

  @Override
  public String getRefno() {
    switch (databaseConfig.getPlatform()) {
      case "postgresql":
        return taskLockDao.getPgRefno();
      default:
        return taskLockDao.getOracleRefno();
    }
  }

  @Override
  public String getTranscodeName(int transocde, String defaultValue) {
    TTranscode tTranscode = transcodeDao.getOne(transocde);
    if (null != tTranscode && !StringUtil.isEmpty(tTranscode.getTransname())) {
      return tTranscode.getTransname();
    }
    return defaultValue;
  }

}
