package com.supwisdom.dlpay.framework.util;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.*;

public class HmacUtil {
  /**
   * 除去数组中的空值和签名参数
   *
   * @param sArray 签名参数组
   * @return 去掉空值与签名参数后的新签名参数组
   */
  public static Map<String, String> paraFilter(Map<String, String> sArray) {

    Map<String, String> result = new HashMap<String, String>();

    if (sArray == null || sArray.size() <= 0) {
      return result;
    }

    for (String key : sArray.keySet()) {
      String value = sArray.get(key);
      if (value == null || value.equals("") || "null".equals(value) || key.equalsIgnoreCase("sign")) {
        continue;
      }
      result.put(key, value);
    }

    return result;
  }

  /**
   * 把数组所有元素排序，并按照“参数=参数值”的模式用“&”字符拼接成字符串
   *
   * @param params 需要排序并参与字符拼接的参数组
   * @return 拼接后字符串
   */
  public static String createLinkString(Map<String, String> params) {

    List<String> keys = new ArrayList<String>(params.keySet());
    Collections.sort(keys);

    String prestr = "";

    for (int i = 0; i < keys.size(); i++) {
      String key = keys.get(i);
      String value = params.get(key);

      if (i == keys.size() - 1) {//拼接时，不包括最后一个&字符
        prestr = prestr + key + "=" + value;
      } else {
        prestr = prestr + key + "=" + value + "&";
      }
    }

    return prestr;
  }

  private static String HMACSHAX(String data, String key, String alg) {
    String algorithm = "";
    if ("SHA1".equals(alg)) {
      algorithm = "HmacSHA1";
    } else if ("SHA256".equals(alg)) {
      algorithm = "HmacSHA256";
    } else if ("SHA512".equals(alg)) {
      algorithm = "HmacSHA512";
    }
    byte[] byteHMAC = null;
    try {
      Mac mac = Mac.getInstance(algorithm);
      SecretKeySpec spec = new SecretKeySpec(key.getBytes(), algorithm);
      mac.init(spec);
      byteHMAC = mac.doFinal(data.getBytes(StandardCharsets.UTF_8));
    } catch (InvalidKeyException | NoSuchAlgorithmException e) {
      e.printStackTrace();
    }

    if (byteHMAC != null) {
      try {
        String hexMac = getHexString(byteHMAC);
        return hexMac;
      } catch (Exception e) {
        e.printStackTrace();
      }
      return null;
    }
    return null;
  }

  public static String HMACSHA256(String data, String key) {
    return HMACSHAX(data, key, "SHA256");
  }

  public static String HMACSHA512(String data, String key) {
    return HMACSHAX(data, key, "SHA512");
  }

  public static String HMACSHA1(String data, String key) {
    return HMACSHAX(data, key, "SHA1");
  }

  public static String getHexString(byte[] b) throws Exception {
    String result = "";
    for (int i = 0; i < b.length; i++) {
      result += Integer.toString((b[i] & 0xff) + 0x100, 16).substring(1);
    }
    return result;
  }

  public static boolean checkHmacSign(String data, String key, String sign) {
    String asign = HMACSHA1(data, key);
    if (asign == null) {
      return false;
    }
    if (asign.equalsIgnoreCase(sign)) {
      return true;
    }

    return false;
  }

  public static void main(String[] args) {
    String refno = DateUtil.getNow();
    Map<String, String> mapValue = new HashMap<String, String>();
    mapValue.put("tradeaccount", "10000097");
    mapValue.put("tradename", "在线点餐");
    mapValue.put("tradeamount", "1");
    mapValue.put("paidamount", "1");
    mapValue.put("outtradeno", refno);
    mapValue.put("yktshopid", "2");
    mapValue.put("shopid", "68512084");
    String signstr = createLinkString(HmacUtil.paraFilter(mapValue));
    String sign = HmacUtil.HMACSHA1(signstr, "adc4ac6822fd462780f878b86cb94688");
    System.out.println("{\"tradeaccount\":\"10000097\",\"tradename\":\"在线点餐\",\"tradeamount\":\"1\"," +
        "\"paidamount\": \"1\",\"outtradeno\":\"" + refno + "\",\"yktshopid\": \"2\",\"shopid\":\"68512084\",\"sign\": \"" + sign + "\"}");
  }

}
