package com.supwisdom.dlpay.framework.util;

import org.springframework.data.domain.Page;

import java.util.ArrayList;
import java.util.List;

public class PageResult<T> {

  private int code; //状态码, 0表示成功

  private String msg;  //提示信息

  private long count; // 总数量

  private List<T> data; // 当前数据

  public PageResult() {
  }

  public PageResult(List<T> rows) {
    this.data = rows;
    this.count = rows.size();
    this.code = 0;
    this.msg = "";
  }

  public PageResult(long total, List<T> rows) {
    this.count = total;
    this.data = rows;
    this.code = 0;
    this.msg = "";
  }

  public PageResult(int code, String msg) {
    this.code = code;
    this.msg = msg;
    this.count = 0;
    this.data = new ArrayList<>(0);
  }

  public PageResult(Page<T> page){
    if(null == page) {
      this.code = 99;
      this.msg = "无数据";
      this.count = 0;
      this.data = new ArrayList<>(0);
    } else{
      this.code = 0;
      this.msg = "";
      this.count = page.getTotalElements();
      this.data = page.getContent();
    }
  }

  public int getCode() {
    return code;
  }

  public void setCode(int code) {
    this.code = code;
  }

  public String getMsg() {
    return msg;
  }

  public void setMsg(String msg) {
    this.msg = msg;
  }

  public long getCount() {
    return count;
  }

  public void setCount(long count) {
    this.count = count;
  }

  public List<T> getData() {
    return data;
  }

  public void setData(List<T> data) {
    this.data = data;
  }
}
