package com.supwisdom.dlpay.framework.util;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import java.io.*;
import java.util.*;

public class XmlUtils {
	public static <T> String getObjectToXml(T object) throws IOException {
		ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
		
		try {
			JAXBContext context = JAXBContext.newInstance(object.getClass());
			// 将对象转变为xml Object------XML
			// 指定对应的xml文件
			Marshaller marshaller = context.createMarshaller();
			marshaller.setProperty(Marshaller.JAXB_ENCODING,"gbk");//编码格式 
			marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, false);// 是否格式化生成的xml串
			marshaller.setProperty(Marshaller.JAXB_FRAGMENT, true);// 是否省略xml头信息

			// 将对象转换为对应的XML文件
			marshaller.marshal(object, byteArrayOutputStream);
		} catch (JAXBException e) {

			e.printStackTrace();
		}
		// 转化为字符串返回
		String xmlContent = new String(byteArrayOutputStream.toByteArray(),
				"gbk");
		return xmlContent;
	}

	public static <T> T getXmlToObject(String xmlContent, Class clazz) {
		try {
			JAXBContext context = JAXBContext.newInstance(clazz);
			// xml转换为对象 XML------Object
			InputStream inputStream;
			try {
				inputStream = new ByteArrayInputStream(
						xmlContent.getBytes("GBK"));
				Unmarshaller um = context.createUnmarshaller();

				return (T) um.unmarshal(inputStream);
			} catch (UnsupportedEncodingException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}catch (Exception e) {
				e.printStackTrace();
			}
		} catch (JAXBException e) {

			e.printStackTrace();
		}
		return null;
	}
	
	public static <T> T getXmlToObject(String xmlContent,String charset, Class clazz) {
		try {
			JAXBContext context = JAXBContext.newInstance(clazz);
			// xml转换为对象 XML------Object
			InputStream inputStream;
			try {
				inputStream = new ByteArrayInputStream(
						xmlContent.getBytes(charset));
				Unmarshaller um = context.createUnmarshaller();

				return (T) um.unmarshal(inputStream);
			} catch (UnsupportedEncodingException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}catch (Exception e) {
				e.printStackTrace();
			}
		} catch (JAXBException e) {

			e.printStackTrace();
		}
		return null;
	}
	public static Map<String, String> parseXml(String xml) throws Exception {
		Map<String, String> map = new HashMap<String, String>();
		Document document = DocumentHelper.parseText(xml);
		Element root = document.getRootElement();
		List<Element> elementList = root.elements();
		for (Element e : elementList)
			map.put(e.getName(), e.getText());
		return map;
	}
	/**
	 * 除去数组中的空值和签名参数
	 *
	 * @param sArray 签名参数组
	 * @return 去掉空值与签名参数后的新签名参数组
	 */
	public static Map<String, String> paraFilter(Map<String, String> sArray) {
		Map<String, String> result = new HashMap<String, String>();
		if (sArray == null || sArray.size() <= 0) {
			return result;
		}
		for (String key : sArray.keySet()) {
			String value = sArray.get(key);
			if (value == null || "".equals(value) || "sign".equalsIgnoreCase(key)
					|| "sign_type".equalsIgnoreCase(key)) {
				continue;
			}
			result.put(key, value);
		}

		return result;
	}

	/**
	 * 把数组所有元素排序，并按照“参数=参数值”的模式用“&”字符拼接成字符串
	 *
	 * @param params 需要排序并参与字符拼接的参数组
	 * @return 拼接后字符串
	 */
	public static String createLinkString(Map<String, String> params) {

		List<String> keys = new ArrayList<String>(params.keySet());
		Collections.sort(keys);

		String prestr = "";

		for (int i = 0; i < keys.size(); i++) {
			String key = keys.get(i);
			String value = params.get(key);

			if (i == keys.size() - 1) {//拼接时，不包括最后一个&字符
				prestr = prestr + key + "=" + value;
			} else {
				prestr = prestr + key + "=" + value + "&";
			}
		}

		return prestr;
	}
}
