package com.supwisdom.dlpay.system.controller;

import com.supwisdom.dlpay.consume.bean.JsonResult;
import com.supwisdom.dlpay.framework.domain.TOperator;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.framework.util.WebConstant;
import com.supwisdom.dlpay.system.bean.OperatorSearchBean;
import com.supwisdom.dlpay.system.service.OperatorService;
import com.supwisdom.dlpay.system.service.RoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;


@Controller
@RequestMapping("/operator")
public class OperatorController {
  @Autowired
  private OperatorService operatorService;
  @Autowired
  private RoleService roleService;

  @GetMapping("/index")
  public String indexView(Model model) {
    return "system/operator/index";
  }

  @GetMapping("/list")
  @ResponseBody
  public PageResult<TOperator> getDataList(@RequestParam("page") Integer pageNo,
                                           @RequestParam("limit") Integer pageSize,
                                           @RequestParam(value = "searchkey", required = false) String searchKey,
                                           @RequestParam(value = "searchvalue", required = false) String searchValue,
                                           Model model) {
    try {
      if (null == pageNo || pageNo < 1) pageNo = WebConstant.PAGENO_DEFAULT;
      if (null == pageSize || pageSize < 1) pageSize = WebConstant.PAGESIZE_DEFAULT;
      OperatorSearchBean searchBean = new OperatorSearchBean();
      if (!StringUtil.isEmpty(searchValue)) {
        if ("opercode".equals(searchKey)) {
          searchBean.setOpercode(searchValue.trim());
        } else if ("opername".equals(searchKey)) {
          searchBean.setOpername(searchValue.trim());
        } else if ("mobile".equals(searchValue.trim())) {
          searchBean.setMobile(searchValue.trim());
        }
      }
      return operatorService.getOperatorsByPage(pageNo, pageSize, searchBean);
    } catch (Exception e) {
      e.printStackTrace();
      return new PageResult<>(99, "系统查询错误");
    }
  }

  @GetMapping("/load4add")
  public String load4addOperator(Model model) {
    model.addAttribute("roles", roleService.findAllRoles());
    return "system/operator/operator";
  }

  @GetMapping("/checkopercode")
  @ResponseBody
  public JsonResult checkOpercode(@RequestParam("opercode") String opercode,
                                  @RequestParam(value = "operid", required = false) String operid) {
    if (operatorService.checkOpercodeExists(opercode, operid)) {
      return JsonResult.error("账号重复");
    }
    return JsonResult.ok("success");
  }

  @PostMapping("/add")
  @ResponseBody
  public JsonResult add(@RequestParam("operid") String operid, @RequestParam("opercode") String opercode,
                        @RequestParam("opername") String opername, @RequestParam("sex") String sex,
                        @RequestParam("mobile") String mobile, @RequestParam("email") String email,
                        @RequestParam("roleId") String roleId, Model map) {
    if (true) {
      return JsonResult.ok("添加成功");
    } else {
      return JsonResult.error("添加失败");
    }
  }

  @PostMapping("/update")
  @ResponseBody
  public JsonResult update(TOperator oper, String roleId) {
    oper.setOperpwd(WebConstant.OPERPWD_DEFAULT);
    if (true) {
      return JsonResult.ok("添加成功");
    } else {
      return JsonResult.error("添加失败");
    }
  }


}
