package com.supwisdom.dlpay.system.service.impl;

import com.supwisdom.dlpay.framework.dao.FunctionDao;
import com.supwisdom.dlpay.framework.domain.TFunction;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.system.service.FunctionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class FunctionServiceImpl implements FunctionService {
  @Autowired
  private FunctionDao functionDao;

  @Override
  public List<TFunction> getFunctionsByOperid(String operid) {
    List<TFunction> list = functionDao.getTFunctionsByOperid(StringUtil.isEmpty(operid) ? "" : operid.trim());
    if (!StringUtil.isEmpty(list)) return list;
    return new ArrayList(0);
  }

  @Override
  public List<Map<String, Object>> getMenuTree(List<TFunction> funcList, String parentId) {
    List<Map<String, Object>> list = new ArrayList<>(0);
    for (TFunction func : funcList) {
      if (parentId.equals(func.getParentId())) {
        Map<String, Object> map = new HashMap<>(0);
        map.put("menuName", func.getName());
        map.put("menuIcon", func.getMenuIcon());
        if ("#".equals(func.getMenuUrl())) {
          map.put("menuUrl", "javascript:;");
        } else {
          map.put("menuUrl", func.getMenuUrl());
        }
        map.put("subMenus", getMenuTree(funcList, func.getId()));
        list.add(map);
      }
    }
    return list;
  }
}
