package com.supwisdom.dlpay.system.service.impl;

import com.supwisdom.dlpay.framework.dao.OperatorDao;
import com.supwisdom.dlpay.framework.domain.TOperator;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.framework.util.TradeDict;
import com.supwisdom.dlpay.system.bean.OperatorSearchBean;
import com.supwisdom.dlpay.system.service.OperatorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.List;

@Service
public class OperatorServiceImpl implements OperatorService {
  @Autowired
  private OperatorDao operatorDao;

  @Override
  public PageResult<TOperator> getOperatorsByPage(int pageNo, int pageSize, OperatorSearchBean searchBean) {
    Pageable pageable = PageRequest.of(pageNo - 1, pageSize, Sort.Direction.DESC, "opendate");
    Page<TOperator> page = operatorDao.findAll(new Specification<TOperator>() {
      @Override
      public Predicate toPredicate(Root<TOperator> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
        List<Predicate> predicates = new ArrayList<>();
        if (!StringUtil.isEmpty(searchBean.getOpercode())) {
          predicates.add(criteriaBuilder.equal(root.get("opercode").as(String.class), searchBean.getOpercode().trim()));
        }
        if (!StringUtil.isEmpty(searchBean.getOpername())) {
          predicates.add(criteriaBuilder.like(root.get("opername").as(String.class), "%" + searchBean.getOpername().trim() + "%"));
        }
        if (!StringUtil.isEmpty(searchBean.getMobile())) {
          predicates.add(criteriaBuilder.like(root.get("mobile").as(String.class), "%" + searchBean.getMobile().trim() + "%"));
        }
        if (null != searchBean.getDeleteShow() && !searchBean.getDeleteShow()) {
          predicates.add(criteriaBuilder.equal(root.get("status").as(String.class), TradeDict.STATUS_NORMAL)); //仅显示正常
        }
        return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
      }
    }, pageable);

    return new PageResult<>(page);
  }

  @Override
  public boolean checkOpercodeExists(String opercode, String operid) {
    TOperator oper = operatorDao.findByOpercode(opercode.trim());
    if (null != oper && StringUtil.isEmpty(operid)) return true;
    if (null != oper && !StringUtil.isEmpty(operid) && !operid.trim().equals(oper.getOperid())) return true;
    return false;
  }
}
