package com.supwisdom.dlpay.user.service.impl

import com.supwisdom.dlpay.consume.dao.AccountDao
import com.supwisdom.dlpay.consume.dao.PersonDao
import com.supwisdom.dlpay.consume.domain.TAccount
import com.supwisdom.dlpay.consume.domain.TPerson
import com.supwisdom.dlpay.framework.service.SystemUtilService
import com.supwisdom.dlpay.framework.util.Subject
import com.supwisdom.dlpay.user.service.UserService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

/**
 * Created by shuwei on 2019/4/15.
 */
@Service
class UserServiceImpl : UserService {
    @Autowired
    private lateinit var personDao: PersonDao
    @Autowired
    private lateinit var accountDao: AccountDao
    @Autowired
    private lateinit var systemUtilService: SystemUtilService

    override fun save(person: TPerson): TPerson {
        //TODO check tac
        personDao.save(person)
        if (accountDao.findByUserid(person.userid) == null) {
            val systemdatetime = systemUtilService.sysdatetime
            TAccount().apply {
                accname = person.name
                opendate = systemdatetime.hostdate
                userid = person.userid
                status = person.status
                subjno = Subject.SUBJNO_PERSONAL_DEPOSIT
                balance = 0.0
                availbal = 0.0
                frozebal = 0.0
                lowfreeFlag = false
                accountDao.save(this)
            }
        }
        return person
    }

    override fun findByThirdUniqueIdenty(thirdUniqueIdenty: String): TPerson? {
        return personDao.findByThirdUniqueIdenty(thirdUniqueIdenty)
    }

    override fun findPersonByUserid(userid: String): TPerson? {
        return personDao.getOne(userid)
    }

    override fun findAccountByUserid(userid: String): TAccount? {
        return accountDao.findByUserid(userid)
    }
}