package com.supwisdom.dlpay.api.dao;

import com.supwisdom.dlpay.api.domain.TAccount;
import com.supwisdom.dlpay.api.repositories.TAccountRepository;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.*;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.repository.query.Param;

import javax.persistence.LockModeType;
import javax.persistence.QueryHint;

public interface AccountDao extends JpaRepository<TAccount, String>, TAccountRepository {

  @Lock(LockModeType.PESSIMISTIC_WRITE)
  @Query("select a from TAccount a where a.accno = ?1")
  TAccount getByAccnoForUpdate(String accno);

  @Lock(LockModeType.PESSIMISTIC_WRITE)
  @QueryHints({@QueryHint(name = "javax.persistence.lock.timeout", value = "0")})
  @Query("select a from TAccount a where a.accno = ?1")
  TAccount getByAccnoForUpdateNowait(String accno);

  TAccount findByUserid(String userid);

  @Lock(LockModeType.PESSIMISTIC_WRITE)
  @Query("select a from TAccount a where a.userid = ?1")
  TAccount getByUseridForUpdate(String userid);

  @Lock(LockModeType.PESSIMISTIC_WRITE)
  @QueryHints({@QueryHint(name = "javax.persistence.lock.timeout", value = "0")})
  @Query("select a from TAccount a where a.userid = ?1")
  TAccount getByUseridForUpdateNowait(String userid);

  @Query("select a from TAccount a where a.userid = ?1 and a.subjno=?2")
  TAccount findByUseridAndSubjno(String userid, String subjno);

  @Query("select a from TAccount a where a.person.name like CONCAT('%',:accname,'%') ")
  Page<TAccount> findAllByAccnameContaining(@Param("accname") String accname, Pageable pageable);
}
