package com.supwisdom.dlpay.api.domain;

import javax.persistence.*;

@Entity
@Table(name = "TB_PERSON_IDENTITY")
public class TPersonIdentity {
  @Id
  @Column(name = "THIRD_UID", nullable = false, length = 60)
  private String thirdUid;

  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "USERID")
  private TPerson person; //绑定的系统用户

  @Column(name = "STATUS", nullable = false, length = 20)
  private String status;

  @Column(name = "LOSSFLAG",nullable = false, precision = 1)
  private Integer lossflag=0;

  @Column(name = "LOCKFLAG", nullable = false, precision = 1)
  private Integer lockflag=0;

  @Column(name = "CREATETIME", length = 14)
  private String createtime;

  public TPersonIdentity() {
  }

  public TPersonIdentity(String thirdUid, TPerson person, String status, Integer lossflag, Integer lockflag, String createtime) {
    this.thirdUid = thirdUid;
    this.person = person;
    this.status = status;
    this.lossflag = lossflag;
    this.lockflag = lockflag;
    this.createtime = createtime;
  }

  public String getThirdUid() {
    return thirdUid;
  }

  public void setThirdUid(String thirdUid) {
    this.thirdUid = thirdUid;
  }

  public TPerson getPerson() {
    return person;
  }

  public void setPerson(TPerson person) {
    this.person = person;
  }

  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public Integer getLossflag() {
    return lossflag;
  }

  public void setLossflag(Integer lossflag) {
    this.lossflag = lossflag;
  }

  public Integer getLockflag() {
    return lockflag;
  }

  public void setLockflag(Integer lockflag) {
    this.lockflag = lockflag;
  }

  public String getCreatetime() {
    return createtime;
  }

  public void setCreatetime(String createtime) {
    this.createtime = createtime;
  }

}
