package com.supwisdom.dlpay.framework.domain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name = "TB_SUBJECTBAL")
public class TSubjectbal {
  @Id
  @Column(name = "SUBJNO", nullable = false, length = 10)
  private String subjno;

  @Column(name = "ACCUMDRAMT", precision = 15, scale = 2)
  private Double accumdramt;

  @Column(name = "ACCUMCRAMT", precision = 15, scale = 2)
  private Double accumcramt;

  @Column(name = "BEGINDRBAL", precision = 15, scale = 2)
  private Double begindrbal;

  @Column(name = "BEGINCRBAL", precision = 15, scale = 2)
  private Double begincrbal;

  @Column(name = "DRAMT", precision = 15, scale = 2)
  private Double dramt;

  @Column(name = "CRAMT", precision = 15, scale = 2)
  private Double cramt;

  @Column(name = "DRBAL", precision = 15, scale = 2)
  private Double drbal;

  @Column(name = "CRBAL", precision = 15, scale = 2)
  private Double crbal;

  @Column(name = "UPDTIME", length = 14)
  private String updtime;

  @Column(name = "LASTSETTLEDAY", length = 8)
  private Integer lastsettleday;

  @Column(name = "ACCUMSETTLEAMT", precision = 15, scale = 2)
  private Double accumsettleamt;

  public TSubjectbal() {
  }

  public TSubjectbal(String subjno) {
    this.subjno = subjno;
    this.accumdramt = 0D;
    this.accumcramt = 0D;
    this.begindrbal = 0D;
    this.begincrbal = 0D;
    this.dramt = 0D;
    this.cramt = 0D;
    this.drbal = 0D;
    this.crbal = 0D;
  }

  public TSubjectbal(String subjno, Double accumdramt, Double accumcramt, Double begindrbal, Double begincrbal, Double dramt, Double cramt, Double drbal, Double crbal, String updtime, Integer lastsettleday, Double accumsettleamt) {
    this.subjno = subjno;
    this.accumdramt = accumdramt;
    this.accumcramt = accumcramt;
    this.begindrbal = begindrbal;
    this.begincrbal = begincrbal;
    this.dramt = dramt;
    this.cramt = cramt;
    this.drbal = drbal;
    this.crbal = crbal;
    this.updtime = updtime;
    this.lastsettleday = lastsettleday;
    this.accumsettleamt = accumsettleamt;
  }

  public String getSubjno() {
    return subjno;
  }

  public void setSubjno(String subjno) {
    this.subjno = subjno;
  }

  public Double getAccumdramt() {
    return accumdramt;
  }

  public void setAccumdramt(Double accumdramt) {
    this.accumdramt = accumdramt;
  }

  public Double getAccumcramt() {
    return accumcramt;
  }

  public void setAccumcramt(Double accumcramt) {
    this.accumcramt = accumcramt;
  }

  public Double getBegindrbal() {
    return begindrbal;
  }

  public void setBegindrbal(Double begindrbal) {
    this.begindrbal = begindrbal;
  }

  public Double getBegincrbal() {
    return begincrbal;
  }

  public void setBegincrbal(Double begincrbal) {
    this.begincrbal = begincrbal;
  }

  public Double getDramt() {
    return dramt;
  }

  public void setDramt(Double dramt) {
    this.dramt = dramt;
  }

  public Double getCramt() {
    return cramt;
  }

  public void setCramt(Double cramt) {
    this.cramt = cramt;
  }

  public Double getDrbal() {
    return drbal;
  }

  public void setDrbal(Double drbal) {
    this.drbal = drbal;
  }

  public Double getCrbal() {
    return crbal;
  }

  public void setCrbal(Double crbal) {
    this.crbal = crbal;
  }

  public String getUpdtime() {
    return updtime;
  }

  public void setUpdtime(String updtime) {
    this.updtime = updtime;
  }

  public Integer getLastsettleday() {
    return lastsettleday;
  }

  public void setLastsettleday(Integer lastsettleday) {
    this.lastsettleday = lastsettleday;
  }

  public Double getAccumsettleamt() {
    return accumsettleamt;
  }

  public void setAccumsettleamt(Double accumsettleamt) {
    this.accumsettleamt = accumsettleamt;
  }
}
