package com.supwisdom.dlpay.system.service.impl;

import com.supwisdom.dlpay.api.dao.ShopPaytypeDao;
import com.supwisdom.dlpay.api.domain.TShopPaytype;
import com.supwisdom.dlpay.framework.dao.ShopDao;
import com.supwisdom.dlpay.framework.dao.ShopaccDao;
import com.supwisdom.dlpay.framework.data.SystemDateTime;
import com.supwisdom.dlpay.framework.domain.TShop;
import com.supwisdom.dlpay.framework.domain.TShopacc;
import com.supwisdom.dlpay.framework.service.SystemUtilService;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.framework.util.Subject;
import com.supwisdom.dlpay.framework.util.TradeDict;
import com.supwisdom.dlpay.system.bean.ZTreeNode;
import com.supwisdom.dlpay.system.service.ShopDataService;
import com.supwisdom.dlpay.util.ConstantUtil;
import com.supwisdom.dlpay.util.WebCheckException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class ShopDataServiceImpl implements ShopDataService {
  @Autowired
  private ShopDao shopDao;
  @Autowired
  private ShopaccDao shopaccDao;
  @Autowired
  private ShopPaytypeDao shopPaytypeDao;
  @Autowired
  private SystemUtilService systemUtilService;

  @Override
  public List<ZTreeNode> getAllShopNodes() {
    List<ZTreeNode> result = new ArrayList<>(0);
    List<TShop> shoplist = shopDao.getNormalShops();
    if (!StringUtil.isEmpty(shoplist)) {
      for (TShop shop : shoplist) {
        if (null == shop || !TradeDict.STATUS_NORMAL.equals(shop.getStatus())) continue; //跳过注销商户
        ZTreeNode node = new ZTreeNode();
        node.setId(shop.getShopid().toString());
        node.setName(shop.getShopid()+"_"+shop.getShopname());
        node.setpId(shop.getFshopid() == null ? "" : shop.getFshopid().toString());
        node.setChecked(false);
        node.setOpen(true);
        node.setShoptype(shop.getShoptype());
        node.setIconSkin(shop.getShoptype()==0?"pIcon01":"pIcon02");
        result.add(node);
      }
    }
    return result;
  }

  @Override
  public TShop getShopByShopid(Integer shopid) {
    if (null != shopid) {
      return shopDao.getTShopByShopid(shopid);
    }
    return null;
  }

  @Override
  public boolean deleteShop(TShop shop) throws WebCheckException{
    if(null!=shop){
      List<TShop> childShops = shopDao.getChildShopsByShopid(shop.getShopid());
      if(!StringUtil.isEmpty(childShops))
        throw new WebCheckException("请先删除下级商户");
      shop.setStatus(TradeDict.STATUS_CLOSED);
      shop.setClosedate(systemUtilService.getSysdatetime().getHostdate());
      shopDao.save(shop);
      if(!StringUtil.isEmpty(shop.getShopaccno())){
        TShopacc shopacc=shopaccDao.getByShopaccno(shop.getShopaccno());
        if(null==shopacc) throw new WebCheckException("数据异常！对应的商户账户不存在！");
        shopacc.setStatus(TradeDict.STATUS_CLOSED);
        shopacc.setClosedate(shop.getClosedate());
        shopaccDao.save(shopacc);
      }
      return true;
    }
    return false;
  }

  @Override
  public boolean saveOrUpdateShop(TShop shop) throws WebCheckException {
    if (shop.getFshopid() != 0) {
      TShop fshop = shopDao.getTShopByShopid(shop.getFshopid());
      if (null == fshop) {
        throw new WebCheckException("上级商户不存在！");
      }else if(fshop.getShoptype()==1){
        throw new WebCheckException("上级商户不是商户组！");
      }
    }
    if (shopDao.checkShopnameExist(shop.getShopname(), shop.getFshopid(), shop.getShopid() == null ? 0 : shop.getShopid()) > 0) {
      throw new WebCheckException("商户名称在同级下已经存在！");
    }
    if (null != shop.getShopid() && shop.getShopid() > 0) {
      //修改
      shopDao.save(shop);
      if (!StringUtil.isEmpty(shop.getShopaccno())) {
        shopaccDao.updateShopnameByShopaccno(shop.getShopname(), shop.getShopaccno()); //更新商户名
      }
      return true;
    } else {
      //新增
      SystemDateTime dt = systemUtilService.getSysdatetime();
      shop.setOpendate(dt.getHostdate());
      shopDao.save(shop);
      if (shop.getShoptype() == 1) {
        TShopacc shopacc = new TShopacc();
        shopacc.setShopaccno(String.format("2%09d", shop.getShopid()));
        shopacc.setShopid(shop.getShopid());
        shopacc.setShopname(shop.getShopname());
        shopacc.setSubjno(Subject.SUBJNO_MACHANT_INCOME);
        shopacc.setStatus(TradeDict.STATUS_NORMAL);
        shopacc.setOpendate(dt.getHostdate());
        shopacc.setBalance(0D);
        shopaccDao.save(shopacc);

        TShopPaytype shopPaytype = new TShopPaytype();
        shopPaytype.setShopaccno(shopacc.getShopaccno());
        shopPaytype.setPaytype(TradeDict.PAYTYPE_BALANCE);
        shopPaytype.setConsumeEnable(ConstantUtil.ENABLE_YES);
        shopPaytype.setAnonymousEnable(ConstantUtil.ENABLE_NO);
        shopPaytype.setReverseEnable(ConstantUtil.ENABLE_NO);
        shopPaytype.setCreatetime(dt.getHostdatetime());
        shopPaytypeDao.save(shopPaytype); //默认增加余额支付方式
      }
      return true;
    }
  }


}
