package com.supwisdom.dlpay.framework.domain;

import com.supwisdom.dlpay.framework.util.TradeDict;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

import javax.persistence.*;
import java.util.Collection;

@Entity
@Table(name = "TB_OPERATOR",
    indexes = {@Index(name = "opercode_idx", columnList = "OPERCODE", unique = true)})
public class TOperator implements UserDetails {
  @Id
  @GenericGenerator(name = "idGenerator", strategy = "uuid")
  @GeneratedValue(generator = "idGenerator")
  @Column(name = "OPERID", nullable = false, length = 32)
  private String operid;

  @Column(name = "OPERCODE", nullable = false, length = 20)
  private String opercode;

  @Column(name = "OPERTYPE", nullable = false, length = 20)
  private String opertype;

  @Column(name = "OPERNAME", nullable = false, length = 100)
  private String opername;

  @Column(name = "OPERPWD", nullable = false, length = 80)
  private String operpwd;

  @Column(name = "STATUS", nullable = false, length = 32)
  private String status;

  @Column(name = "OPENDATE", length = 8)
  private String opendate;

  @Column(name = "CLOSEDATE", length = 8)
  private String closedate;

  @Transient
  private Collection<? extends GrantedAuthority> authorities;  //权限

  public TOperator() {
  }

  public TOperator(String opercode, String opername) {
    this.opercode = opercode;
    this.opername = opername;
  }

  public TOperator(String opercode, String opertype, String opername, String operpwd, String status, String opendate, String closedate, Collection<? extends GrantedAuthority> authorities) {
    this.opercode = opercode;
    this.opertype = opertype;
    this.opername = opername;
    this.operpwd = operpwd;
    this.status = status;
    this.opendate = opendate;
    this.closedate = closedate;
    this.authorities = authorities;
  }

  public String getOperid() {
    return operid;
  }

  public void setOperid(String operid) {
    this.operid = operid;
  }

  public String getOpercode() {
    return opercode;
  }

  public void setOpercode(String opercode) {
    this.opercode = opercode;
  }

  public String getOpertype() {
    return opertype;
  }

  public void setOpertype(String opertype) {
    this.opertype = opertype;
  }

  public String getOpername() {
    return opername;
  }

  public void setOpername(String opername) {
    this.opername = opername;
  }

  public String getOperpwd() {
    return operpwd;
  }

  public void setOperpwd(String operpwd) {
    this.operpwd = operpwd;
  }

  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public String getOpendate() {
    return opendate;
  }

  public void setOpendate(String opendate) {
    this.opendate = opendate;
  }

  public String getClosedate() {
    return closedate;
  }

  public void setClosedate(String closedate) {
    this.closedate = closedate;
  }

  public void setAuthorities(Collection<? extends GrantedAuthority> authorities) {
    this.authorities = authorities;
  }

  @Override
  public Collection<? extends GrantedAuthority> getAuthorities() {
    return this.authorities;
  }

  @Override
  public String getPassword() {
    return this.operpwd;
  }

  @Override
  public String getUsername() {
    return this.opercode;
  }

  @Override
  public boolean isAccountNonExpired() {
    return true; //账户不会过期
  }

  @Override
  public boolean isAccountNonLocked() {
    return !TradeDict.STATUS_LOCKED.equals(this.status); //true - 没锁定
  }

  @Override
  public boolean isCredentialsNonExpired() {
    return true; //TODO:密码是否未过期
  }

  @Override
  public boolean isEnabled() {
    return !TradeDict.STATUS_CLOSED.equals(this.status);  //注销操作员不启用
  }
}
