package com.supwisdom.dlpay.framework.domain;


import javax.persistence.*;

@Entity
@Table(name = "TB_SHOP")
public class TShop {

  @Id
  @SequenceGenerator(name = "shopid", sequenceName = "SEQ_SHOP", allocationSize = 1)
  @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "shopid")
  @Column(name="SHOPID", nullable = false, precision = 9)
  private Integer shopid;

  @Column(name="FSHOPID", precision = 9)
  private Integer fshopid;

  @Column(name="SHOPNAME", length = 200)
  private String shopname;

  @Column(name = "SHOPTYPE", precision = 1)
  private Integer shoptype;

  @Column(name="STATUS", length = 20)
  private String status;

  @Column(name="SHOPACCNO", length = 20)
  private String shopaccno;

  @Column(name="CONTACTMAN", length = 60)
  private String contactman;

  @Column(name="IDTYPE", length = 1)
  private String idtype;

  @Column(name="IDNO", length = 60)
  private String idno;

  @Column(name="TEL", length = 20)
  private String tel;

  @Column(name="MOBILE", length = 30)
  private String mobile;

  @Column(name="EMAIL", length = 60)
  private String email;

  @Column(name="ADDR", length = 240)
  private String addr;

  @Column(name="ZIPCODE", length = 10)
  private String zipcode;

  @Column(name="OPENDATE", length = 8)
  private String opendate;

  @Column(name="CLOSEDATE", length = 8)
  private String closedate;

  /**
   * 第三方唯一ID
   * */
  @Column(name="THIRD_UNIQUE_IDENTY", length = 40)
  private String thirdUniqueIdenty;

  public String getThirdUniqueIdenty() {
    return thirdUniqueIdenty;
  }

  public void setThirdUniqueIdenty(String thirdUniqueIdenty) {
    this.thirdUniqueIdenty = thirdUniqueIdenty;
  }

  public Integer getShopid() {
    return shopid;
  }

  public void setShopid(Integer shopid) {
    this.shopid = shopid;
  }

  public Integer getFshopid() {
    return fshopid;
  }

  public void setFshopid(Integer fshopid) {
    this.fshopid = fshopid;
  }

  public String getShopname() {
    return shopname;
  }

  public void setShopname(String shopname) {
    this.shopname = shopname;
  }

  public Integer getShoptype() {
    return shoptype;
  }

  public void setShoptype(Integer shoptype) {
    this.shoptype = shoptype;
  }

  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public String getShopaccno() {
    return shopaccno;
  }

  public void setShopaccno(String shopaccno) {
    this.shopaccno = shopaccno;
  }

  public String getContactman() {
    return contactman;
  }

  public void setContactman(String contactman) {
    this.contactman = contactman;
  }

  public String getIdtype() {
    return idtype;
  }

  public void setIdtype(String idtype) {
    this.idtype = idtype;
  }

  public String getIdno() {
    return idno;
  }

  public void setIdno(String idno) {
    this.idno = idno;
  }

  public String getTel() {
    return tel;
  }

  public void setTel(String tel) {
    this.tel = tel;
  }

  public String getMobile() {
    return mobile;
  }

  public void setMobile(String mobile) {
    this.mobile = mobile;
  }

  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  public String getAddr() {
    return addr;
  }

  public void setAddr(String addr) {
    this.addr = addr;
  }

  public String getZipcode() {
    return zipcode;
  }

  public void setZipcode(String zipcode) {
    this.zipcode = zipcode;
  }

  public String getOpendate() {
    return opendate;
  }

  public void setOpendate(String opendate) {
    this.opendate = opendate;
  }

  public String getClosedate() {
    return closedate;
  }

  public void setClosedate(String closedate) {
    this.closedate = closedate;
  }
}
