package com.supwisdom.dlpay.framework.domain;

import javax.persistence.*;

@Entity
@Table(name = "TB_SHOPACCDAY")
@IdClass(TShopaccdayPK.class)
public class TShopaccday {
  @Id
  @Column(name="ACCDATE", nullable = false, length = 8)
  private String accdate;

  @Id
  @Column(name="SHOPACCNO", nullable = false, length = 10)
  private String shopaccno;

  @Column(name="PERIOD_YEAR", precision = 8)
  private Integer periodYear;

  @Column(name="PERIOD_MONTH", precision = 2)
  private Integer periodMonth;

  @Column(name="BEGINBAL", precision = 15, scale = 2)
  private Double beginbal;

  @Column(name="DRAMT", precision = 15, scale = 2)
  private Double dramt;

  @Column(name="CRAMT", precision = 15, scale = 2)
  private Double cramt;

  @Column(name="BALANCE", precision = 15, scale = 2)
  private Double balance;

  @Column(name="UPDTIME", precision = 15, scale = 2)
  private String updtime;

  public TShopaccday() {
  }

  public TShopaccday(String accdate, String shopaccno, Integer periodYear, Integer periodMonth, Double beginbal, Double dramt, Double cramt, Double balance) {
    this.accdate = accdate;
    this.shopaccno = shopaccno;
    this.periodYear = periodYear;
    this.periodMonth = periodMonth;
    this.beginbal = beginbal;
    this.dramt = dramt;
    this.cramt = cramt;
    this.balance = balance;
  }

  public TShopaccday(String accdate, String shopaccno, Integer periodYear, Integer periodMonth, Double beginbal, Double dramt, Double cramt, Double balance, String updtime) {
    this.accdate = accdate;
    this.shopaccno = shopaccno;
    this.periodYear = periodYear;
    this.periodMonth = periodMonth;
    this.beginbal = beginbal;
    this.dramt = dramt;
    this.cramt = cramt;
    this.balance = balance;
    this.updtime = updtime;
  }

  public String getAccdate() {
    return accdate;
  }

  public void setAccdate(String accdate) {
    this.accdate = accdate;
  }

  public String getShopaccno() {
    return shopaccno;
  }

  public void setShopaccno(String shopaccno) {
    this.shopaccno = shopaccno;
  }

  public Integer getPeriodYear() {
    return periodYear;
  }

  public void setPeriodYear(Integer periodYear) {
    this.periodYear = periodYear;
  }

  public Integer getPeriodMonth() {
    return periodMonth;
  }

  public void setPeriodMonth(Integer periodMonth) {
    this.periodMonth = periodMonth;
  }

  public Double getBeginbal() {
    return beginbal;
  }

  public void setBeginbal(Double beginbal) {
    this.beginbal = beginbal;
  }

  public Double getDramt() {
    return dramt;
  }

  public void setDramt(Double dramt) {
    this.dramt = dramt;
  }

  public Double getCramt() {
    return cramt;
  }

  public void setCramt(Double cramt) {
    this.cramt = cramt;
  }

  public Double getBalance() {
    return balance;
  }

  public void setBalance(Double balance) {
    this.balance = balance;
  }

  public String getUpdtime() {
    return updtime;
  }

  public void setUpdtime(String updtime) {
    this.updtime = updtime;
  }
}
