package com.supwisdom.dlpay.framework.util;

import org.apache.log4j.Logger;
import org.springframework.util.Assert;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
  private static final Logger logger = Logger.getLogger(DateUtil.class);

  private static final DateFormat dateTimeFormat = new SimpleDateFormat("yyyyMMddHHmmss");

  private static final DateFormat dayFormat = new SimpleDateFormat("yyyyMMdd");

  /**
   * Description: 返回一个当前时间 @return String 格式：yyyyMMddHHmmss @exception Modify
   * History:
   */
  public static String getNow() {
    return dateTimeFormat.format(new Date());
  }


  /**
   * Description: 根据类型返回一个当前时间 @param partten String @return String 格式：partten
   */
  public static String getNow(String partten) {
    java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(partten);
    return sdf.format(new Date());
  }

  /**
   * Description: 得到一个特殊的时间 @param startTime String 格式：yyyyMMddHHmmss @param
   * interval int 秒 @return String 格式：partten @exception Modify History:
   */
  public static String getNewTime(String startTime, int interval) {
    try {
      Date d = dateTimeFormat.parse(startTime);
      Calendar calendar = Calendar.getInstance();
      calendar.setTimeInMillis(d.getTime());
      calendar.add(Calendar.SECOND, interval);
      return dateTimeFormat.format(calendar.getTime());
    } catch (ParseException e) {
      return startTime;
    }
  }

  /**
   * Description: 得到一个特殊的时间 @param startTime String 格式：partten @param
   * interval int 秒 @return String 格式：partten @exception Modify History:
   */
  public static String getNewTime(String startTime, int interval, String partten) {
    try {
      java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(partten);
      Date d = sdf.parse(startTime);
      Calendar calendar = Calendar.getInstance();
      calendar.setTimeInMillis(d.getTime());
      calendar.add(Calendar.SECOND, interval);
      return sdf.format(calendar.getTime());
    } catch (ParseException e) {
      return startTime;
    }
  }

  public static String getNewDay(String startDay, int intervalday) {
    try {
      Date d = dayFormat.parse(startDay);
      Calendar calendar = Calendar.getInstance();
      calendar.setTimeInMillis(d.getTime());
      calendar.add(Calendar.DATE, intervalday);
      return dayFormat.format(calendar.getTime());
    } catch (ParseException e) {
      return startDay;
    }
  }

  /**
   * 得到两个日期相差的天数 格式 yyyyMMdd @return diffdays = secondDay - firstDay
   */
  public static long getIntervalDay(String firstDay, String secondDay) {
    try {
      Date f = dayFormat.parse(firstDay);
      Date s = dayFormat.parse(secondDay);
      long time = s.getTime() - f.getTime();
      return time / (24 * 60 * 60 * 1000);
    } catch (ParseException e) {
      return 0;
    }
  }

  /**
   * Description: 比较两个时间字符串的前后关系 @param firstTime String 格式：yyyyMMddHHmmss
   *
   * @param secondTime String 格式: yyyyMMddHHmmss @return int |
   * firstTime=second int=0 | firstTime>secondTime int>0 |
   * firstTime<secondTime int<0 @exception Modify History:
   */
  public static int compareDatetime(String firstTime, String secondTime) {
    try {
      Date f = dateTimeFormat.parse(firstTime);
      Date s = dateTimeFormat.parse(secondTime);
      return f.compareTo(s);
    } catch (ParseException e) {
      return 0;
    }
  }

  /**
   * Description: 比较两个时间字符串的前后关系 @param firstTime String 格式：pattern
   * @param secondTime String 格式: yyyyMMddHHmmss @return int |
   * firstTime=second int=0 | firstTime>secondTime int>0 |
   * firstTime<secondTime int<0 @exception Modify History:
   */
  public static int compareDatetime(String firstTime, String secondTime, String pattern) {
    try {
      java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(pattern);
      Date f = sdf.parse(firstTime);
      Date s = sdf.parse(secondTime);
      return f.compareTo(s);
    } catch (ParseException e) {
      return 0;
    }
  }

  /**
   * Description: 比较两个时间字符串的时间差 @param firstTime String 格式：yyyyMMddHHmmss
   *
   * @param secondTime String 格式: yyyyMMddHHmmss @param second int 格式 @return
   * int | firstTime+seconds=secondTime int=0 | firstTime+seconds>secondTime
   * int>0 | firstTime+seconds<secondTime int<0 @exception Modify History:
   */
  public static int compareDatetime(String firstTime, String secondTime, int seconds) {
    try {
      Date f = dateTimeFormat.parse(firstTime);
      Date s = dateTimeFormat.parse(secondTime);
      Calendar calendar = Calendar.getInstance();
      calendar.setTimeInMillis(f.getTime());
      calendar.add(Calendar.SECOND, seconds);
      Date temp = calendar.getTime();
      return temp.compareTo(s);
    } catch (Exception e) {
      return 0;
    }
  }

  /**
   * Description: 对time重新格式化
   */
  public static String reformatDatetime(String time, String fromPattern, String toPattern) {
    try {
      java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(fromPattern);
      Date d = sdf.parse(time);
      Calendar calendar = Calendar.getInstance();
      calendar.setTimeInMillis(d.getTime());
      sdf = new SimpleDateFormat(toPattern);
      return sdf.format(calendar.getTime());
    } catch (Exception e) {
      e.printStackTrace();
      return time;
    }
  }

  /**
   * 获得两个字符串日期之间的时间差(单位毫秒) 格式 yyyyMMddHHmmss
   */
  public static long getInterval(String startTime, String endTime) {
    long duration = 0;
    try {
      duration = dateTimeFormat.parse(endTime).getTime() - dateTimeFormat.parse(startTime).getTime();
    } catch (ParseException e) {
      logger.error("Hi guys,there is an error when you try to parse the date string");
    }
    return duration;
  }

  /**
   * 获得两个字符串日期之间的时间差(单位毫秒)
   * */
  public static long getIntervalTime(String startTime, String endTime, String pattern) {
    long duration = 0;
    try {
      java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(pattern);
      duration = sdf.parse(endTime).getTime() - sdf.parse(startTime).getTime();
    } catch (ParseException e) {
      logger.error("Hi guys,there is an error when you try to parse the date string");
    }
    return duration;
  }

  /**
   * 转换成日期格式
   * 短格式：20140401 -> 2014-04-01
   * 中格式：201404011200 -> 2014-04-01 12:00
   * 长格式：20140401123025 -> 2014-04-01 12:30:25
   * **/
  public static String parseToDateFormat(String str){
    switch(str.length()){
      case 8:
        str = str.substring(0, 4)+"-"+str.substring(4, 6)+"-"+str.substring(6, 8);
        break;
      case 12:
        str = str.substring(0, 4)+"-"+str.substring(4, 6)+"-"+str.substring(6, 8)+" "+str.substring(8, 10)+":"+str.substring(10, 12);
        break;
      case 14:
        str = str.substring(0, 4)+"-"+str.substring(4, 6)+"-"+str.substring(6, 8)+" "+str.substring(8, 10)+":"+str.substring(10, 12)+":"+str.substring(12, 14);
        break;
      default:
        break;
    }
    return str;
  }

  /**
   * 解日期格式
   * 短格式：2014-04-01 -> 20140401
   * 中格式：2014-04-01 12:00 -> 201404011200
   * 长格式：2014-04-01 12:30:25 -> 20140401123025
   * **/
  public static String unParseToDateFormat(String str){
    return str.replaceAll("-", "").replaceAll(" ", "").replaceAll(":", "");
  }

  /**
   * 检验时间格式
   * */
  public static boolean checkDatetimeValid(String datetime, String pattern) {
    if (null == datetime) return false;
    try {
      java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(pattern);
      Date d = sdf.parse(datetime);
      return true;
    } catch (Exception e) {
    }
    return false;
  }

  /**
   * 获取指定日期是星期几 格式 yyyyMMdd
   * MON|TUE|WED|THU|FRI|SAT|SUN
   * 	1		2		3		4		5		6		7
   * */
  public static int getWeekday(String datestr) {
    try {
      Calendar calendar = Calendar.getInstance();
      boolean isFirstSunday = (calendar.getFirstDayOfWeek() == Calendar.SUNDAY); //一周第一天是否为星期天
      Date d = dayFormat.parse(datestr);
      calendar.setTimeInMillis(d.getTime());
      int weekDay = calendar.get(calendar.DAY_OF_WEEK);
      if (isFirstSunday) {
        weekDay = weekDay - 1;
        if (weekDay == 0) {
          weekDay = 7;
        }
      }
      return weekDay;
    } catch (Exception e) {
      return -1;
    }
  }

  /**
   * 获取指定日期
   */
  public static Date getSpecifyDate(String datestr, String pattern) {
    try {
      java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(pattern);
      Date result = sdf.parse(datestr);
      return result;
    } catch (Exception e) {
      return new Date();
    }
  }

  public static Integer getLastDayOfMonth(Integer year,Integer month){
    Calendar cal = Calendar.getInstance();
    cal.set(Calendar.YEAR, year);
    cal.set(Calendar.MONTH, month-1);
    cal.set(Calendar.DAY_OF_MONTH,cal.getActualMaximum(Calendar.DATE));
    String str = new SimpleDateFormat( "yyyyMMdd ").format(cal.getTime()).toString();
    Integer result = Integer.parseInt(str.substring(0,4) + str.substring(4,6) + str.substring(6,8));
    return result;
  }

  private static Date set(Date date, int calendarField, int amount) {
    Calendar c = Calendar.getInstance();
    c.setLenient(false);
    c.setTime(date);
    c.add(calendarField, amount);
    return c.getTime();
  }


  public static Date setMinutes(Date date, int amount) {
    return set(date, Calendar.MINUTE, amount);
  }


  public static long getNowSecond() {
    Calendar calendar = Calendar.getInstance();
    return calendar.getTimeInMillis() / 1000;
  }


}
