package com.supwisdom.dlpay.system.service.impl

import com.jcabi.manifests.Manifests
import com.supwisdom.dlpay.framework.dao.FunctionDao
import com.supwisdom.dlpay.framework.domain.TFunction
import com.supwisdom.dlpay.system.service.CommonService
import com.supwisdom.dlpay.system.service.FunctionService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service
import java.util.HashMap

@Service
class CommonServiceImpl : CommonService {
    override fun getSystemVersion(): String {
        try {
            return Manifests.read("Payapi-Version") ?: "version 1.0"
        } catch (ex: Exception) {
            ex.printStackTrace()
            return "unknown"
        }
    }
}

@Service
class FunctionServiceImpl : FunctionService {
    @Autowired
    lateinit var functionDao: FunctionDao

    override fun getFunctionsByOperid(operid: String): List<TFunction> {
        return functionDao.getTFunctionsByOperid(operid) ?: ArrayList(0)
    }

    override fun getMenuTree(funcList: List<TFunction>, parentId: String): List<Map<String, Any>> {
        val list = java.util.ArrayList<Map<String, Any>>()
        for (func in funcList) {
            if (parentId == func.parentId) {
                val map = HashMap<String, Any>()
                map["menuName"] = func.name
                map["menuIcon"] = func.menuIcon
                if ("#" == func.menuUrl) {
                    map["menuUrl"] = "javascript:;"
                } else {
                    map["menuUrl"] = func.menuUrl
                }
                map["subMenus"] = getMenuTree(funcList, func.id)
                list.add(map)
            }
        }
        return list
    }

}